/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jabref.model.FieldChange;
import org.jabref.model.cleanup.CleanupJob;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FileFieldWriter;
import org.jabref.model.entry.LinkedFile;

public class UpgradePdfPsToFileCleanup
implements CleanupJob {
    private final Map<String, String> fields = new HashMap<String, String>();

    public UpgradePdfPsToFileCleanup() {
        this.fields.put("pdf", "PDF");
        this.fields.put("ps", "PostScript");
    }

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        String oldFileContent = entry.getField("file").orElse(null);
        ArrayList<LinkedFile> fileList = new ArrayList<LinkedFile>(entry.getFiles());
        int oldItemCount = fileList.size();
        for (Map.Entry<String, String> field2 : this.fields.entrySet()) {
            entry.getField(field2.getKey()).ifPresent(o -> {
                if (o.trim().isEmpty()) {
                    return;
                }
                File f = new File((String)o);
                LinkedFile flEntry = new LinkedFile(f.getName(), (String)o, (String)field2.getValue());
                fileList.add(flEntry);
                entry.clearField((String)field2.getKey());
                changes.add(new FieldChange(entry, (String)field2.getKey(), (String)o, null));
            });
        }
        if (fileList.size() != oldItemCount) {
            String newValue = FileFieldWriter.getStringRepresentation(fileList);
            entry.setField("file", newValue);
            changes.add(new FieldChange(entry, "file", oldFileContent, newValue));
        }
        return changes;
    }
}

