/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.search.rules.describer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jabref.gui.search.rules.describer.ContainsAndRegexBasedSearchRuleDescriber;
import org.jabref.gui.search.rules.describer.SearchDescriber;
import org.jabref.gui.util.TooltipTextUtil;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.search.rules.GrammarBasedSearchRule;
import org.jabref.model.strings.StringUtil;
import org.jabref.search.SearchBaseVisitor;
import org.jabref.search.SearchParser;

public class GrammarBasedSearchRuleDescriber
implements SearchDescriber {
    private final boolean caseSensitive;
    private final boolean regExp;
    private final ParseTree parseTree;

    public GrammarBasedSearchRuleDescriber(boolean caseSensitive, boolean regExp, ParseTree parseTree) {
        this.caseSensitive = caseSensitive;
        this.regExp = regExp;
        this.parseTree = Objects.requireNonNull(parseTree);
    }

    @Override
    public TextFlow getDescription() {
        TextFlow textFlow = new TextFlow();
        DescriptionSearchBaseVisitor descriptionSearchBaseVisitor = new DescriptionSearchBaseVisitor();
        textFlow.getChildren().add((Object)TooltipTextUtil.createText(String.format("%s ", Localization.lang("This search contains entries in which", new String[0])), TooltipTextUtil.TextType.NORMAL));
        textFlow.getChildren().addAll((Collection)descriptionSearchBaseVisitor.visit(this.parseTree));
        textFlow.getChildren().add((Object)TooltipTextUtil.createText(". ", TooltipTextUtil.TextType.NORMAL));
        textFlow.getChildren().add((Object)TooltipTextUtil.createText(this.caseSensitive ? Localization.lang("The search is case sensitive.", new String[0]) : Localization.lang("The search is case insensitive.", new String[0]), TooltipTextUtil.TextType.NORMAL));
        return textFlow;
    }

    private class DescriptionSearchBaseVisitor
    extends SearchBaseVisitor<List<Text>> {
        private DescriptionSearchBaseVisitor() {
        }

        @Override
        public List<Text> visitStart(SearchParser.StartContext context) {
            return (List)this.visit(context.expression());
        }

        @Override
        public List<Text> visitUnaryExpression(SearchParser.UnaryExpressionContext context) {
            List textList = (List)this.visit(context.expression());
            textList.add(0, TooltipTextUtil.createText(Localization.lang("not", new String[0]).concat(" "), TooltipTextUtil.TextType.NORMAL));
            return textList;
        }

        @Override
        public List<Text> visitParenExpression(SearchParser.ParenExpressionContext context) {
            ArrayList<Text> textList = new ArrayList<Text>();
            textList.add(TooltipTextUtil.createText(String.format("%s", context.expression()), TooltipTextUtil.TextType.NORMAL));
            return textList;
        }

        @Override
        public List<Text> visitBinaryExpression(SearchParser.BinaryExpressionContext context) {
            List textList = (List)this.visit(context.left);
            if ("AND".equalsIgnoreCase(context.operator.getText())) {
                textList.add(TooltipTextUtil.createText(String.format(" %s ", Localization.lang("and", new String[0])), TooltipTextUtil.TextType.NORMAL));
            } else {
                textList.add(TooltipTextUtil.createText(String.format(" %s ", Localization.lang("or", new String[0])), TooltipTextUtil.TextType.NORMAL));
            }
            textList.addAll((Collection)this.visit(context.right));
            return textList;
        }

        @Override
        public List<Text> visitComparison(SearchParser.ComparisonContext context) {
            String temp;
            ArrayList<Text> textList = new ArrayList<Text>();
            Optional<SearchParser.NameContext> fieldDescriptor = Optional.ofNullable(context.left);
            String value = StringUtil.unquote(context.right.getText(), '\"');
            if (!fieldDescriptor.isPresent()) {
                TextFlow description = new ContainsAndRegexBasedSearchRuleDescriber(GrammarBasedSearchRuleDescriber.this.caseSensitive, GrammarBasedSearchRuleDescriber.this.regExp, value).getDescription();
                description.getChildren().forEach(it -> textList.add((Text)it));
                return textList;
            }
            String field2 = StringUtil.unquote(fieldDescriptor.get().getText(), '\"');
            GrammarBasedSearchRule.ComparisonOperator operator = GrammarBasedSearchRule.ComparisonOperator.build(context.operator.getText());
            boolean regExpFieldSpec = !Pattern.matches("\\w+", field2);
            String string = temp = regExpFieldSpec ? Localization.lang("any field that matches the regular expression <b>%0</b>", new String[0]) : Localization.lang("the field <b>%0</b>", new String[0]);
            if (operator == GrammarBasedSearchRule.ComparisonOperator.CONTAINS) {
                temp = GrammarBasedSearchRuleDescriber.this.regExp ? Localization.lang("%0 contains the regular expression <b>%1</b>", temp) : Localization.lang("%0 contains the term <b>%1</b>", temp);
            } else if (operator == GrammarBasedSearchRule.ComparisonOperator.EXACT) {
                temp = GrammarBasedSearchRuleDescriber.this.regExp ? Localization.lang("%0 matches the regular expression <b>%1</b>", temp) : Localization.lang("%0 matches the term <b>%1</b>", temp);
            } else if (operator == GrammarBasedSearchRule.ComparisonOperator.DOES_NOT_CONTAIN) {
                temp = GrammarBasedSearchRuleDescriber.this.regExp ? Localization.lang("%0 doesn't contain the regular expression <b>%1</b>", temp) : Localization.lang("%0 doesn't contain the term <b>%1</b>", temp);
            } else {
                throw new IllegalStateException("CANNOT HAPPEN!");
            }
            List<Text> formattedTexts = TooltipTextUtil.formatToTexts(temp, new TooltipTextUtil.TextReplacement("<b>%0</b>", field2, TooltipTextUtil.TextType.BOLD), new TooltipTextUtil.TextReplacement("<b>%1</b>", value, TooltipTextUtil.TextType.BOLD));
            textList.addAll(formattedTexts);
            return textList;
        }
    }
}

