/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.search;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumnModel;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.GUIGlobals;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.PreviewPanel;
import org.jabref.gui.TransferableBibtexEntry;
import org.jabref.gui.customjfx.CustomJFXPanel;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.externalfiletype.ExternalFileMenuItem;
import org.jabref.gui.filelist.FileListEntry;
import org.jabref.gui.filelist.FileListTableModel;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.maintable.MainTableNameFormatter;
import org.jabref.gui.renderer.GeneralRenderer;
import org.jabref.gui.util.comparator.IconComparator;
import org.jabref.logic.bibtex.comparator.EntryComparator;
import org.jabref.logic.bibtex.comparator.FieldComparator;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.search.SearchQuery;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FieldProperty;
import org.jabref.model.entry.InternalBibtexFields;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.SearchPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultFrame {
    private static final String[] FIELDS = new String[]{"author", "title", "year", "journal"};
    private static final int DATABASE_COL = 0;
    private static final int FILE_COL = 1;
    private static final int URL_COL = 2;
    private static final int PAD = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchResultFrame.class);
    private final JabRefFrame frame;
    private JFrame searchResultFrame;
    private final JLabel fileLabel = new JLabel(IconTheme.JabRefIcon.FILE.getSmallIcon());
    private final JLabel urlLabel = new JLabel(IconTheme.JabRefIcon.WWW.getSmallIcon());
    private final JSplitPane contentPane = new JSplitPane(0);
    private final EventList<BibEntry> entries = new BasicEventList<BibEntry>();
    private final Map<BibEntry, BasePanel> entryHome = new HashMap<BibEntry, BasePanel>();
    private DefaultEventTableModel<BibEntry> model;
    private SortedList<BibEntry> sortedEntries;
    private JTable entryTable;
    private PreviewPanel preview;
    private SearchQuery searchQuery;
    private boolean globalSearch;

    public SearchResultFrame(JabRefFrame frame, String title, SearchQuery searchQuery, boolean globalSearch) {
        this.frame = Objects.requireNonNull(frame);
        this.searchQuery = searchQuery;
        this.globalSearch = globalSearch;
        frame.getGlobalSearchBar().setSearchResultFrame(this);
        this.init(Objects.requireNonNull(title));
    }

    private void init(String title) {
        this.searchResultFrame = new JFrame();
        this.searchResultFrame.setTitle(title);
        this.searchResultFrame.setIconImages(IconTheme.getLogoSet());
        this.preview = new PreviewPanel(null, null);
        this.sortedEntries = new SortedList<BibEntry>(this.entries, new EntryComparator(false, true, "author"));
        this.model = (DefaultEventTableModel)GlazedListsSwing.eventTableModelWithThreadProxyList(this.sortedEntries, new EntryTableFormat());
        this.entryTable = new JTable(this.model);
        GeneralRenderer renderer = new GeneralRenderer(Color.white);
        this.entryTable.setDefaultRenderer(JLabel.class, renderer);
        this.entryTable.setDefaultRenderer(String.class, renderer);
        this.setWidths();
        TableComparatorChooser<BibEntry> tableSorter = TableComparatorChooser.install(this.entryTable, this.sortedEntries, AbstractTableComparatorChooser.MULTIPLE_COLUMN_KEYBOARD);
        this.setupComparatorChooser(tableSorter);
        JScrollPane sp2 = new JScrollPane(this.entryTable);
        final DefaultEventSelectionModel selectionModel = (DefaultEventSelectionModel)GlazedListsSwing.eventSelectionModelWithThreadProxyList(this.sortedEntries);
        this.entryTable.setSelectionModel(selectionModel);
        selectionModel.getSelected().addListEventListener(new EntrySelectionListener());
        this.entryTable.addMouseListener(new TableClickListener());
        this.contentPane.setTopComponent(sp2);
        JFXPanel container = CustomJFXPanel.wrap(new Scene((Parent)this.preview));
        this.contentPane.setBottomComponent((Component)container);
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchResultFrame.this.dispose();
            }
        };
        ActionMap actionMap = this.contentPane.getActionMap();
        InputMap inputMap = this.contentPane.getInputMap(2);
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DATABASE), "close");
        actionMap.put("close", closeAction);
        actionMap = this.entryTable.getActionMap();
        inputMap = this.entryTable.getInputMap();
        actionMap.put("selectNextColumnCell", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchResultFrame.this.selectNextEntry();
            }
        });
        actionMap.put("selectPreviousColumnCell", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchResultFrame.this.selectPreviousEntry();
            }
        });
        actionMap.put("selectNextRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchResultFrame.this.selectNextEntry();
            }
        });
        actionMap.put("selectPreviousRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchResultFrame.this.selectPreviousEntry();
            }
        });
        String selectFirst = "selectFirst";
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.SELECT_FIRST_ENTRY), selectFirst);
        actionMap.put(selectFirst, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SearchResultFrame.this.selectFirstEntry();
            }
        });
        String selectLast = "selectLast";
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.SELECT_LAST_ENTRY), selectLast);
        actionMap.put(selectLast, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SearchResultFrame.this.selectLastEntry();
            }
        });
        actionMap.put("copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!selectionModel.getSelected().isEmpty()) {
                    EventList<BibEntry> bes = selectionModel.getSelected();
                    TransferableBibtexEntry trbe = new TransferableBibtexEntry(bes);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trbe, SearchResultFrame.this.frame.getCurrentBasePanel());
                    SearchResultFrame.this.frame.output(Localization.lang("Copied", new String[0]) + ' ' + (bes.size() > 1 ? bes.size() + " " + Localization.lang("entries", new String[0]) : "1 " + Localization.lang("entry", new String[0]) + '.'));
                }
            }
        });
        this.entryTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "Enter");
        actionMap.put("Enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BibEntry entry = (BibEntry)SearchResultFrame.this.sortedEntries.get(SearchResultFrame.this.entryTable.getSelectedRow());
                SearchResultFrame.this.selectEntryInBasePanel(entry);
            }
        });
        this.searchResultFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                SearchResultFrame.this.contentPane.setDividerLocation(0.5);
            }

            @Override
            public void windowClosing(WindowEvent event) {
                SearchResultFrame.this.dispose();
            }
        });
        this.searchResultFrame.getContentPane().add((Component)this.contentPane, "Center");
        SearchPreferences searchPreferences = new SearchPreferences(Globals.prefs);
        this.searchResultFrame.setSize(searchPreferences.getSeachDialogWidth(), searchPreferences.getSeachDialogHeight());
        this.searchResultFrame.setLocation(searchPreferences.getSearchDialogPosX(), searchPreferences.getSearchDialogPosY());
        this.searchResultFrame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                new SearchPreferences(Globals.prefs).setSearchDialogWidth(((SearchResultFrame)SearchResultFrame.this).searchResultFrame.getSize().width).setSearchDialogHeight(((SearchResultFrame)SearchResultFrame.this).searchResultFrame.getSize().height);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                new SearchPreferences(Globals.prefs).setSearchDialogPosX(((SearchResultFrame)SearchResultFrame.this).searchResultFrame.getLocation().x).setSearchDialogPosY(((SearchResultFrame)SearchResultFrame.this).searchResultFrame.getLocation().y);
            }
        });
    }

    public void setVisible(boolean visible) {
        this.searchResultFrame.setVisible(visible);
    }

    public void selectFirstEntry() {
        this.selectEntry(0);
    }

    public void selectLastEntry() {
        this.selectEntry(this.entryTable.getRowCount() - 1);
    }

    public void selectPreviousEntry() {
        this.selectEntry((this.entryTable.getSelectedRow() - 1 + this.entryTable.getRowCount()) % this.entryTable.getRowCount());
    }

    public void selectNextEntry() {
        this.selectEntry((this.entryTable.getSelectedRow() + 1) % this.entryTable.getRowCount());
    }

    public void selectEntry(int index) {
        if (index >= 0 && index < this.entryTable.getRowCount()) {
            this.entryTable.changeSelection(index, 0, false, false);
        } else {
            this.contentPane.setDividerLocation(1.0);
        }
    }

    private void setupComparatorChooser(TableComparatorChooser<BibEntry> comparatorChooser) {
        List<Comparator> comparators;
        int i;
        for (i = 0; i < 3; ++i) {
            comparators = comparatorChooser.getComparatorsForColumn(i);
            comparators.clear();
            if (i == 1) {
                comparators.add(new IconComparator(Collections.singletonList("file")));
                continue;
            }
            if (i == 2) {
                comparators.add(new IconComparator(Collections.singletonList("url")));
                continue;
            }
            if (i != 0) continue;
            comparators.add((entry1, entry2) -> {
                String databaseTitle1 = this.entryHome.get(entry1).getTabTitle();
                String databaseTitle2 = this.entryHome.get(entry2).getTabTitle();
                return databaseTitle1.compareTo(databaseTitle2);
            });
        }
        for (i = 3; i < 3 + FIELDS.length; ++i) {
            comparators = comparatorChooser.getComparatorsForColumn(i);
            comparators.clear();
            comparators.add(new FieldComparator(FIELDS[i - 3]));
        }
        this.sortedEntries.getReadWriteLock().writeLock().lock();
        comparatorChooser.appendComparator(3, 0, false);
        this.sortedEntries.getReadWriteLock().writeLock().unlock();
    }

    private void setWidths() {
        TableColumnModel cm = this.entryTable.getColumnModel();
        block4: for (int i = 0; i < 3 + FIELDS.length; ++i) {
            switch (i) {
                case 1: 
                case 2: {
                    cm.getColumn(i).setPreferredWidth(GUIGlobals.WIDTH_ICON_COL);
                    cm.getColumn(i).setMinWidth(GUIGlobals.WIDTH_ICON_COL);
                    cm.getColumn(i).setMaxWidth(GUIGlobals.WIDTH_ICON_COL);
                    continue block4;
                }
                case 0: {
                    int width = InternalBibtexFields.getFieldLength("author");
                    cm.getColumn(i).setPreferredWidth(width);
                    continue block4;
                }
                default: {
                    int width = InternalBibtexFields.getFieldLength(FIELDS[i - 3]);
                    cm.getColumn(i).setPreferredWidth(width);
                    continue block4;
                }
            }
        }
    }

    public void addEntries(List<BibEntry> newEntries, BasePanel panel) {
        for (BibEntry entry : newEntries) {
            this.addEntry(entry, panel);
        }
    }

    private void addEntry(BibEntry entry, BasePanel panel) {
        this.entries.add(entry);
        this.entryHome.put(entry, panel);
        if (this.preview.getEntry() == null || !this.preview.getBasePanel().isPresent()) {
            this.preview.setEntry(entry);
            this.preview.setBasePanel(panel);
            this.preview.setDatabaseContext(panel.getBibDatabaseContext());
        }
    }

    private void selectEntryInBasePanel(BibEntry entry) {
        BasePanel basePanel = this.entryHome.get(entry);
        this.frame.showBasePanel(basePanel);
        basePanel.requestFocus();
        basePanel.highlightEntry(entry);
    }

    public void dispose() {
        this.frame.getGlobalSearchBar().setSearchResultFrame(null);
        this.searchResultFrame.dispose();
        this.frame.getGlobalSearchBar().focus();
    }

    public void focus() {
        this.entryTable.requestFocus();
    }

    public SearchQuery getSearchQuery() {
        return this.searchQuery;
    }

    public boolean isGlobalSearch() {
        return this.globalSearch;
    }

    private class EntryTableFormat
    implements AdvancedTableFormat<BibEntry> {
        private EntryTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 3 + FIELDS.length;
        }

        @Override
        public String getColumnName(int column) {
            if (column >= 3) {
                return StringUtil.capitalizeFirst(FIELDS[column - 3]);
            }
            if (column == 0) {
                return Localization.lang("Library", new String[0]);
            }
            return "";
        }

        @Override
        public Object getColumnValue(BibEntry entry, int column) {
            if (column < 3) {
                switch (column) {
                    case 0: {
                        return ((BasePanel)SearchResultFrame.this.entryHome.get(entry)).getTabTitle();
                    }
                    case 1: {
                        if (entry.hasField("file")) {
                            FileListTableModel tmpModel = new FileListTableModel();
                            entry.getField("file").ifPresent(tmpModel::setContent);
                            SearchResultFrame.this.fileLabel.setToolTipText(tmpModel.getToolTipHTMLRepresentation());
                            if (tmpModel.getRowCount() > 0) {
                                if (tmpModel.getEntry(0).getType().isPresent()) {
                                    SearchResultFrame.this.fileLabel.setIcon(tmpModel.getEntry(0).getType().get().getIcon());
                                } else {
                                    SearchResultFrame.this.fileLabel.setIcon(IconTheme.JabRefIcon.FILE.getSmallIcon());
                                }
                            }
                            return SearchResultFrame.this.fileLabel;
                        }
                        return null;
                    }
                    case 2: {
                        Optional<String> urlField = entry.getField("url");
                        if (urlField.isPresent()) {
                            SearchResultFrame.this.urlLabel.setToolTipText(urlField.get());
                            return SearchResultFrame.this.urlLabel;
                        }
                        return null;
                    }
                }
                return null;
            }
            String field2 = FIELDS[column - 3];
            String fieldContent = entry.getLatexFreeField(field2).orElse("");
            if (InternalBibtexFields.getFieldProperties(field2).contains((Object)FieldProperty.PERSON_NAMES)) {
                return MainTableNameFormatter.formatName(fieldContent);
            }
            return fieldContent;
        }

        @Override
        public Class<?> getColumnClass(int i) {
            switch (i) {
                case 1: 
                case 2: {
                    return JLabel.class;
                }
            }
            return String.class;
        }

        @Override
        public Comparator<?> getColumnComparator(int i) {
            return null;
        }
    }

    private class EntrySelectionListener
    implements ListEventListener<BibEntry> {
        private EntrySelectionListener() {
        }

        @Override
        public void listChanged(ListEvent<BibEntry> listEvent) {
            if (listEvent.getSourceList().size() == 1) {
                BibEntry entry = (BibEntry)listEvent.getSourceList().get(0);
                BasePanel basePanel = (BasePanel)SearchResultFrame.this.entryHome.get(entry);
                SearchResultFrame.this.preview.setDatabaseContext(basePanel.getBibDatabaseContext());
                SearchResultFrame.this.preview.setEntry(entry);
                SearchResultFrame.this.preview.setBasePanel((BasePanel)SearchResultFrame.this.entryHome.get(entry));
                SearchResultFrame.this.preview.setDatabaseContext(((BasePanel)SearchResultFrame.this.entryHome.get(entry)).getBibDatabaseContext());
                SearchResultFrame.this.contentPane.setDividerLocation(0.5);
            }
        }
    }

    class TableClickListener
    extends MouseAdapter {
        TableClickListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.processPopupTrigger(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.processPopupTrigger(e);
                return;
            }
            int row = SearchResultFrame.this.entryTable.rowAtPoint(e.getPoint());
            if (e.getClickCount() == 2) {
                SearchResultFrame.this.selectEntryInBasePanel((BibEntry)SearchResultFrame.this.model.getElementAt(row));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.processPopupTrigger(e);
                return;
            }
            int col = SearchResultFrame.this.entryTable.columnAtPoint(e.getPoint());
            int row = SearchResultFrame.this.entryTable.rowAtPoint(e.getPoint());
            if (col < 3) {
                BibEntry entry = (BibEntry)SearchResultFrame.this.sortedEntries.get(row);
                BasePanel p = (BasePanel)SearchResultFrame.this.entryHome.get(entry);
                switch (col) {
                    case 1: {
                        if (!entry.hasField("file")) break;
                        FileListTableModel tableModel = new FileListTableModel();
                        entry.getField("file").ifPresent(tableModel::setContent);
                        if (tableModel.getRowCount() == 0) {
                            return;
                        }
                        FileListEntry fl = tableModel.getEntry(0);
                        new ExternalFileMenuItem(SearchResultFrame.this.frame, entry, "", fl.getLink(), null, p.getBibDatabaseContext(), fl.getType()).actionPerformed(null);
                        break;
                    }
                    case 2: {
                        entry.getField("url").ifPresent(link -> {
                            try {
                                JabRefDesktop.openExternalViewer(p.getBibDatabaseContext(), link, "url");
                            }
                            catch (IOException ex) {
                                LOGGER.warn("Could not open viewer", ex);
                            }
                        });
                        break;
                    }
                }
            }
        }

        public void processPopupTrigger(MouseEvent e) {
            BibEntry entry = (BibEntry)SearchResultFrame.this.sortedEntries.get(SearchResultFrame.this.entryTable.rowAtPoint(e.getPoint()));
            BasePanel p = (BasePanel)SearchResultFrame.this.entryHome.get(entry);
            int col = SearchResultFrame.this.entryTable.columnAtPoint(e.getPoint());
            JPopupMenu menu = new JPopupMenu();
            int count = 0;
            if (col == 1) {
                FileListTableModel fileList = new FileListTableModel();
                entry.getField("file").ifPresent(fileList::setContent);
                for (int i = 0; i < fileList.getRowCount(); ++i) {
                    FileListEntry flEntry = fileList.getEntry(i);
                    String description = flEntry.getDescription();
                    if (description == null || description.trim().isEmpty()) {
                        description = flEntry.getLink();
                    }
                    menu.add(new ExternalFileMenuItem(p.frame(), entry, description, flEntry.getLink(), flEntry.getType().get().getIcon(), p.getBibDatabaseContext(), flEntry.getType()));
                    ++count;
                }
            }
            if (count > 0) {
                menu.show(SearchResultFrame.this.entryTable, e.getX(), e.getY());
            }
        }
    }
}

