/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.logging;

import com.microsoft.applicationinsights.log4j.v2.internal.ApplicationInsightsLogEvent;
import com.microsoft.applicationinsights.telemetry.BaseSampleSourceTelemetry;
import com.microsoft.applicationinsights.telemetry.ExceptionTelemetry;
import com.microsoft.applicationinsights.telemetry.TraceTelemetry;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.jabref.Globals;

@Plugin(name="OurApplicationInsightsAppender", category="Core", elementType="appender", printObject=true)
public class ApplicationInsightsAppender
extends AbstractAppender {
    private ApplicationInsightsAppender(String name, Filter filter) {
        super(name, filter, null);
    }

    @PluginFactory
    public static ApplicationInsightsAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filters") Filter filter) {
        return new ApplicationInsightsAppender(name, filter);
    }

    @Override
    public void append(LogEvent rawEvent) {
        BaseSampleSourceTelemetry telemetry;
        ApplicationInsightsLogEvent event = new ApplicationInsightsLogEvent(rawEvent);
        if (event.isException()) {
            ExceptionTelemetry exceptionTelemetry = new ExceptionTelemetry(event.getException());
            exceptionTelemetry.getProperties().put("Message", rawEvent.getMessage().getFormattedMessage());
            exceptionTelemetry.setSeverityLevel(event.getNormalizedSeverityLevel());
            telemetry = exceptionTelemetry;
        } else {
            TraceTelemetry traceTelemetry = new TraceTelemetry(event.getMessage());
            traceTelemetry.setSeverityLevel(event.getNormalizedSeverityLevel());
            telemetry = traceTelemetry;
        }
        telemetry.getContext().getProperties().putAll(event.getCustomParameters());
        Globals.getTelemetryClient().ifPresent(client -> client.track(telemetry));
    }
}

