/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer.actions;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.jabref.gui.BasePanel;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;

public class MergeReviewIntoCommentConfirmationDialog {
    private final BasePanel panel;

    public MergeReviewIntoCommentConfirmationDialog(BasePanel panel) {
        this.panel = panel;
    }

    public boolean askUserForMerge(List<BibEntry> conflicts) {
        String bibKeys = conflicts.stream().map(BibEntry::getCiteKeyOptional).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining(",\n"));
        Object[] options = new String[]{Localization.lang("Merge fields", new String[0])};
        int answer = JOptionPane.showOptionDialog(this.panel, bibKeys + " " + Localization.lang("has/have both a 'Comment' and a 'Review' field.", new String[0]) + "\n" + Localization.lang("Since the 'Review' field was deprecated in JabRef 4.2, these two fields are about to be merged into the 'Comment' field.", new String[0]) + "\n" + Localization.lang("The conflicting fields of these entries will be merged into the 'Comment' field.", new String[0]), Localization.lang("Review Field Migration", new String[0]), -1, 2, null, options, options[0]);
        return 0 == answer;
    }
}

