/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Optional;
import javafx.collections.ObservableList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.actions.BaseAction;
import org.jabref.gui.groups.GroupTreeCellRenderer;
import org.jabref.gui.groups.GroupTreeNodeViewModel;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.GroupTreeNode;

public class GroupAddRemoveDialog
implements BaseAction {
    private final BasePanel panel;
    private final boolean add;
    private final boolean move;
    private List<BibEntry> selection;
    private JTree tree;

    public GroupAddRemoveDialog(BasePanel panel, boolean add, boolean move) {
        this.panel = panel;
        this.add = add;
        this.move = move;
    }

    @Override
    public void action() throws Exception {
        Optional<GroupTreeNode> groups = this.panel.getBibDatabaseContext().getMetaData().getGroups();
        if (!groups.isPresent()) {
            return;
        }
        this.selection = this.panel.getSelectedEntries();
        final JDialog diag = new JDialog(this.panel.frame(), this.add ? (this.move ? Localization.lang("Move to group", new String[0]) : Localization.lang("Add to group", new String[0])) : Localization.lang("Remove from group", new String[0]), true);
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        this.tree = new JTree(new GroupTreeNodeViewModel(groups.get()));
        this.tree.setCellRenderer(new AddRemoveGroupTreeCellRenderer());
        this.tree.setVisibleRowCount(22);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(e -> {
            GroupTreeNodeViewModel node = (GroupTreeNodeViewModel)e.getNewLeadSelectionPath().getLastPathComponent();
            ok.setEnabled(this.checkGroupEnable(node));
        });
        JButton jbExpandAll = new JButton("Expand All");
        jbExpandAll.addActionListener(e -> this.expandAll(this.tree, true));
        JButton jbCollapseAll = new JButton("Collapse All");
        jbCollapseAll.addActionListener(e -> this.expandAll(this.tree, false));
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)ok);
        bb.addButton((JComponent)cancel);
        bb.addButton((JComponent)jbExpandAll);
        bb.addButton((JComponent)jbCollapseAll);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ok.addActionListener(actionEvent -> {
            if (this.doAddOrRemove()) {
                diag.dispose();
                this.tree.repaint();
            }
        });
        cancel.addActionListener(actionEvent -> diag.dispose());
        ok.setEnabled(false);
        JScrollPane sp2 = new JScrollPane(this.tree);
        ActionMap am = sp2.getActionMap();
        InputMap im = sp2.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                diag.dispose();
            }
        });
        diag.getContentPane().add((Component)sp2, "Center");
        diag.getContentPane().add((Component)bb.getPanel(), "South");
        diag.pack();
        diag.setLocationRelativeTo(this.panel.frame());
        diag.setVisible(true);
    }

    private void expandAll(JTree subtree, boolean expand) {
        SwingUtilities.invokeLater(() -> {
            TreeNode root = (TreeNode)subtree.getModel().getRoot();
            this.expandAll(subtree, new TreePath(((DefaultTreeModel)subtree.getModel()).getPathToRoot(root)), expand);
            this.tree.requestFocusInWindow();
        });
    }

    private void expandAll(JTree subtree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        int numChildren = node.getChildCount();
        if (numChildren > 0) {
            for (int i = 0; i < numChildren; ++i) {
                TreeNode child = node.getChildAt(i);
                TreePath path = parent.pathByAddingChild(child);
                this.expandAll(subtree, path, expand);
            }
        }
        if (expand) {
            this.tree.expandPath(parent);
        } else if (node.getParent() != null) {
            this.tree.collapsePath(parent);
        }
    }

    private boolean doAddOrRemove() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return false;
        }
        GroupTreeNodeViewModel node = (GroupTreeNodeViewModel)path.getLastPathComponent();
        if (this.checkGroupEnable(node)) {
            ObservableList<BibEntry> entries = Globals.stateManager.getSelectedEntries();
            if (this.move) {
                this.recuriveRemoveFromNode((GroupTreeNodeViewModel)this.tree.getModel().getRoot(), (List<BibEntry>)entries);
            }
            if (this.add) {
                node.addEntriesToGroup((List<BibEntry>)entries);
            } else {
                node.removeEntriesFromGroup((List<BibEntry>)Globals.stateManager.getSelectedEntries());
            }
            return true;
        }
        return false;
    }

    private void recuriveRemoveFromNode(GroupTreeNodeViewModel node, List<BibEntry> entries) {
        node.removeEntriesFromGroup(entries);
        for (GroupTreeNodeViewModel child : node.getChildren()) {
            this.recuriveRemoveFromNode(child, entries);
        }
    }

    private boolean checkGroupEnable(GroupTreeNodeViewModel node) {
        return this.add ? node.canAddEntries(this.selection) : node.canRemoveEntries(this.selection);
    }

    class AddRemoveGroupTreeCellRenderer
    extends GroupTreeCellRenderer {
        AddRemoveGroupTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            GroupTreeNodeViewModel node = (GroupTreeNodeViewModel)value;
            if (GroupAddRemoveDialog.this.checkGroupEnable(node)) {
                c.setForeground(Color.black);
            } else {
                c.setForeground(Color.gray);
            }
            return c;
        }
    }
}

