/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.errorconsole;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.collections.ObservableList;
import org.apache.http.client.utils.URIBuilder;
import org.fxmisc.easybind.EasyBind;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.errorconsole.LogEventViewModel;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.logging.LogMessages;
import org.jabref.logic.util.BuildInfo;
import org.jabref.logic.util.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorConsoleViewModel
extends AbstractViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorConsoleViewModel.class);
    private final DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private final Date date = new Date();
    private final DialogService dialogService;
    private final ClipBoardManager clipBoardManager;
    private final BuildInfo buildInfo;
    private final ListProperty<LogEventViewModel> allMessagesData;

    public ErrorConsoleViewModel(DialogService dialogService, ClipBoardManager clipBoardManager, BuildInfo buildInfo) {
        this.dialogService = Objects.requireNonNull(dialogService);
        this.clipBoardManager = Objects.requireNonNull(clipBoardManager);
        this.buildInfo = Objects.requireNonNull(buildInfo);
        ObservableList<LogEventViewModel> eventViewModels = EasyBind.map(LogMessages.getInstance().getMessages(), LogEventViewModel::new);
        this.allMessagesData = new ReadOnlyListWrapper(eventViewModels);
    }

    public ListProperty<LogEventViewModel> allMessagesDataProperty() {
        return this.allMessagesData;
    }

    private String getLogMessagesAsString(List<LogEventViewModel> messages) {
        return messages.stream().map(LogEventViewModel::getDetailedText).collect(Collectors.joining(OS.NEWLINE));
    }

    public void copyLog() {
        this.copyLog((List<LogEventViewModel>)this.allMessagesData);
    }

    public void copyLog(List<LogEventViewModel> messages) {
        if (messages.isEmpty()) {
            return;
        }
        this.clipBoardManager.setClipboardContents(this.getLogMessagesAsString(messages));
        this.dialogService.notify(Localization.lang("Log copied to clipboard.", new String[0]));
    }

    public void clearLog() {
        LogMessages.getInstance().clear();
    }

    public void reportIssue() {
        try {
            String issueTitle = "Automatic Bug Report - " + this.dateFormat.format(this.date);
            String systemInfo = String.format("JabRef %s%n%s %s %s %nJava %s", this.buildInfo.getVersion(), BuildInfo.OS, BuildInfo.OS_VERSION, BuildInfo.OS_ARCH, BuildInfo.JAVA_VERSION);
            String howToReproduce = "Steps to reproduce:\n\n1. ...\n2. ...\n3. ...";
            String issueDetails = "<details>\n<summary>Detail information:</summary>\n\n```\n" + this.getLogMessagesAsString((List<LogEventViewModel>)this.allMessagesData) + "\n```\n\n</details>";
            this.clipBoardManager.setClipboardContents(issueDetails);
            String issueBody = systemInfo + "\n\n" + howToReproduce + "\n\nPaste your log details here.";
            this.dialogService.notify(Localization.lang("Issue on GitHub successfully reported.", new String[0]));
            this.dialogService.showInformationDialogAndWait(Localization.lang("Issue report successful", new String[0]), Localization.lang("Your issue was reported in your browser.", new String[0]) + "\n" + Localization.lang("The log and exception information was copied to your clipboard.", new String[0]) + " " + Localization.lang("Please paste this information (with Ctrl+V) in the issue description.", new String[0]) + "\n" + Localization.lang("Please also add all steps to reproduce this issue, if possible.", new String[0]));
            URIBuilder uriBuilder = new URIBuilder().setScheme("https").setHost("github.com").setPath("/JabRef/jabref/issues/new").setParameter("title", issueTitle).setParameter("body", issueBody);
            JabRefDesktop.openBrowser(uriBuilder.build().toString());
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Problem opening url", e);
        }
    }
}

