/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.actions;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jabref.Globals;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.actions.MnemonicAwareAction;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.logic.integrity.IntegrityCheck;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrityCheckAction
extends MnemonicAwareAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrityCheckAction.class);
    private static final String ELLIPSES = "...";
    private final JabRefFrame frame;

    public IntegrityCheckAction(JabRefFrame frame) {
        this.frame = frame;
        this.putValue("Name", Localization.menuTitle("Check integrity", new String[0]) + ELLIPSES);
        this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.CHECK_INTEGRITY));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final IntegrityCheck check = new IntegrityCheck(this.frame.getCurrentBasePanel().getBibDatabaseContext(), Globals.prefs.getFileDirectoryPreferences(), Globals.prefs.getBibtexKeyPatternPreferences(), Globals.journalAbbreviationLoader.getRepository(Globals.prefs.getJournalAbbreviationPreferences()), Globals.prefs.getBoolean("enforceLegalBibtexKey"));
        final JDialog integrityDialog = new JDialog((Frame)this.frame, true);
        integrityDialog.setUndecorated(true);
        integrityDialog.setLocationRelativeTo(this.frame);
        JProgressBar integrityProgressBar = new JProgressBar();
        integrityProgressBar.setIndeterminate(true);
        integrityProgressBar.setStringPainted(true);
        integrityProgressBar.setString(Localization.lang("Checking integrity...", new String[0]));
        integrityDialog.add(integrityProgressBar);
        integrityDialog.pack();
        SwingWorker<List<IntegrityMessage>, Void> worker = new SwingWorker<List<IntegrityMessage>, Void>(){

            @Override
            protected List<IntegrityMessage> doInBackground() {
                List<IntegrityMessage> messages = check.checkBibtexDatabase();
                return messages;
            }

            @Override
            protected void done() {
                integrityDialog.dispose();
            }
        };
        worker.execute();
        integrityDialog.setVisible(true);
        List messages = null;
        try {
            messages = (List)worker.get();
        }
        catch (Exception ex) {
            LOGGER.error("Integrity check failed.", ex);
        }
        if (messages.isEmpty()) {
            JOptionPane.showMessageDialog(this.frame.getCurrentBasePanel(), Localization.lang("No problems found.", new String[0]));
        } else {
            final HashMap<String, Boolean> showMessage = new HashMap<String, Boolean>();
            Object[][] model = new Object[messages.size()][4];
            int i = 0;
            for (IntegrityMessage message : messages) {
                model[i][0] = message.getEntry().getId();
                model[i][1] = message.getEntry().getCiteKeyOptional().orElse("");
                model[i][2] = message.getFieldName();
                model[i][3] = message.getMessage();
                showMessage.put(message.getMessage(), true);
                ++i;
            }
            JTable table = new JTable(model, new Object[]{"ID", Localization.lang("BibTeX key", new String[0]), Localization.lang("Field", new String[0]), Localization.lang("Message", new String[0])});
            TableColumnModel columnModel = table.getColumnModel();
            columnModel.removeColumn(columnModel.getColumn(0));
            RowFilter<Object, Object> filter = new RowFilter<Object, Object>(){

                @Override
                public boolean include(RowFilter.Entry<?, ?> entry) {
                    return (Boolean)showMessage.get(entry.getStringValue(3));
                }
            };
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(table.getModel());
            sorter.setRowFilter(filter);
            table.setRowSorter(sorter);
            table.setSelectionMode(0);
            table.setDefaultEditor(Object.class, null);
            ListSelectionModel selectionModel = table.getSelectionModel();
            selectionModel.addListSelectionListener(event -> {
                if (!event.getValueIsAdjusting()) {
                    try {
                        String entryId = (String)model[table.convertRowIndexToModel(table.getSelectedRow())][0];
                        String fieldName = (String)model[table.convertRowIndexToModel(table.getSelectedRow())][2];
                        this.frame.getCurrentBasePanel().editEntryByIdAndFocusField(entryId, fieldName);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            });
            table.getColumnModel().getColumn(0).setPreferredWidth(100);
            table.getColumnModel().getColumn(1).setPreferredWidth(60);
            table.getColumnModel().getColumn(2).setPreferredWidth(400);
            table.setAutoResizeMode(3);
            JScrollPane scrollPane = new JScrollPane(table);
            String title = Localization.lang("%0 problem(s) found", String.valueOf(messages.size()));
            JDialog dialog = new JDialog(this.frame, title, false);
            JPopupMenu menu = new JPopupMenu();
            for (String messageString : showMessage.keySet()) {
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(messageString, true);
                menuItem.addActionListener(event -> {
                    showMessage.put(messageString, menuItem.isSelected());
                    ((AbstractTableModel)table.getModel()).fireTableDataChanged();
                });
                menu.add(menuItem);
            }
            JButton menuButton = new JButton(Localization.lang("Filter", new String[0]));
            menuButton.addActionListener(entry -> menu.show(menuButton, 0, menuButton.getHeight()));
            FormBuilder builder = FormBuilder.create().layout(new FormLayout("fill:pref:grow", "fill:pref:grow, 2dlu, pref"));
            JButton filterNoneButton = new JButton(Localization.lang("Filter None", new String[0]));
            filterNoneButton.addActionListener(event -> {
                for (Component component : menu.getComponents()) {
                    JCheckBoxMenuItem checkBox;
                    if (component instanceof JCheckBoxMenuItem && (checkBox = (JCheckBoxMenuItem)component).isSelected()) {
                        checkBox.setSelected(false);
                        showMessage.put(checkBox.getText(), checkBox.isSelected());
                    }
                    ((AbstractTableModel)table.getModel()).fireTableDataChanged();
                }
            });
            JButton filterAllButton = new JButton(Localization.lang("Filter All", new String[0]));
            filterAllButton.addActionListener(event -> {
                for (Component component : menu.getComponents()) {
                    JCheckBoxMenuItem checkBox;
                    if (component instanceof JCheckBoxMenuItem && !(checkBox = (JCheckBoxMenuItem)component).isSelected()) {
                        checkBox.setSelected(true);
                        showMessage.put(checkBox.getText(), checkBox.isSelected());
                    }
                    ((AbstractTableModel)table.getModel()).fireTableDataChanged();
                }
            });
            builder.add(filterNoneButton).xy(1, 3, "left, b");
            builder.add(filterAllButton).xy(1, 3, "right, b");
            builder.add(scrollPane).xy(1, 1);
            builder.add(menuButton).xy(1, 3, "c, b");
            dialog.add(builder.getPanel());
            dialog.setSize(600, 600);
            dialog.setVisible(true);
        }
    }
}

