/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.actions;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.jabref.JabRefGUI;
import org.jabref.gui.actions.BaseAction;
import org.jabref.gui.maintable.MainTable;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.OS;
import org.jabref.model.entry.BibEntry;

public class CopyBibTeXKeyAndLinkAction
implements BaseAction {
    private final MainTable mainTable;

    public CopyBibTeXKeyAndLinkAction(MainTable mainTable) {
        this.mainTable = mainTable;
    }

    @Override
    public void action() throws Exception {
        List<BibEntry> entries = this.mainTable.getSelectedEntries();
        if (!entries.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            List entriesWithKey = entries.stream().filter(BibEntry::hasCiteKey).collect(Collectors.toList());
            if (entriesWithKey.isEmpty()) {
                JabRefGUI.getMainFrame().output(Localization.lang("None of the selected entries have BibTeX keys.", new String[0]));
                return;
            }
            for (BibEntry entry : entriesWithKey) {
                String key = entry.getCiteKeyOptional().get();
                String url = entry.getField("url").orElse("");
                sb.append(url.isEmpty() ? key : String.format("<a href=\"%s\">%s</a>", url, key));
                sb.append(OS.NEWLINE);
            }
            DefaultTaskExecutor.runInJavaFXThread(() -> {
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent content = new ClipboardContent();
                content.putHtml(sb.toString());
                clipboard.setContent((Map)content);
            });
            int copied = entriesWithKey.size();
            int toCopy = entries.size();
            if (copied == toCopy) {
                JabRefGUI.getMainFrame().output((entries.size() > 1 ? Localization.lang("Copied keys", new String[0]) : Localization.lang("Copied key", new String[0])) + '.');
            } else {
                JabRefGUI.getMainFrame().output(Localization.lang("Warning: %0 out of %1 entries have undefined BibTeX key.", Long.toString(toCopy - copied), Integer.toString(toCopy)));
            }
        }
    }
}

