/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    ToolItem currentFocusItem;
    ToolItem[] tabItemList;
    ImageList imageList;
    boolean hasChildFocus;
    static Callback menuItemSelectedFunc = new Callback(ToolBar.class, "MenuItemSelectedProc", 2);
    String cssBackground;
    String cssForeground = " ";

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        int orientation = (style & 0x200) != 0 ? 1 : 0;
        GTK.gtk_orientable_set_orientation(this.handle, orientation);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createHandle(int index) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            this.handle = GTK.gtk_box_new(0, 0);
            GTK.gtk_widget_add_css_class(this.handle, Converter.javaStringToCString("toolbar"));
        } else {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
            this.handle = GTK3.gtk_toolbar_new();
        }
        if (this.handle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
        } else {
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
        }
        if (!GTK.GTK4) {
            GTK3.gtk_toolbar_set_icon_size(this.handle, 2);
        }
        this.setFontDescription(this.defaultFont().handle);
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = null;
        if (GTK.GTK4) {
            size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        } else {
            GTK3.gtk_toolbar_set_show_arrow(this.handle, false);
            size = this.computeNativeSize(this.handle, wHint, hHint, changed);
            if ((this.style & 0x40) != 0) {
                GTK3.gtk_toolbar_set_show_arrow(this.handle, true);
            }
        }
        return size;
    }

    @Override
    Widget computeTabGroup() {
        int index;
        ToolItem[] items = this._getItems();
        if (this.tabItemList == null) {
            int i = 0;
            while (i < items.length && items[i].control == null) {
                ++i;
            }
            if (i == items.length) {
                return super.computeTabGroup();
            }
        }
        if ((index = this.indexOf(this.currentFocusItem)) == -1) {
            index = items.length - 1;
        }
        while (index >= 0) {
            ToolItem item = items[index];
            if (item.isTabGroup()) {
                return item;
            }
            --index;
        }
        return super.computeTabGroup();
    }

    @Override
    Widget[] computeTabList() {
        ToolItem[] items = this._getItems();
        if (this.tabItemList == null) {
            int i = 0;
            while (i < items.length && items[i].control == null) {
                ++i;
            }
            if (i == items.length) {
                return super.computeTabList();
            }
        }
        Widget[] result = new Widget[]{};
        if (!(this.isTabGroup() && this.isEnabled() && this.isVisible())) {
            return result;
        }
        ToolItem[] list = this.tabList != null ? this._getTabItemList() : items;
        int i = 0;
        while (i < list.length) {
            ToolItem child = list[i];
            Widget[] childList = child.computeTabList();
            if (childList.length != 0) {
                Widget[] newResult = new Widget[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++i;
        }
        if (result.length == 0) {
            result = new Widget[]{this};
        }
        return result;
    }

    @Override
    long eventHandle() {
        return this.fixedHandle;
    }

    @Override
    long enterExitHandle() {
        return this.handle;
    }

    @Override
    boolean forceFocus(long focusHandle) {
        int dir = 0;
        if ((this.style & 0x8000000) != 0) {
            dir = 1;
        }
        long childHandle = this.handle;
        if (this.currentFocusItem != null) {
            childHandle = this.currentFocusItem.handle;
        }
        if (GTK.gtk_widget_child_focus(childHandle, dir)) {
            return true;
        }
        return super.forceFocus(focusHandle);
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            this.error(6);
        }
        return this.getItems()[index];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getBounds().contains(point)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int itemCount = 0;
        if (GTK.GTK4) {
            long child = GTK4.gtk_widget_get_first_child(this.handle);
            while (child != 0L) {
                ++itemCount;
                child = GTK4.gtk_widget_get_next_sibling(child);
            }
        } else {
            long list = GTK3.gtk_container_get_children(this.handle);
            if (list == 0L) {
                return 0;
            }
            itemCount = OS.g_list_length(list);
            OS.g_list_free(list);
        }
        return itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return this._getItems();
    }

    ToolItem[] _getItems() {
        if (GTK.GTK4) {
            ArrayList<ToolItem> childrenList = new ArrayList<ToolItem>();
            long child = GTK4.gtk_widget_get_first_child(this.handle);
            while (child != 0L) {
                Widget childWidget = this.display.getWidget(child);
                if (childWidget != null) {
                    childrenList.add((ToolItem)childWidget);
                }
                child = GTK4.gtk_widget_get_next_sibling(child);
            }
            return childrenList.toArray(new ToolItem[childrenList.size()]);
        }
        long list = GTK3.gtk_container_get_children(this.handle);
        if (list == 0L) {
            return new ToolItem[0];
        }
        int count = OS.g_list_length(list);
        ToolItem[] items = new ToolItem[count];
        long originalList = list;
        int index = 0;
        int i = 0;
        while (i < count) {
            long data = OS.g_list_data(list);
            Widget widget = this.display.getWidget(data);
            if (widget != null) {
                items[index++] = (ToolItem)widget;
            }
            list = OS.g_list_next(list);
            ++i;
        }
        OS.g_list_free(originalList);
        if (index != items.length) {
            ToolItem[] newItems = new ToolItem[index];
            System.arraycopy(items, 0, newItems, 0, index);
            items = newItems;
        }
        return items;
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    ToolItem[] _getTabItemList() {
        if (this.tabItemList == null) {
            return this.tabItemList;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabItemList.length) {
            if (!this.tabItemList[i].isDisposed()) {
                ++count;
            }
            ++i;
        }
        if (count == this.tabItemList.length) {
            return this.tabItemList;
        }
        ToolItem[] newList = new ToolItem[count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.tabItemList.length) {
            if (!this.tabItemList[i2].isDisposed()) {
                newList[index++] = this.tabItemList[i2];
            }
            ++i2;
        }
        this.tabItemList = newList;
        return this.tabItemList;
    }

    @Override
    long gtk_key_press_event(long widget, long eventPtr) {
        if (!this.hasFocus()) {
            return 0L;
        }
        long result = super.gtk_key_press_event(widget, eventPtr);
        return result;
    }

    @Override
    long gtk_focus(long widget, long directionType) {
        return 0L;
    }

    @Override
    boolean hasFocus() {
        if (this.hasChildFocus) {
            return true;
        }
        return super.hasFocus();
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (item == items[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static long MenuItemSelectedProc(long widget, long user_data) {
        Display display = Display.getCurrent();
        ToolItem item = (ToolItem)display.getWidget(user_data);
        if (item != null) {
            return item.getParent().menuItemSelected(widget, item);
        }
        return 0L;
    }

    long menuItemSelected(long widget, ToolItem item) {
        Event event = new Event();
        switch (item.style) {
            case 4: {
                event.detail = 4;
                GtkAllocation allocation = new GtkAllocation();
                GTK.gtk_widget_get_allocation(widget, allocation);
                event.x = allocation.x;
                if ((this.style & 0x8000000) != 0) {
                    event.x = this.getClientWidth() - allocation.width - event.x;
                }
                event.y = allocation.y + allocation.height;
                break;
            }
            case 16: {
                if ((this.style & 0x400000) != 0) break;
                item.selectRadio();
                break;
            }
            case 32: {
                boolean currentSelection = item.getSelection();
                item.setSelection(!currentSelection);
            }
        }
        item.sendSelectionEvent(13, event, false);
        return 0L;
    }

    @Override
    boolean mnemonicHit(char key) {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            long labelHandle = items[i].labelHandle;
            if (labelHandle != 0L && this.mnemonicHit(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char key) {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            long labelHandle = items[i].labelHandle;
            if (labelHandle != 0L && this.mnemonicMatch(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void relayout() {
        ToolItem[] items = this.getItems();
        boolean hasText = false;
        boolean hasImage = false;
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item != null) {
                item.resizeControl();
                hasText |= item.text != null && item.text.length() > 0;
                hasImage |= item.image != null;
            }
            ++i;
        }
        if (!GTK.GTK4) {
            int type = 0;
            if (hasText && hasImage) {
                type = (this.style & 0x20000) != 0 ? 3 : 2;
            } else if (hasText) {
                type = 1;
            } else if (hasImage) {
                type = 0;
            }
            GTK3.gtk_toolbar_set_style(this.handle, type);
        }
    }

    @Override
    void releaseChildren(boolean destroy) {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    @Override
    void reskinChildren(int flags) {
        ToolItem[] items = this._getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                ToolItem item = items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result;
        if (!GTK.GTK4) {
            GTK3.gtk_toolbar_set_show_arrow(this.handle, false);
        }
        if (((result = super.setBounds(x, y, width, height, move, resize)) & 0x100) != 0) {
            this.relayout();
        }
        if ((this.style & 0x40) != 0 && !GTK.GTK4) {
            GTK3.gtk_toolbar_set_show_arrow(this.handle, true);
        }
        return result;
    }

    @Override
    void setBackgroundGdkRGBA(long context, long handle, GdkRGBA rgba) {
        String css = "toolbar {background-color: " + this.display.gtk_rgba_to_css_string(rgba) + ";}";
        this.cssBackground = css;
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(context, finalCss);
    }

    @Override
    void setParentBackground() {
        this.setBackgroundGdkRGBA(this.handle, this.display.getSystemColor((int)37).handle);
        super.setParentBackground();
    }

    @Override
    void setForegroundGdkRGBA(long handle, GdkRGBA rgba) {
        GdkRGBA toSet = new GdkRGBA();
        toSet = rgba != null ? rgba : this.display.COLOR_WIDGET_FOREGROUND_RGBA;
        long context = GTK.gtk_widget_get_style_context(handle);
        String color = this.display.gtk_rgba_to_css_string(toSet);
        String name = this.display.gtk_widget_class_get_css_name(handle);
        GdkRGBA selectedForeground = this.display.COLOR_LIST_SELECTION_TEXT_RGBA;
        String css = "* {color: " + color + ";}\n" + name + " selection {color: " + this.display.gtk_rgba_to_css_string(selectedForeground) + ";}";
        this.cssForeground = css;
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 16);
        this.gtk_css_provider_load_from_css(context, finalCss);
    }

    @Override
    void setFontDescription(long font) {
        super.setFontDescription(font);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setFontDescription(font);
            ++i;
        }
        this.relayout();
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        super.setForegroundGdkRGBA(rgba);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].updateStyle();
            ++i;
        }
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        ToolItem[] items = this._getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setOrientation(create);
            ++i;
        }
    }

    void setTabItemList(ToolItem[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                ToolItem item = tabList[i];
                if (item == null) {
                    this.error(5);
                }
                if (item.isDisposed()) {
                    this.error(5);
                }
                if (item.parent != this) {
                    this.error(32);
                }
                ++i;
            }
            ToolItem[] newList = new ToolItem[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabItemList = tabList;
    }

    @Override
    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            String newString = string != null ? null : items[i].toolTipText;
            this.setToolTipText(items[i].handle, newString);
            ++i;
        }
    }
}

