/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.guishared;

import java.io.File;
import java.util.ResourceBundle;
import javax.swing.filechooser.FileFilter;
import net.yura.domination.engine.translation.TranslationBundle;

public class RiskFileFilter
extends FileFilter {
    public static final String RISK_MAP_FILES = "map";
    public static final String RISK_CARDS_FILES = "cards";
    public static final String RISK_SAVE_FILES = "save";
    public static final String RISK_SCRIPT_FILES = "risk";
    public static final String RISK_LOG_FILES = "log";
    private String extension = null;

    public RiskFileFilter(String ext) {
        this.extension = ext;
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String ext = RiskFileFilter.getExtension(f);
        if (ext != null) {
            return ext.equals(this.extension);
        }
        return false;
    }

    public String getDescription() {
        ResourceBundle resb = TranslationBundle.getBundle();
        String name = this.extension.equals(RISK_MAP_FILES) ? resb.getString("riskfilefilter.map") : (this.extension.equals(RISK_CARDS_FILES) ? resb.getString("riskfilefilter.cards") : (this.extension.equals(RISK_SAVE_FILES) ? resb.getString("riskfilefilter.save") : (this.extension.equals(RISK_SCRIPT_FILES) ? resb.getString("riskfilefilter.script") : (this.extension.equals(RISK_LOG_FILES) ? resb.getString("riskfilefilter.log") : resb.getString("riskfilefilter.files")))));
        return name + " (*." + this.extension + ")";
    }

    public String getExtension() {
        return this.extension;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }
}

