/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import net.yura.mobile.io.BinUtil;
import net.yura.mobile.io.SocketClient;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.SystemUtil;

public class ServiceLink
extends SocketClient {
    protected static int majorVersion = 1;
    protected static int minorVersion = 0;
    protected static int earliestSupportedMajorVersion = 1;
    protected static int earliestSupportedMinorVersion = 0;
    protected Hashtable register = new Hashtable();
    private int disconnectionCounter;
    private ServiceAccess access;
    private static ServiceLink serviceLink;

    public void setDetailedLogging(Boolean b) {
        if (this.isConnected()) {
            this.sendTask(new Task("PutOptionDetailedLog", b));
        }
    }

    protected ServiceLink() {
        super("127.0.0.1:4444");
    }

    public static ServiceLink getInstance() {
        if (serviceLink == null) {
            serviceLink = new ServiceLink();
            Hashtable<String, Integer> info = new Hashtable<String, Integer>();
            info.put("major", new Integer(majorVersion));
            info.put("minor", new Integer(minorVersion));
            serviceLink.sendTask(new Task("GetVersion", info));
        }
        return serviceLink;
    }

    public void sendTask(Task task) {
        this.addToOutbox(task);
    }

    public void registerForTask(String method, Object handler) {
        this.register.put(method, handler);
    }

    public void handleObject(Object obj) {
        Task task = (Task)obj;
        String method = task.getMethod();
        if ("PutVersion".equals(method)) {
            Hashtable info = (Hashtable)task.getObject();
            Integer major = (Integer)info.get("major");
            Integer minor = (Integer)info.get("minor");
            if (major < earliestSupportedMajorVersion || major == earliestSupportedMajorVersion && minor < earliestSupportedMinorVersion) {
                this.disconnect();
            }
        } else {
            TaskHandler handler = (TaskHandler)this.register.get(method);
            if (handler != null) {
                handler.handleTask(task);
            } else {
                Logger.warn("dont know what to do with task " + task);
            }
        }
    }

    protected void updateState(int aState) {
        if (aState == 1) {
            ++this.disconnectionCounter;
            if (this.disconnectionCounter >= 1) {
                this.disconnect();
            }
        }
    }

    protected void write(OutputStream out, Object object) throws IOException {
        this.access.save(out, object);
    }

    protected Object read(InputStream in) throws IOException {
        return this.access.load(in);
    }

    protected void connected(InputStream in, OutputStream out) {
        this.access = new ServiceAccess();
    }

    protected void disconnected() {
        this.access = null;
    }

    public boolean isConnected() {
        return this.access != null;
    }

    public static class ServiceAccess
    extends BinUtil {
        public static final int TYPE_TASK = 20;

        protected void writeObject(DataOutputStream out, Object object) throws IOException {
            if (object instanceof Task) {
                out.writeInt(20);
                this.saveTask(out, (Task)object);
            } else {
                super.writeObject(out, object);
            }
        }

        protected void saveTask(DataOutputStream out, Task object) throws IOException {
            out.writeInt(2);
            this.writeObject(out, object.getMethod());
            this.writeObject(out, object.getObject());
        }

        protected Object readObject(DataInputStream in, int type, int size) throws IOException {
            switch (type) {
                case 20: {
                    return this.readTask(in, size);
                }
            }
            return super.readObject(in, type, size);
        }

        protected Task readTask(DataInputStream in, int size) throws IOException {
            Task object = new Task();
            if (size > 0) {
                object.setMethod((String)this.readObject(in));
            }
            if (size > 1) {
                object.setObject(this.readObject(in));
            }
            if (size > 2) {
                this.skipUnknownObjects(in, size - 2);
            }
            return object;
        }
    }

    public static class Task {
        private String method;
        private Object object;

        public Task(String aMethod, Object aObject) {
            this.method = aMethod;
            this.object = aObject;
        }

        public Task(String aMethod) {
            this.method = aMethod;
        }

        public Task() {
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + (this.method != null ? this.method.hashCode() : 0);
            hash = 37 * hash + (this.object != null ? this.object.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Task) {
                Task t2 = (Task)obj;
                return SystemUtil.equals(this.getMethod(), t2.getMethod()) && SystemUtil.equals(this.getObject(), t2.getObject());
            }
            return false;
        }

        public String toString() {
            return this.method + " " + this.object;
        }
    }

    public static interface TaskHandler {
        public void handleTask(Task var1);
    }
}

