/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.configuration;

import java.util.List;
import java.util.Properties;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.agents.AgentStatus;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.process.internal.CurrentProcess;
import org.gradle.process.internal.JvmOptions;

public class BuildProcess
extends CurrentProcess {
    private final AgentStatus agentStatus;
    private final Logger logger = Logging.getLogger(BuildProcess.class);

    public BuildProcess(FileCollectionFactory fileCollectionFactory) {
        super(fileCollectionFactory);
        this.agentStatus = AgentStatus.allowed();
    }

    protected BuildProcess(JavaInfo jvm, JvmOptions effectiveJvmOptions, AgentStatus agentStatus) {
        super(jvm, effectiveJvmOptions);
        this.agentStatus = agentStatus;
    }

    public boolean configureForBuild(DaemonParameters requiredBuildParameters) {
        boolean javaHomeMatch = this.getJvm().equals(requiredBuildParameters.getEffectiveJvm());
        boolean javaAgentStateMatch = this.agentStatus.isAgentInstrumentationEnabled() || !requiredBuildParameters.shouldApplyInstrumentationAgent();
        boolean immutableJvmArgsMatch = true;
        if (requiredBuildParameters.hasUserDefinedImmutableJvmArgs()) {
            List<String> effectiveSingleUseJvmArgs = requiredBuildParameters.getEffectiveSingleUseJvmArgs();
            this.logger.info("Checking if the launcher JVM can be re-used for build. To be re-used, the launcher JVM needs to match the parameters required for the build process: {}", (Object)String.join((CharSequence)" ", effectiveSingleUseJvmArgs));
            immutableJvmArgsMatch = this.getJvmOptions().getAllImmutableJvmArgs().equals(effectiveSingleUseJvmArgs);
        }
        if (javaHomeMatch && javaAgentStateMatch && immutableJvmArgsMatch && !this.isLowDefaultMemory(requiredBuildParameters)) {
            Properties properties = new Properties();
            properties.putAll(requiredBuildParameters.getEffectiveSystemProperties());
            System.setProperties(properties);
            return true;
        }
        return false;
    }

    private boolean isLowDefaultMemory(DaemonParameters daemonParameters) {
        if (daemonParameters.hasUserDefinedImmutableJvmArgs()) {
            for (String arg : daemonParameters.getEffectiveSingleUseJvmArgs()) {
                if (!arg.startsWith("-Xmx")) continue;
                return false;
            }
        }
        return "64m".equals(this.getJvmOptions().getMaxHeapSize());
    }
}

