/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.services.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.NonExtensible;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.api.services.internal.BuildServiceProvider;
import org.gradle.api.services.internal.BuildServiceRegistryInternal;
import org.gradle.api.services.internal.ConsumedBuildServiceProvider;
import org.gradle.api.services.internal.RegisteredBuildServiceProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.SharedResource;
import org.gradle.internal.resources.SharedResourceLeaseRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;

public class DefaultBuildServicesRegistry
implements BuildServiceRegistryInternal,
HoldsProjectState {
    private final BuildIdentifier buildIdentifier;
    private final Lock registrationsLock = new ReentrantLock();
    private NamedDomainObjectSet<BuildServiceRegistration<?, ?>> registrations;
    private final DomainObjectCollectionFactory collectionFactory;
    private final InstantiatorFactory instantiatorFactory;
    private final ServiceRegistry services;
    private final IsolatableFactory isolatableFactory;
    private final SharedResourceLeaseRegistry leaseRegistry;
    private final IsolationScheme<BuildService, BuildServiceParameters> isolationScheme = new IsolationScheme(BuildService.class, BuildServiceParameters.class, BuildServiceParameters.None.class);
    private final Instantiator paramsInstantiator;
    private final Instantiator specInstantiator;
    private final BuildServiceProvider.Listener listener;

    public DefaultBuildServicesRegistry(BuildIdentifier buildIdentifier, DomainObjectCollectionFactory collectionFactory, InstantiatorFactory instantiatorFactory, ServiceRegistry services, ListenerManager listenerManager, IsolatableFactory isolatableFactory, SharedResourceLeaseRegistry leaseRegistry, BuildServiceProvider.Listener listener) {
        this.buildIdentifier = buildIdentifier;
        this.registrations = (NamedDomainObjectSet)Cast.uncheckedCast(collectionFactory.newNamedDomainObjectSet(BuildServiceRegistration.class));
        this.collectionFactory = collectionFactory;
        this.instantiatorFactory = instantiatorFactory;
        this.services = services;
        this.isolatableFactory = isolatableFactory;
        this.leaseRegistry = leaseRegistry;
        this.paramsInstantiator = instantiatorFactory.decorateScheme().withServices((ServiceLookup)services).instantiator();
        this.specInstantiator = instantiatorFactory.decorateLenientScheme().withServices((ServiceLookup)services).instantiator();
        this.listener = listener;
        listenerManager.addListener((Object)new ServiceCleanupListener());
    }

    private <U> U withRegistrations(Function<NamedDomainObjectSet<BuildServiceRegistration<?, ?>>, U> function) {
        this.registrationsLock.lock();
        try {
            U u = function.apply(this.registrations);
            return u;
        }
        finally {
            this.registrationsLock.unlock();
        }
    }

    public NamedDomainObjectSet<BuildServiceRegistration<?, ?>> getRegistrations() {
        return this.registrations;
    }

    @Override
    public SharedResource forService(BuildServiceProvider<?, ?> service) {
        BuildServiceRegistration registration = this.findRegistration((Class)service.getType(), service.getName());
        if (registration == null) {
            return null;
        }
        return registration.asSharedResource(() -> this.lambda$forService$0((DefaultServiceRegistration)registration));
    }

    @Nullable
    public DefaultServiceRegistration<?, ?> findRegistration(Class<?> type, String name) {
        return (DefaultServiceRegistration)Cast.uncheckedCast(!name.isEmpty() ? this.findByName(name) : this.findByType(type));
    }

    @Override
    public Set<BuildServiceRegistration<?, ?>> findRegistrations(Class<?> type, String name) {
        return (Set)this.withRegistrations(registrations -> ImmutableSet.builder().addAll((Iterable)registrations.matching(it -> type.isAssignableFrom(BuildServiceProvider.getProvidedType(it.getService())) && (StringUtils.isEmpty((String)name) || it.getName().equals(name)))).build());
    }

    @Override
    @Nullable
    public BuildServiceRegistration<?, ?> findByName(String name) {
        return this.withRegistrations(registrations -> (BuildServiceRegistration)registrations.findByName(name));
    }

    @Override
    @Nullable
    public BuildServiceRegistration<?, ?> findByType(Class<?> type) {
        return this.findRegistrations(type, null).stream().findFirst().orElse(null);
    }

    public <T extends BuildService<P>, P extends BuildServiceParameters> Provider<T> registerIfAbsent(String name, Class<T> implementationType, Action<? super BuildServiceSpec<P>> configureAction) {
        return this.doRegisterIfAbsent(name, implementationType, () -> {
            Object parameters = this.instantiateParametersOf(implementationType);
            DefaultServiceSpec spec = (DefaultServiceSpec)Cast.uncheckedNonnullCast((Object)this.specInstantiator.newInstance(DefaultServiceSpec.class, new Object[]{parameters}));
            configureAction.execute((Object)spec);
            return spec;
        });
    }

    @Override
    public BuildServiceProvider<?, ?> registerIfAbsent(String name, Class<? extends BuildService<?>> implementationType, @Nullable BuildServiceParameters parameters, int maxUsages) {
        Supplier<BuildServiceSpec> buildServiceSpecSupplier = () -> {
            DefaultServiceSpec spec = (DefaultServiceSpec)Cast.uncheckedNonnullCast((Object)this.specInstantiator.newInstance(DefaultServiceSpec.class, new Object[]{parameters}));
            spec.getMaxParallelUsages().set((Object)maxUsages);
            return spec;
        };
        return this.doRegisterIfAbsent(name, (Class)Cast.uncheckedNonnullCast(implementationType), (Supplier)Cast.uncheckedNonnullCast(buildServiceSpecSupplier));
    }

    private <T extends BuildService<P>, P extends BuildServiceParameters> BuildServiceProvider<T, P> doRegisterIfAbsent(String name, Class<T> implementationType, Supplier<BuildServiceSpec<P>> specSupplier) {
        return this.withRegistrations(registrations -> {
            BuildServiceRegistration existing = (BuildServiceRegistration)registrations.findByName(name);
            if (existing != null) {
                return (BuildServiceProvider)((Object)((Object)Cast.uncheckedNonnullCast((Object)existing.getService())));
            }
            BuildServiceSpec spec = (BuildServiceSpec)specSupplier.get();
            return this.doRegister(name, implementationType, (BuildServiceParameters)spec.getParameters(), (Integer)spec.getMaxParallelUsages().getOrNull(), (NamedDomainObjectSet<BuildServiceRegistration<?, ?>>)registrations);
        });
    }

    @Override
    public List<ResourceLock> getSharedResources(Set<Provider<? extends BuildService<?>>> services) {
        if (services.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder locks = ImmutableList.builder();
        for (Provider<BuildService<?>> provider : services) {
            SharedResource resource;
            if (!provider.isPresent() || (resource = this.forService(BuildServiceProvider.asBuildServiceProvider(provider))) == null || resource.getMaxUsages() <= 0) continue;
            locks.add((Object)resource.getResourceLock());
        }
        return locks.build();
    }

    @Nullable
    private <T extends BuildService<P>, P extends BuildServiceParameters> P instantiateParametersOf(Class<T> implementationType) {
        Class parameterType = this.isolationScheme.parameterTypeFor(implementationType);
        return (P)(parameterType != null ? (BuildServiceParameters)this.paramsInstantiator.newInstance(parameterType, new Object[0]) : null);
    }

    @Override
    public BuildServiceProvider<?, ?> register(String name, Class<? extends BuildService<?>> implementationType, @Nullable BuildServiceParameters parameters, int maxUsages) {
        return this.withRegistrations(registrations -> {
            DefaultServiceRegistration registration = (DefaultServiceRegistration)Cast.uncheckedCast((Object)registrations.findByName(name));
            if (registration != null) {
                if (registration.provider.isKeepAlive()) {
                    return registration.provider;
                }
                throw new IllegalArgumentException(String.format("Service '%s' has already been registered.", name));
            }
            return this.doRegister(name, (Class)Cast.uncheckedNonnullCast((Object)implementationType), (BuildServiceParameters)parameters, maxUsages <= 0 ? null : Integer.valueOf(maxUsages), (NamedDomainObjectSet<BuildServiceRegistration<?, ?>>)registrations);
        });
    }

    @Override
    public BuildServiceProvider<?, ?> consume(String name, Class<? extends BuildService<?>> implementationType) {
        return this.doConsume(name, (Class)Cast.uncheckedCast(implementationType));
    }

    private <T extends BuildService<BuildServiceParameters>> BuildServiceProvider<T, BuildServiceParameters> doConsume(String name, Class<T> implementationType) {
        return new ConsumedBuildServiceProvider<T>(this.buildIdentifier, name, implementationType, this.services);
    }

    private <T extends BuildService<P>, P extends BuildServiceParameters> BuildServiceProvider<T, P> doRegister(String name, Class<T> implementationType, @Nullable P parameters, @Nullable Integer maxParallelUsages, NamedDomainObjectSet<BuildServiceRegistration<?, ?>> registrations) {
        RegisteredBuildServiceProvider<T, P> provider = new RegisteredBuildServiceProvider<T, P>(this.buildIdentifier, name, implementationType, parameters, this.isolationScheme, this.instantiatorFactory.injectScheme(), this.isolatableFactory, this.services, this.listener, maxParallelUsages);
        DefaultServiceRegistration registration = (DefaultServiceRegistration)Cast.uncheckedNonnullCast((Object)this.specInstantiator.newInstance(DefaultServiceRegistration.class, new Object[]{name, parameters, provider}));
        registration.getMaxParallelUsages().set((Object)maxParallelUsages);
        registrations.add((Object)registration);
        return provider;
    }

    @Override
    public void discardAll() {
        this.discardAll(false);
    }

    private void discardAll(boolean forceAll) {
        this.withRegistrations(registrations -> {
            ArrayList preserved = new ArrayList();
            try {
                ExecutionResult.forEach(registrations, registration -> {
                    DefaultServiceRegistration serviceRegistration = (DefaultServiceRegistration)registration;
                    if (forceAll || !serviceRegistration.provider.isKeepAlive()) {
                        serviceRegistration.provider.maybeStop();
                    } else {
                        preserved.add(serviceRegistration);
                    }
                }).rethrow();
            }
            finally {
                this.registrations = (NamedDomainObjectSet)Cast.uncheckedCast(this.collectionFactory.newNamedDomainObjectSet(BuildServiceRegistration.class));
            }
            this.registrations.addAll(preserved);
            return null;
        });
    }

    private /* synthetic */ SharedResource lambda$forService$0(DefaultServiceRegistration registration) {
        registration.getMaxParallelUsages().finalizeValue();
        int maxUsages = (Integer)registration.getMaxParallelUsages().getOrElse((Object)-1);
        if (maxUsages > 0) {
            this.leaseRegistry.registerSharedResource(registration.getName(), maxUsages);
        }
        return new ServiceBackedSharedResource(registration.getName(), maxUsages, this.leaseRegistry);
    }

    private class ServiceCleanupListener
    extends BuildAdapter {
        private ServiceCleanupListener() {
        }

        public void buildFinished(BuildResult result) {
            DefaultBuildServicesRegistry.this.discardAll(true);
        }
    }

    @NonExtensible
    public static abstract class DefaultServiceSpec<P extends BuildServiceParameters>
    implements BuildServiceSpec<P> {
        private final P parameters;

        public DefaultServiceSpec(P parameters) {
            this.parameters = parameters;
        }

        public P getParameters() {
            return this.parameters;
        }

        public void parameters(Action<? super P> configureAction) {
            configureAction.execute(this.parameters);
        }
    }

    public static abstract class DefaultServiceRegistration<T extends BuildService<P>, P extends BuildServiceParameters>
    implements BuildServiceRegistration<T, P> {
        private final String name;
        private final P parameters;
        private final RegisteredBuildServiceProvider<T, P> provider;
        private SharedResource resourceWrapper;

        public DefaultServiceRegistration(String name, P parameters, RegisteredBuildServiceProvider<T, P> provider) {
            this.name = name;
            this.parameters = parameters;
            this.provider = provider;
        }

        public String getName() {
            return this.name;
        }

        public P getParameters() {
            return this.parameters;
        }

        public Provider<T> getService() {
            return this.provider;
        }

        public SharedResource asSharedResource(Supplier<SharedResource> factory) {
            if (this.resourceWrapper == null) {
                this.resourceWrapper = factory.get();
            }
            return this.resourceWrapper;
        }
    }

    private static class ServiceBackedSharedResource
    implements SharedResource {
        private final String name;
        private final int maxUsages;
        private final SharedResourceLeaseRegistry leaseRegistry;

        public ServiceBackedSharedResource(String name, int maxUsages, SharedResourceLeaseRegistry leaseRegistry) {
            this.name = name;
            this.maxUsages = maxUsages;
            this.leaseRegistry = leaseRegistry;
        }

        public int getMaxUsages() {
            return this.maxUsages;
        }

        public ResourceLock getResourceLock() {
            return this.leaseRegistry.getResourceLock(this.name);
        }
    }
}

