/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.filters.SimpleBatchFilter;

public class InterquartileRange
extends SimpleBatchFilter
implements WeightedAttributesHandler {
    private static final long serialVersionUID = -227879653639723030L;
    public static final int NON_NUMERIC = -1;
    protected Range m_Attributes = new Range("first-last");
    protected int[] m_AttributeIndices = null;
    protected double m_OutlierFactor = 3.0;
    protected double m_ExtremeValuesFactor = 2.0 * this.m_OutlierFactor;
    protected boolean m_ExtremeValuesAsOutliers = false;
    protected double[] m_UpperExtremeValue = null;
    protected double[] m_UpperOutlier = null;
    protected double[] m_LowerOutlier = null;
    protected double[] m_IQR = null;
    protected double[] m_Median = null;
    protected double[] m_LowerExtremeValue = null;
    protected boolean m_DetectionPerAttribute = false;
    protected int[] m_OutlierAttributePosition = null;
    protected boolean m_OutputOffsetMultiplier = false;

    @Override
    public String globalInfo() {
        return "A filter for detecting outliers and extreme values based on interquartile ranges. The filter skips the class attribute.\n\nOutliers:\n  Q3 + OF*IQR < x <= Q3 + EVF*IQR\n  or\n  Q1 - EVF*IQR <= x < Q1 - OF*IQR\n\nExtreme values:\n  x > Q3 + EVF*IQR\n  or\n  x < Q1 - EVF*IQR\n\nKey:\n  Q1  = 25% quartile\n  Q3  = 75% quartile\n  IQR = Interquartile Range, difference between Q1 and Q3\n  OF  = Outlier Factor\n  EVF = Extreme Value Factor";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSpecifies list of columns to base outlier/extreme value detection\n\ton. If an instance is considered in at least one of those\n\tattributes an outlier/extreme value, it is tagged accordingly.\n 'first' and 'last' are valid indexes.\n\t(default none)", "R", 1, "-R <col1,col2-col4,...>"));
        result.addElement(new Option("\tThe factor for outlier detection.\n\t(default: 3)", "O", 1, "-O <num>"));
        result.addElement(new Option("\tThe factor for extreme values detection.\n\t(default: 2*Outlier Factor)", "E", 1, "-E <num>"));
        result.addElement(new Option("\tTags extreme values also as outliers.\n\t(default: off)", "E-as-O", 0, "-E-as-O"));
        result.addElement(new Option("\tGenerates Outlier/ExtremeValue pair for each numeric attribute in\n\tthe range, not just a single indicator pair for all the attributes.\n\t(default: off)", "P", 0, "-P"));
        result.addElement(new Option("\tGenerates an additional attribute 'Offset' per Outlier/ExtremeValue\n\tpair that contains the multiplier that the value is off the median.\n\t   value = median + 'multiplier' * IQR\n\tNote: implicitely sets '-P'.\t(default: off)", "M", 0, "-M"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption("R", options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndices(tmpStr);
        } else {
            this.setAttributeIndices("first-last");
        }
        tmpStr = Utils.getOption("O", options);
        if (tmpStr.length() != 0) {
            this.setOutlierFactor(Double.parseDouble(tmpStr));
        } else {
            this.setOutlierFactor(3.0);
        }
        tmpStr = Utils.getOption("E", options);
        if (tmpStr.length() != 0) {
            this.setExtremeValuesFactor(Double.parseDouble(tmpStr));
        } else {
            this.setExtremeValuesFactor(2.0 * this.getOutlierFactor());
        }
        this.setExtremeValuesAsOutliers(Utils.getFlag("E-as-O", options));
        this.setDetectionPerAttribute(Utils.getFlag("P", options));
        this.setOutputOffsetMultiplier(Utils.getFlag("M", options));
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-R");
        if (!this.getAttributeIndices().equals("")) {
            result.add(this.getAttributeIndices());
        } else {
            result.add("first-last");
        }
        result.add("-O");
        result.add("" + this.getOutlierFactor());
        result.add("-E");
        result.add("" + this.getExtremeValuesFactor());
        if (this.getExtremeValuesAsOutliers()) {
            result.add("-E-as-O");
        }
        if (this.getDetectionPerAttribute()) {
            result.add("-P");
        }
        if (this.getOutputOffsetMultiplier()) {
            result.add("-M");
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on;  this is a comma separated list of attribute indices, with \"first\" and \"last\" valid values; specify an inclusive range with \"-\", eg: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_Attributes.getRanges();
    }

    public void setAttributeIndices(String value) {
        this.m_Attributes.setRanges(value);
    }

    public void setAttributeIndicesArray(int[] value) {
        this.setAttributeIndices(Range.indicesToRangeList(value));
    }

    public String outlierFactorTipText() {
        return "The factor for determining the thresholds for outliers.";
    }

    public void setOutlierFactor(double value) {
        if (value >= this.getExtremeValuesFactor()) {
            System.err.println("OutlierFactor must be smaller than ExtremeValueFactor");
        } else {
            this.m_OutlierFactor = value;
        }
    }

    public double getOutlierFactor() {
        return this.m_OutlierFactor;
    }

    public String extremeValuesFactorTipText() {
        return "The factor for determining the thresholds for extreme values.";
    }

    public void setExtremeValuesFactor(double value) {
        if (value <= this.getOutlierFactor()) {
            System.err.println("ExtremeValuesFactor must be greater than OutlierFactor!");
        } else {
            this.m_ExtremeValuesFactor = value;
        }
    }

    public double getExtremeValuesFactor() {
        return this.m_ExtremeValuesFactor;
    }

    public String extremeValuesAsOutliersTipText() {
        return "Whether to tag extreme values also as outliers.";
    }

    public void setExtremeValuesAsOutliers(boolean value) {
        this.m_ExtremeValuesAsOutliers = value;
    }

    public boolean getExtremeValuesAsOutliers() {
        return this.m_ExtremeValuesAsOutliers;
    }

    public String detectionPerAttributeTipText() {
        return "Generates Outlier/ExtremeValue attribute pair for each numeric attribute, not just a single pair for all numeric attributes together.";
    }

    public void setDetectionPerAttribute(boolean value) {
        this.m_DetectionPerAttribute = value;
        if (!this.m_DetectionPerAttribute) {
            this.m_OutputOffsetMultiplier = false;
        }
    }

    public boolean getDetectionPerAttribute() {
        return this.m_DetectionPerAttribute;
    }

    public String outputOffsetMultiplierTipText() {
        return "Generates an additional attribute 'Offset' that contains the multiplier the value is off the median: value = median + 'multiplier' * IQR";
    }

    public void setOutputOffsetMultiplier(boolean value) {
        this.m_OutputOffsetMultiplier = value;
        if (this.m_OutputOffsetMultiplier) {
            this.m_DetectionPerAttribute = true;
        }
    }

    public boolean getOutputOffsetMultiplier() {
        return this.m_OutputOffsetMultiplier;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int i;
        this.m_Attributes.setUpper(inputFormat.numAttributes() - 1);
        this.m_AttributeIndices = this.m_Attributes.getSelection();
        for (i = 0; i < this.m_AttributeIndices.length; ++i) {
            if (this.m_AttributeIndices[i] == inputFormat.classIndex()) {
                this.m_AttributeIndices[i] = -1;
                continue;
            }
            if (inputFormat.attribute(this.m_AttributeIndices[i]).isNumeric()) continue;
            this.m_AttributeIndices[i] = -1;
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (i = 0; i < inputFormat.numAttributes(); ++i) {
            atts.add(inputFormat.attribute(i));
        }
        if (!this.getDetectionPerAttribute()) {
            this.m_OutlierAttributePosition = new int[1];
            this.m_OutlierAttributePosition[0] = atts.size();
            ArrayList<String> values = new ArrayList<String>();
            values.add("no");
            values.add("yes");
            atts.add(new Attribute("Outlier", values));
            values = new ArrayList();
            values.add("no");
            values.add("yes");
            atts.add(new Attribute("ExtremeValue", values));
        } else {
            this.m_OutlierAttributePosition = new int[this.m_AttributeIndices.length];
            for (i = 0; i < this.m_AttributeIndices.length; ++i) {
                if (this.m_AttributeIndices[i] == -1) continue;
                this.m_OutlierAttributePosition[i] = atts.size();
                ArrayList<String> values = new ArrayList<String>();
                values.add("no");
                values.add("yes");
                Attribute aO = new Attribute(inputFormat.attribute(this.m_AttributeIndices[i]).name() + "_Outlier", values);
                aO.setWeight(inputFormat.attribute(this.m_AttributeIndices[i]).weight());
                atts.add(aO);
                values = new ArrayList();
                values.add("no");
                values.add("yes");
                Attribute aE = new Attribute(inputFormat.attribute(this.m_AttributeIndices[i]).name() + "_ExtremeValue", values);
                aE.setWeight(inputFormat.attribute(this.m_AttributeIndices[i]).weight());
                atts.add(aE);
                if (!this.getOutputOffsetMultiplier()) continue;
                Attribute aF = new Attribute(inputFormat.attribute(this.m_AttributeIndices[i]).name() + "_Offset");
                aF.setWeight(inputFormat.attribute(this.m_AttributeIndices[i]).weight());
                atts.add(aF);
            }
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        result.setClassIndex(inputFormat.classIndex());
        return result;
    }

    protected void computeThresholds(Instances instances) {
        this.m_UpperExtremeValue = new double[this.m_AttributeIndices.length];
        this.m_UpperOutlier = new double[this.m_AttributeIndices.length];
        this.m_LowerOutlier = new double[this.m_AttributeIndices.length];
        this.m_LowerExtremeValue = new double[this.m_AttributeIndices.length];
        this.m_Median = new double[this.m_AttributeIndices.length];
        this.m_IQR = new double[this.m_AttributeIndices.length];
        for (int i = 0; i < this.m_AttributeIndices.length; ++i) {
            double q3;
            double q1;
            if (this.m_AttributeIndices[i] == -1) continue;
            double[] values = instances.attributeToDoubleArray(this.m_AttributeIndices[i]);
            int[] sortedIndices = Utils.sort(values);
            int half = sortedIndices.length / 2;
            int quarter = half / 2;
            double q2 = sortedIndices.length % 2 == 1 ? values[sortedIndices[half]] : (values[sortedIndices[half]] + values[sortedIndices[half + 1]]) / 2.0;
            if (half % 2 == 1) {
                q1 = values[sortedIndices[quarter]];
                q3 = values[sortedIndices[sortedIndices.length - quarter - 1]];
            } else {
                q1 = (values[sortedIndices[quarter]] + values[sortedIndices[quarter + 1]]) / 2.0;
                q3 = (values[sortedIndices[sortedIndices.length - quarter - 1]] + values[sortedIndices[sortedIndices.length - quarter]]) / 2.0;
            }
            this.m_Median[i] = q2;
            this.m_IQR[i] = q3 - q1;
            this.m_UpperExtremeValue[i] = q3 + this.getExtremeValuesFactor() * this.m_IQR[i];
            this.m_UpperOutlier[i] = q3 + this.getOutlierFactor() * this.m_IQR[i];
            this.m_LowerOutlier[i] = q1 - this.getOutlierFactor() * this.m_IQR[i];
            this.m_LowerExtremeValue[i] = q1 - this.getExtremeValuesFactor() * this.m_IQR[i];
        }
    }

    public double[] getValues(ValueType type) {
        switch (type) {
            case UPPER_EXTREME_VALUES: {
                return this.m_UpperExtremeValue;
            }
            case UPPER_OUTLIER_VALUES: {
                return this.m_UpperOutlier;
            }
            case LOWER_OUTLIER_VALUES: {
                return this.m_LowerOutlier;
            }
            case LOWER_EXTREME_VALUES: {
                return this.m_LowerExtremeValue;
            }
            case MEDIAN: {
                return this.m_Median;
            }
            case IQR: {
                return this.m_IQR;
            }
        }
        throw new IllegalArgumentException("Unhandled value type: " + (Object)((Object)type));
    }

    protected boolean isOutlier(Instance inst, int index) {
        double value = inst.value(this.m_AttributeIndices[index]);
        boolean result = this.m_UpperOutlier[index] < value && value <= this.m_UpperExtremeValue[index] || this.m_LowerExtremeValue[index] <= value && value < this.m_LowerOutlier[index];
        return result;
    }

    protected boolean isOutlier(Instance inst) {
        boolean result = false;
        for (int i = 0; !(i >= this.m_AttributeIndices.length || this.m_AttributeIndices[i] != -1 && (result = this.isOutlier(inst, i))); ++i) {
        }
        return result;
    }

    protected boolean isExtremeValue(Instance inst, int index) {
        double value = inst.value(this.m_AttributeIndices[index]);
        boolean result = value > this.m_UpperExtremeValue[index] || value < this.m_LowerExtremeValue[index];
        return result;
    }

    protected boolean isExtremeValue(Instance inst) {
        boolean result = false;
        for (int i = 0; !(i >= this.m_AttributeIndices.length || this.m_AttributeIndices[i] != -1 && (result = this.isExtremeValue(inst, i))); ++i) {
        }
        return result;
    }

    protected double calculateMultiplier(Instance inst, int index) {
        double value = inst.value(this.m_AttributeIndices[index]);
        double result = (value - this.m_Median[index]) / this.m_IQR[index];
        return result;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        if (!this.isFirstBatchDone()) {
            this.computeThresholds(instances);
        }
        Instances result = this.getOutputFormat();
        int numAttOld = instances.numAttributes();
        int numAttNew = result.numAttributes();
        for (int n = 0; n < instances.numInstances(); ++n) {
            double[] values;
            Instance instOld;
            block8: {
                block7: {
                    instOld = instances.instance(n);
                    values = new double[numAttNew];
                    System.arraycopy(instOld.toDoubleArray(), 0, values, 0, numAttOld);
                    if (this.getDetectionPerAttribute()) break block7;
                    if (this.isOutlier(instOld)) {
                        values[this.m_OutlierAttributePosition[0]] = 1.0;
                    }
                    if (!this.isExtremeValue(instOld)) break block8;
                    values[this.m_OutlierAttributePosition[0] + 1] = 1.0;
                    if (!this.getExtremeValuesAsOutliers()) break block8;
                    values[this.m_OutlierAttributePosition[0]] = 1.0;
                    break block8;
                }
                for (int i = 0; i < this.m_AttributeIndices.length; ++i) {
                    if (this.m_AttributeIndices[i] == -1) continue;
                    if (this.isOutlier(instOld, i)) {
                        values[this.m_OutlierAttributePosition[i]] = 1.0;
                    }
                    if (this.isExtremeValue(instOld, i)) {
                        values[this.m_OutlierAttributePosition[i] + 1] = 1.0;
                        if (this.getExtremeValuesAsOutliers()) {
                            values[this.m_OutlierAttributePosition[i]] = 1.0;
                        }
                    }
                    if (!this.getOutputOffsetMultiplier()) continue;
                    values[this.m_OutlierAttributePosition[i] + 2] = this.calculateMultiplier(instOld, i);
                }
            }
            DenseInstance instNew = new DenseInstance(1.0, values);
            instNew.setDataset(result);
            this.copyValues(instNew, false, instOld.dataset(), this.outputFormatPeek());
            result.add(instNew);
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15448 $");
    }

    public static void main(String[] args) {
        InterquartileRange.runFilter(new InterquartileRange(), args);
    }

    public static enum ValueType {
        UPPER_EXTREME_VALUES,
        UPPER_OUTLIER_VALUES,
        LOWER_OUTLIER_VALUES,
        LOWER_EXTREME_VALUES,
        MEDIAN,
        IQR;

    }
}

