#!/bin/bash
#***************************************************************************************************
#                                            gnuplot.sh                                            *
#                                           ------------                                           *
# Description : This shell script runs gnuplot using a gspiceui data file as input.                *
# Started     : 2016-04-10                                                                         *
# Last Update : 2016-04-18                                                                         *
# Author      : Mike Waters                                                                        *
# Notes       : An example of the command line generated by this script is :                       *
#                 plot "aem6000-dtk-surge-limit.ngspice.tr" using 1:2 with lines title "V(Lr)", \  *
#                 "aem6000-dtk-surge-limit.ngspice.tr" using 1:3 with lines title "V(Rr)" \        *
#                 | gnuplot -persist                                                               *
#***************************************************************************************************
# THINGS TO DO
#
# (2014-01-22) Implement this function as a gnuplot batch file.
#***************************************************************************************************

FILE="$1"
echo "FILE =" $FILE

HEAD=`head -n 1 $FILE | tr -s ' '`
echo "HEAD =" $HEAD

COLS=`echo $HEAD | wc -w`
echo "COLS =" $COLS

TMP1=`seq 2 $COLS`
echo "TMP1 =" $TMP1

{
  echo -n plot 
  for x in `seq 2 $COLS` ; do
    echo -n \ \"$FILE\" using 1:$x with lines title \"`echo $HEAD | cut -d ' ' -f $x`\"
    if [ ! $x -eq $COLS ] ; then
      echo -n ','
    fi
  done
  echo
#}
} | gnuplot -persist

#***************************************************************************************************
