/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.resource;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import uk.org.webcompere.systemstubs.resource.Executable;
import uk.org.webcompere.systemstubs.resource.TestResource;

public class Resources {
    public static <T> Executable with(final TestResource ... resources) {
        return new Executable(){

            @Override
            public <T> T execute(Callable<T> callable) throws Exception {
                return Resources.execute(callable, resources);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(Callable<T> callable, TestResource ... resources) throws Exception {
        LinkedList<TestResource> resourcesSetUp = new LinkedList<TestResource>();
        try {
            for (TestResource resource : resources) {
                resourcesSetUp.addFirst(resource);
                resource.setup();
            }
            T t = callable.call();
            return t;
        }
        finally {
            Resources.executeCleanup(resourcesSetUp);
        }
    }

    public static void executeCleanup(List<TestResource> resourcesSetUp) throws Exception {
        Exception firstExceptionThrownOnTidyUp = null;
        for (TestResource resource : resourcesSetUp) {
            try {
                resource.teardown();
            }
            catch (Exception e) {
                firstExceptionThrownOnTidyUp = firstExceptionThrownOnTidyUp == null ? e : firstExceptionThrownOnTidyUp;
            }
        }
        if (firstExceptionThrownOnTidyUp != null) {
            throw firstExceptionThrownOnTidyUp;
        }
    }
}

