/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;

public class ArrayConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class type) {
        return type.isArray();
    }

    @Override
    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object retValue = this.fromExpression(configuration, expressionEvaluator, type);
        if (retValue != null) {
            return retValue;
        }
        ArrayList<Object> values2 = new ArrayList<Object>();
        for (int i = 0; i < configuration.getChildCount(); ++i) {
            PlexusConfiguration childConfiguration = configuration.getChild(i);
            String configEntry = childConfiguration.getName();
            String name = this.fromXML(configEntry);
            Class<?> childType = this.getClassForImplementationHint(null, childConfiguration, classLoader);
            if (childType == null && name.indexOf(46) > 0) {
                try {
                    childType = classLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (childType == null) {
                String className;
                String baseTypeName = baseType.getName();
                int lastDot = baseTypeName.lastIndexOf(46);
                if (lastDot == -1) {
                    className = name;
                } else {
                    String basePackage = baseTypeName.substring(0, lastDot);
                    className = basePackage + "." + StringUtils.capitalizeFirstLetter(name);
                }
                try {
                    childType = classLoader.loadClass(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (childType == null) {
                childType = type.getComponentType();
            }
            ConfigurationConverter converter = converterLookup.lookupConverterForType(childType);
            Object object = converter.fromConfiguration(converterLookup, childConfiguration, childType, baseType, classLoader, expressionEvaluator, listener);
            values2.add(object);
        }
        try {
            return values2.toArray((Object[])Array.newInstance(type.getComponentType(), 0));
        }
        catch (ArrayStoreException e) {
            throw new ComponentConfigurationException("Cannot assign configuration values to array of type " + type.getComponentType().getName() + ": " + values2);
        }
    }
}

