/*
 * Decompiled with CFR 0.152.
 */
package mill.util;

import java.io.Serializable;
import mill.api.AggWrapper;
import mill.api.Strict$;
import mill.moduledefs.Scaladoc;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Scaladoc(value="/**\n * A map from keys to collections of values: you can assign multiple values\n * to any particular key. Also allows lookups in both directions: what values\n * are assigned to a key or what key a value is assigned to.\n */")
@ScalaSignature(bytes="\u0006\u0005\u0005-faB\u0010!!\u0003\r\n!\n\u0005\u0006[\u00011\tA\f\u0005\u0006\u007f\u00011\t\u0001\u0011\u0005\u0006/\u00021\t\u0001\u0017\u0005\u00065\u00021\ta\u0017\u0005\u0006A\u00021\t!\u0019\u0005\u0006O\u00021\t\u0001\u001b\u0005\u0006U\u00021\ta\u001b\u0005\u0006q\u00021\t!\u001f\u0005\u0006{\u00021\tA \u0005\b\u0003\u000f\u0001a\u0011AA\u0005\u0011\u001d\ti\u0001\u0001D\u0001\u0003\u001f9q!a\u000b!\u0011\u0003\tiC\u0002\u0004 A!\u0005\u0011\u0011\u0007\u0005\b\u0003giA\u0011AA\u001b\r\u0019\t9$\u0004\u0001\u0002:!9\u00111G\b\u0005\u0002\u0005\u001d\u0003\u0002CA'\u001f\u0001\u0006I!a\u0014\t\u0011\u0005}s\u0002)A\u0005\u0003CBa!L\b\u0005\u0002\u0005=\u0004BB \u0010\t\u0003\t\u0019\bC\u0004\u0002x=!\t!!\u001f\t\r]{A\u0011AA@\u0011\u0019Qv\u0002\"\u0001\u0002\u0004\"1\u0001m\u0004C\u0001\u0003\u0013CaaZ\b\u0005\u0002\u0005=\u0005B\u00026\u0010\t\u0003\t)\n\u0003\u0004y\u001f\u0011\u0005\u0011Q\u0014\u0005\b\u0003\u000fyA\u0011AAQ\u0011\u0019ix\u0002\"\u0001\u0002&\"9\u0011QB\b\u0005\u0002\u0005=!AC'vYRL')['ba*\u0011\u0011EI\u0001\u0005kRLGNC\u0001$\u0003\u0011i\u0017\u000e\u001c7\u0004\u0001U\u0019a%\u0016\u001c\u0014\u0005\u00019\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g-A\u0007d_:$\u0018-\u001b8t-\u0006dW/\u001a\u000b\u0003_I\u0002\"\u0001\u000b\u0019\n\u0005EJ#a\u0002\"p_2,\u0017M\u001c\u0005\u0006g\u0005\u0001\r\u0001N\u0001\u0002mB\u0011QG\u000e\u0007\u0001\t\u00159\u0004A1\u00019\u0005\u00051\u0016CA\u001d=!\tA#(\u0003\u0002<S\t9aj\u001c;iS:<\u0007C\u0001\u0015>\u0013\tq\u0014FA\u0002B]f\f\u0011\u0002\\8pWV\u00048*Z=\u0015\u0005\u0005\u0013\u0006c\u0001\"Oi9\u00111i\u0013\b\u0003\t&s!!\u0012%\u000e\u0003\u0019S!a\u0012\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013B\u0001&#\u0003\r\t\u0007/[\u0005\u0003\u00196\u000baa\u0015;sS\u000e$(B\u0001&#\u0013\ty\u0005KA\u0002BO\u001eL!!U'\u0003\u0015\u0005;wm\u0016:baB,'\u000fC\u0003T\u0005\u0001\u0007A+A\u0001l!\t)T\u000bB\u0003W\u0001\t\u0007\u0001HA\u0001L\u0003-awn\\6vaZ\u000bG.^3\u0015\u0005QK\u0006\"B\u001a\u0004\u0001\u0004!\u0014A\u00047p_.,\bOV1mk\u0016|\u0005\u000f\u001e\u000b\u00039~\u00032\u0001K/U\u0013\tq\u0016F\u0001\u0004PaRLwN\u001c\u0005\u0006g\u0011\u0001\r\u0001N\u0001\u0004C\u0012$Gc\u00012fMB\u0011\u0001fY\u0005\u0003I&\u0012A!\u00168ji\")1+\u0002a\u0001)\")1'\u0002a\u0001i\u0005I!/Z7pm\u0016\fE\u000e\u001c\u000b\u0003\u0003&DQa\u0015\u0004A\u0002Q\u000ba!\u00193e\u00032dGc\u00012m[\")1k\u0002a\u0001)\")an\u0002a\u0001_\u0006\u0011ao\u001d\t\u0004aV$dBA9t\u001d\t)%/C\u0001+\u0013\t!\u0018&A\u0004qC\u000e\\\u0017mZ3\n\u0005Y<(\u0001D%uKJ\f'\r\\3P]\u000e,'B\u0001;*\u0003\u0011YW-_:\u0015\u0003i\u00042\u0001]>U\u0013\taxO\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003\u0015IG/Z7t)\u0005y\b\u0003\u00029|\u0003\u0003\u0001R\u0001KA\u0002)\u0006K1!!\u0002*\u0005\u0019!V\u000f\u001d7fe\u00051a/\u00197vKN$\"!a\u0003\u0011\u0007A\\\u0018)\u0001\u0005lKf\u001cu.\u001e8u+\t\t\t\u0002E\u0002)\u0003'I1!!\u0006*\u0005\rIe\u000e\u001e\u0015\b\u0001\u0005e\u0011QEA\u0014!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010E\u0005QQn\u001c3vY\u0016$WMZ:\n\t\u0005\r\u0012Q\u0004\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\u0012\u0011\u0011F\u0001\u0002>>R#F\u0003\u0011+A\u0005\u0003S.\u00199!MJ|W\u000eI6fsN\u0004Co\u001c\u0011d_2dWm\u0019;j_:\u001c\be\u001c4!m\u0006dW/Z:;Ae|W\u000fI2b]\u0002\n7o]5h]\u0002jW\u000f\u001c;ja2,\u0007E^1mk\u0016\u001c(\u0002\t\u0016!i>\u0004\u0013M\\=!a\u0006\u0014H/[2vY\u0006\u0014\be[3z]\u0001\nEn]8!C2dwn^:!Y>|7.\u001e9tA%t\u0007EY8uQ\u0002\"\u0017N]3di&|gn\u001d\u001e!o\"\fG\u000f\t<bYV,7O\u0003\u0011+A\u0005\u0014X\rI1tg&<g.\u001a3!i>\u0004\u0013\rI6fs\u0002z'\u000fI<iCR\u00043.Z=!C\u00022\u0018\r\\;fA%\u001c\b%Y:tS\u001etW\r\u001a\u0011u_:R\u0001EK\u0018\u0002\u00155+H\u000e^5CS6\u000b\u0007\u000fE\u0002\u000205i\u0011\u0001I\n\u0003\u001b\u001d\na\u0001P5oSRtDCAA\u0017\u0005\u001diU\u000f^1cY\u0016,b!a\u000f\u0002B\u0005\u00153\u0003B\b(\u0003{\u0001r!a\f\u0001\u0003\u007f\t\u0019\u0005E\u00026\u0003\u0003\"QAV\bC\u0002a\u00022!NA#\t\u00159tB1\u00019)\t\tI\u0005E\u0004\u0002L=\ty$a\u0011\u000e\u00035\t!B^1mk\u0016$vnS3z!!\t\t&a\u0017\u0002D\u0005}RBAA*\u0015\u0011\t)&a\u0016\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011L\u0015\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002^\u0005M#!\u0004'j].,G\rS1tQ6\u000b\u0007/A\u0006lKf$vNV1mk\u0016\u001c\b\u0003CA)\u00037\ny$a\u0019\u0011\r\u0005\u0015\u00141NA\"\u001d\r\u0011\u0015qM\u0005\u0004\u0003S\u0002\u0016aA!hO&!\u0011qGA7\u0015\r\tI\u0007\u0015\u000b\u0004_\u0005E\u0004BB\u001a\u0014\u0001\u0004\t\u0019\u0005\u0006\u0003\u0002d\u0005U\u0004BB*\u0015\u0001\u0004\ty$\u0001\u0007m_>\\W\u000f]&fs>\u0003H\u000f\u0006\u0003\u0002|\u0005u\u0004\u0003\u0002\u0015^\u0003GBaaU\u000bA\u0002\u0005}B\u0003BA \u0003\u0003Caa\r\fA\u0002\u0005\rC\u0003BAC\u0003\u000f\u0003B\u0001K/\u0002@!11g\u0006a\u0001\u0003\u0007\"RAYAF\u0003\u001bCaa\u0015\rA\u0002\u0005}\u0002BB\u001a\u0019\u0001\u0004\t\u0019\u0005\u0006\u0003\u0002\u0012\u0006M\u0005\u0003\u0002\"O\u0003\u0007BaaU\rA\u0002\u0005}B#\u00022\u0002\u0018\u0006e\u0005BB*\u001b\u0001\u0004\ty\u0004\u0003\u0004o5\u0001\u0007\u00111\u0014\t\u0005aV\f\u0019\u0005\u0006\u0002\u0002 B!\u0001o_A )\t\t\u0019\u000b\u0005\u0003qw\u0006\rDCAAT!\u0011\u000180!+\u0011\u000f!\n\u0019!a\u0010\u0002d\u0001")
public interface MultiBiMap<K, V> {
    public boolean containsValue(V var1);

    public AggWrapper.Agg<V> lookupKey(K var1);

    public K lookupValue(V var1);

    public Option<K> lookupValueOpt(V var1);

    public void add(K var1, V var2);

    public AggWrapper.Agg<V> removeAll(K var1);

    public void addAll(K var1, IterableOnce<V> var2);

    public Iterator<K> keys();

    public Iterator<Tuple2<K, AggWrapper.Agg<V>>> items();

    public Iterator<AggWrapper.Agg<V>> values();

    public int keyCount();

    public static class Mutable<K, V>
    implements MultiBiMap<K, V> {
        private final LinkedHashMap<V, K> valueToKey = LinkedHashMap$.MODULE$.empty();
        private final LinkedHashMap<K, AggWrapper.Agg.Mutable<V>> keyToValues = LinkedHashMap$.MODULE$.empty();

        @Override
        public boolean containsValue(V v) {
            return this.valueToKey.contains(v);
        }

        @Override
        public AggWrapper.Agg.Mutable<V> lookupKey(K k) {
            return (AggWrapper.Agg.Mutable)this.keyToValues.apply(k);
        }

        public Option<AggWrapper.Agg.Mutable<V>> lookupKeyOpt(K k) {
            return this.keyToValues.get(k);
        }

        @Override
        public K lookupValue(V v) {
            return (K)this.valueToKey.apply(v);
        }

        @Override
        public Option<K> lookupValueOpt(V v) {
            return this.valueToKey.get(v);
        }

        @Override
        public void add(K k, V v) {
            this.valueToKey.update(v, k);
            this.keyToValues.getOrElseUpdate(k, (Function0<AggWrapper.Agg.Mutable> & Serializable)() -> new AggWrapper.Agg.Mutable(Strict$.MODULE$.Agg())).append(v);
        }

        @Override
        public AggWrapper.Agg<V> removeAll(K k) {
            Option<AggWrapper.Agg.Mutable<V>> option = this.keyToValues.get(k);
            if (None$.MODULE$.equals(option)) {
                return (AggWrapper.Agg)Strict$.MODULE$.Agg().apply((Seq)Nil$.MODULE$);
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                AggWrapper.Agg.Mutable vs = (AggWrapper.Agg.Mutable)some.value();
                vs.iterator().foreach((Function1<Object, Option> & Serializable)key2 -> $this.valueToKey.remove(key2));
                this.keyToValues.remove(k);
                return vs;
            }
            throw new MatchError(option);
        }

        @Override
        public void addAll(K k, IterableOnce<V> vs) {
            vs.iterator().foreach((Function1<Object, Object> & Serializable)x$1 -> {
                this.add(k, x$1);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public Iterator<K> keys() {
            return this.keyToValues.keysIterator();
        }

        @Override
        public Iterator<AggWrapper.Agg.Mutable<V>> values() {
            return this.keyToValues.valuesIterator();
        }

        @Override
        public Iterator<Tuple2<K, AggWrapper.Agg.Mutable<V>>> items() {
            return this.keyToValues.iterator();
        }

        @Override
        public int keyCount() {
            return this.keyToValues.size();
        }
    }
}

