/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.WieldCategory;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;

public class PreEquipTester
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    @Override
    public int passes(Prerequisite prereq, PlayerCharacter character, CDOMObject source) throws PrerequisiteException {
        int number;
        int runningTotal = 0;
        try {
            number = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException exceptn) {
            throw new PrerequisiteException(LanguageBundle.getFormattedString("PreFeat.error", prereq.toString()));
        }
        CharacterDisplay display = character.getDisplay();
        if (display.hasEquipment()) {
            String targetEquip = prereq.getKey();
            for (Equipment eq : display.getEquippedEquipmentSet()) {
                String eqName;
                if (targetEquip.startsWith("WIELDCATEGORY=") || targetEquip.startsWith("WIELDCATEGORY.")) {
                    WieldCategory wCat = eq.getEffectiveWieldCategory(character);
                    if (wCat == null || !wCat.getKeyName().equalsIgnoreCase(targetEquip.substring(14))) continue;
                    ++runningTotal;
                    break;
                }
                if (targetEquip.startsWith("TYPE=") || targetEquip.startsWith("TYPE.")) {
                    StringTokenizer tok = new StringTokenizer(targetEquip.substring(5).toUpperCase(), ".");
                    boolean match = false;
                    if (tok.hasMoreTokens()) {
                        match = true;
                    }
                    while (tok.hasMoreTokens()) {
                        String type = tok.nextToken();
                        if (eq.isType(type)) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    ++runningTotal;
                    break;
                }
                if (targetEquip.startsWith("BASEITEM=")) {
                    eqName = eq.getBaseItemName().toUpperCase();
                    targetEquip = targetEquip.substring(targetEquip.indexOf("=") + 1);
                } else {
                    eqName = eq.getName().toUpperCase();
                }
                if (targetEquip.indexOf(37) >= 0) {
                    int percentPos = targetEquip.indexOf(37);
                    String substring = targetEquip.substring(0, percentPos).toUpperCase();
                    if (!eqName.startsWith(substring)) continue;
                    ++runningTotal;
                    break;
                }
                if (!eqName.equalsIgnoreCase(targetEquip)) continue;
                ++runningTotal;
                break;
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, number);
        return this.countedTotal(prereq, runningTotal);
    }

    @Override
    public String kindHandled() {
        return "EQUIP";
    }
}

