/*
 * Decompiled with CFR 0.152.
 */
package plugin.network;

import gmgen.plugin.Combatant;
import gmgen.plugin.State;
import gmgen.plugin.SystemAttribute;
import gmgen.plugin.SystemHP;
import gmgen.plugin.SystemInitiative;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Element;
import plugin.network.NetworkClient;
import plugin.network.NetworkInitiative;

public class NetworkCombatant
extends Combatant {
    protected String name = "";
    protected String uid;
    protected String player = "";
    protected String htmlString = "";
    protected float cr = 0.0f;
    protected int xp = 0;
    protected Socket sock;

    public NetworkCombatant(String uid, Socket sock) {
        this.uid = uid;
        this.sock = sock;
        this.init = new NetworkInitiative(uid, sock);
        this.hitPoints = new SystemHP(new SystemAttribute("Constitution", 10), 1, 1);
    }

    @Override
    public void setCR(float cr) {
        this.cr = cr;
        this.sendNetMessage("CR|" + cr);
    }

    @Override
    public float getCR() {
        return this.cr;
    }

    public String getUid() {
        return this.uid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setCombatantType(String comType) {
        super.setCombatantType(comType);
        this.sendNetMessage("COMTYPE|" + comType);
    }

    @Override
    public void setDuration(int duration) {
        super.setDuration(duration);
        this.sendNetMessage("DURATION|" + duration);
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.sendNetMessage("NAME|" + name);
    }

    @Override
    public void setNumber(int number) {
        super.setNumber(number);
        this.sendNetMessage("NUMBER|" + number);
    }

    @Override
    public Vector<Object> getRowVector(List<String> columnOrder) {
        Vector<Object> rowVector = new Vector<Object>();
        for (String columnName : columnOrder) {
            if (columnName.equals("Name")) {
                rowVector.add(this.getName());
                continue;
            }
            if (columnName.equals("Player")) {
                rowVector.add("Net: " + this.getPlayer());
                continue;
            }
            if (columnName.equals("Status")) {
                rowVector.add((Object)this.getStatus());
                continue;
            }
            if (columnName.equals("+")) {
                rowVector.add("" + this.init.getModifier());
                continue;
            }
            if (columnName.equals("Init")) {
                rowVector.add("" + this.init.getCurrentInitiative());
                continue;
            }
            if (columnName.equals("Dur")) {
                if (this.duration == 0) {
                    rowVector.add("");
                    continue;
                }
                rowVector.add("" + this.getDuration());
                continue;
            }
            if (columnName.equals("#")) {
                rowVector.add("" + this.number);
                continue;
            }
            if (columnName.equals("HP")) {
                int hp = this.hitPoints.getCurrent();
                int sub = this.hitPoints.getSubdual();
                if (sub == 0) {
                    rowVector.add("" + hp);
                    continue;
                }
                if (sub <= 0) continue;
                rowVector.add(hp + "/" + sub + "s");
                continue;
            }
            if (columnName.equals("HP Max")) {
                rowVector.add("" + this.hitPoints.getMax());
                continue;
            }
            if (!columnName.equals("Type")) continue;
            rowVector.add(this.comType);
        }
        return rowVector;
    }

    @Override
    public void editRow(List<String> columnOrder, int colNumber, Object data) {
        String columnName = columnOrder.get(colNumber);
        String strData = String.valueOf(data);
        if (columnName.equals("Name")) {
            this.setName(strData);
        } else if (columnName.equals("Player")) {
            this.setPlayer(strData);
        } else if (columnName.equals("Status")) {
            this.setStatus((State)((Object)data));
        } else if (columnName.equals("+")) {
            this.init.setBonus(Integer.parseInt(strData));
        } else if (columnName.equals("Init")) {
            this.init.setCurrentInitiative(Integer.parseInt(strData));
        } else if (columnName.equals("#")) {
            this.setNumber(Integer.parseInt(strData));
        } else if (columnName.equals("HP")) {
            this.hitPoints.setCurrent(Integer.parseInt(strData));
            this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
            this.sendNetMessage("HPSTATE|" + (Object)((Object)this.hitPoints.getState()));
            this.sendNetMessage("STATUS|" + (Object)((Object)this.status));
        } else if (columnName.equals("HP Max")) {
            this.hitPoints.setMax(Integer.parseInt(strData));
            this.sendNetMessage("HPMAX|" + this.hitPoints.getMax());
            this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
            this.sendNetMessage("HPSTATE|" + (Object)((Object)this.hitPoints.getState()));
            this.sendNetMessage("STATUS|" + (Object)((Object)this.status));
        } else if (columnName.equals("Dur")) {
            this.setDuration(Integer.parseInt(strData));
        } else if (columnName.equals("Type")) {
            this.setCombatantType(strData);
        }
    }

    @Override
    public void setStatus(State status) {
        super.setStatus(status);
        this.sendNetMessage("STATUS|" + status.name());
    }

    @Override
    public void setXP(int xp) {
        this.xp = xp;
        this.sendNetMessage("XP|" + xp);
    }

    @Override
    public int getXP() {
        return this.xp;
    }

    @Override
    public void bleed() {
        super.bleed();
        this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
        this.sendNetMessage("HPSTATE|" + (Object)((Object)this.hitPoints.getState()));
        this.sendNetMessage("STATUS|" + (Object)((Object)this.status));
    }

    @Override
    public void damage(int damage) {
        super.damage(damage);
        this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
        this.sendNetMessage("HPSTATE|" + (Object)((Object)this.hitPoints.getState()));
        this.sendNetMessage("STATUS|" + (Object)((Object)this.status));
    }

    @Override
    public int decDuration() {
        super.decDuration();
        this.sendNetMessage("DURATION|" + this.duration);
        this.sendNetMessage("HPSTATE|" + (Object)((Object)this.hitPoints.getState()));
        this.sendNetMessage("STATUS|" + (Object)((Object)this.status));
        return this.duration;
    }

    @Override
    public void endRound() {
        super.endRound();
        this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
        this.sendNetMessage("HPSTATE|" + (Object)((Object)this.hitPoints.getState()));
        this.sendNetMessage("STATUS|" + (Object)((Object)this.status));
    }

    @Override
    public void heal(int heal) {
        super.heal(heal);
        this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
        this.sendNetMessage("HPSTATE|" + (Object)((Object)this.hitPoints.getState()));
        this.sendNetMessage("STATUS|" + (Object)((Object)this.status));
    }

    @Override
    public void kill() {
        super.kill();
        this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
        this.sendNetMessage("HPSTATE|" + (Object)((Object)this.hitPoints.getState()));
        this.sendNetMessage("STATUS|" + (Object)((Object)this.status));
    }

    @Override
    public void nonLethalDamage(boolean type) {
        super.nonLethalDamage(type);
        this.sendNetMessage("DURATION|" + this.duration);
        this.sendNetMessage("STATUS|" + (Object)((Object)this.status));
    }

    @Override
    public void raise() {
        super.raise();
        this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
        this.sendNetMessage("HPSTATE|" + (Object)((Object)this.hitPoints.getState()));
        this.sendNetMessage("STATUS|" + (Object)((Object)this.status));
    }

    @Override
    public void stabilize() {
        super.stabilize();
        this.sendNetMessage("STATUS|" + (Object)((Object)this.status));
    }

    @Override
    public void subdualDamage(int damage) {
        super.subdualDamage(damage);
        this.sendNetMessage("HPSUB|" + this.hitPoints.getSubdual());
        this.sendNetMessage("HPSTATE|" + (Object)((Object)this.hitPoints.getState()));
        this.sendNetMessage("STATUS|" + (Object)((Object)this.status));
    }

    @Override
    public SystemInitiative getInitiative() {
        return this.init;
    }

    @Override
    public String getPlayer() {
        return this.player;
    }

    public void setPlayer(String player) {
        this.player = player;
        this.sendNetMessage("PLAYER|" + player);
    }

    @Override
    public Element getSaveElement() {
        return new Element("NetworkCombatant");
    }

    private void sendNetMessage(String message) {
        try {
            PrintStream os = new PrintStream((OutputStream)new BufferedOutputStream(this.sock.getOutputStream()), true, "UTF-8");
            os.print("Pcg: " + this.uid + ":" + message + "\r\n");
            os.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void recieveNetMessage(String message) {
        String type = "";
        String value = "";
        StringTokenizer st = new StringTokenizer(message, "|");
        if (st.hasMoreTokens()) {
            type = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            value = st.nextToken();
        }
        try {
            if (type != "" && value != "") {
                if (type.equals("COMTYPE")) {
                    super.setCombatantType(value);
                } else if (type.equals("CR")) {
                    this.cr = Float.parseFloat(value);
                } else if (type.equals("DURATION")) {
                    super.setDuration(Integer.parseInt(value));
                } else if (type.equals("HP")) {
                    this.hitPoints.setCurrent(Integer.parseInt(value));
                } else if (type.equals("HPMAX")) {
                    this.hitPoints.setMax(Integer.parseInt(value));
                } else if (type.equals("HPSUB")) {
                    this.hitPoints.setSubdual(Integer.parseInt(value));
                } else if (type.equals("HPSTATE")) {
                    this.hitPoints.setState(State.getState(value));
                } else if (type.equals("NAME")) {
                    this.name = value;
                } else if (type.equals("NUMBER")) {
                    super.setNumber(Integer.parseInt(value));
                } else if (type.equals("PLAYER")) {
                    this.player = value;
                } else if (type.equals("STATUS")) {
                    super.setStatus(State.getState(value));
                } else if (type.equals("XP")) {
                    this.xp = Integer.parseInt(value);
                } else if (type.startsWith("HTMLSTRING")) {
                    this.htmlString = value;
                } else if (type.startsWith("INIT")) {
                    ((NetworkInitiative)this.init).recieveNetMessage(message);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void recieveServerMessage(String message, Combatant cbt) {
        String type = "";
        String value = "";
        StringTokenizer st = new StringTokenizer(message, "|");
        if (st.hasMoreTokens()) {
            type = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            value = st.nextToken();
        }
        try {
            if (type != "" && value != "") {
                if (type.equals("COMTYPE")) {
                    cbt.setCombatantType(value);
                } else if (type.equals("CR")) {
                    cbt.setCR(Float.parseFloat(value));
                } else if (type.equals("DURATION")) {
                    cbt.setDuration(Integer.parseInt(value));
                } else if (type.equals("HPMAX")) {
                    cbt.getHP().setMax(Integer.parseInt(value));
                } else if (type.equals("HP")) {
                    cbt.getHP().setCurrent(Integer.parseInt(value));
                } else if (type.equals("HPSUB")) {
                    cbt.getHP().setSubdual(Integer.parseInt(value));
                } else if (type.equals("HPSTATE")) {
                    cbt.getHP().setState(State.getState(value));
                } else if (type.equals("NAME")) {
                    cbt.setName(value);
                } else if (type.equals("NUMBER")) {
                    cbt.setNumber(Integer.parseInt(value));
                } else if (type.equals("STATUS")) {
                    cbt.setStatus(State.getState(value));
                } else if (type.equals("XP")) {
                    cbt.setXP(Integer.parseInt(value));
                } else if (type.startsWith("INITBONUS")) {
                    cbt.init.setBonus(Integer.parseInt(value));
                } else if (type.startsWith("INIT")) {
                    cbt.init.setCurrentInitiative(Integer.parseInt(value));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static String getCombatantUid(Combatant cbt, String user) {
        return cbt.getName() + "-" + cbt.getPlayer() + "-" + user;
    }

    public static void sendCombatant(Combatant cbt, NetworkClient client) {
        String uid = NetworkCombatant.getCombatantUid(cbt, client.getUser());
        client.sendPcgMessage(uid, "COMTYPE|" + cbt.getCombatantType());
        client.sendPcgMessage(uid, "CR|" + cbt.getCR());
        client.sendPcgMessage(uid, "DURATION|" + cbt.getDuration());
        client.sendPcgMessage(uid, "HPMAX|" + cbt.getHP().getMax());
        client.sendPcgMessage(uid, "HP|" + cbt.getHP().getCurrent());
        client.sendPcgMessage(uid, "HPSUB|" + cbt.getHP().getSubdual());
        client.sendPcgMessage(uid, "HPSTATE|" + (Object)((Object)cbt.getHP().getState()));
        client.sendPcgMessage(uid, "NAME|" + cbt.getName());
        client.sendPcgMessage(uid, "NUMBER|" + cbt.getNumber());
        client.sendPcgMessage(uid, "PLAYER|" + cbt.getPlayer());
        client.sendPcgMessage(uid, "STATUS|" + (Object)((Object)cbt.getStatus()));
        client.sendPcgMessage(uid, "XP|" + cbt.getXP());
        client.sendPcgMessage(uid, "INITBONUS|" + cbt.init.getModifier());
        client.sendPcgMessage(uid, "INIT|" + cbt.init.getCurrentInitiative());
        client.sendPcgMessage(uid, "HTMLSTRING|" + cbt.toHtmlString());
    }

    @Override
    public String toHtmlString() {
        return this.htmlString;
    }
}

