/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass.level;

import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.MapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.Domain;
import pcgen.core.PCClass;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class AdddomainsToken
extends AbstractTokenWithSeparator<PCClassLevel>
implements CDOMPrimaryToken<PCClassLevel> {
    private static final Class<Domain> DOMAIN_CLASS = Domain.class;

    @Override
    public String getTokenName() {
        return "ADDDOMAINS";
    }

    @Override
    protected char separator() {
        return '.';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClassLevel level, String value) {
        StringTokenizer tok = new StringTokenizer(value, ".");
        while (tok.hasMoreTokens()) {
            String domainKey;
            String tokString = tok.nextToken();
            Prerequisite prereq = null;
            int openBracketLoc = tokString.indexOf(91);
            if (openBracketLoc == -1) {
                if (tokString.indexOf(93) != -1) {
                    return new ParseResult.Fail("Invalid " + this.getTokenName() + " must have '[' if it contains a PREREQ tag", context);
                }
                domainKey = tokString;
            } else {
                if (tokString.indexOf(93) != tokString.length() - 1) {
                    return new ParseResult.Fail("Invalid " + this.getTokenName() + " must end with ']' if it contains a PREREQ tag", context);
                }
                domainKey = tokString.substring(0, openBracketLoc);
                String prereqString = tokString.substring(openBracketLoc + 1, tokString.length() - 1);
                if (prereqString.length() == 0) {
                    return new ParseResult.Fail(this.getTokenName() + " cannot have empty prerequisite : " + value, context);
                }
                prereq = this.getPrerequisite(prereqString);
                if (prereq == null) {
                    return new ParseResult.Fail(this.getTokenName() + " had invalid prerequisite : " + prereqString, context);
                }
            }
            AssociatedPrereqObject apo = context.getListContext().addToList(this.getTokenName(), level, PCClass.ALLOWED_DOMAINS, context.getReferenceContext().getCDOMReference(DOMAIN_CLASS, domainKey));
            if (prereq == null) continue;
            apo.addPrerequisite(prereq);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, PCClassLevel level) {
        AssociatedChanges changes = context.getListContext().getChangesInList(this.getTokenName(), level, PCClass.ALLOWED_DOMAINS);
        Collection removedItems = changes.getRemoved();
        if (removedItems != null && !removedItems.isEmpty() || changes.includesGlobalClear()) {
            context.addWriteMessage(this.getTokenName() + " does not support .CLEAR");
            return null;
        }
        MapToList mtl = changes.getAddedAssociations();
        if (mtl == null || mtl.isEmpty()) {
            return null;
        }
        PrerequisiteWriter prereqWriter = new PrerequisiteWriter();
        TreeSet<String> set = new TreeSet<String>();
        for (CDOMReference domain : mtl.getKeySet()) {
            for (AssociatedPrereqObject assoc : mtl.getListFor((Object)domain)) {
                Prerequisite prereq;
                StringBuilder sb = new StringBuilder(domain.getLSTformat(false));
                List<Prerequisite> prereqs = assoc.getPrerequisiteList();
                if (prereqs == null || prereqs.size() == 0) {
                    prereq = null;
                } else if (prereqs.size() == 1) {
                    prereq = prereqs.get(0);
                } else {
                    context.addWriteMessage("Added Domain from " + this.getTokenName() + " had more than one " + "Prerequisite: " + prereqs.size());
                    return null;
                }
                if (prereq != null) {
                    sb.append('[');
                    StringWriter swriter = new StringWriter();
                    try {
                        prereqWriter.write(swriter, prereq);
                    }
                    catch (PersistenceLayerException e) {
                        context.addWriteMessage("Error writing Prerequisite: " + e);
                        return null;
                    }
                    sb.append(swriter.toString());
                    sb.append(']');
                }
                set.add(sb.toString());
            }
        }
        return new String[]{StringUtil.join(set, (String)".")};
    }

    @Override
    public Class<PCClassLevel> getTokenClass() {
        return PCClassLevel.class;
    }
}

