/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode.migrate;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import pcgen.core.system.MigrationRule;
import pcgen.persistence.lst.MigrationLstToken;
import pcgen.util.Logging;

public class NewCategoryToken
implements MigrationLstToken {
    private Pattern invalidKeyPattern = Pattern.compile(".*[,|\\||\\\\|:|;|\\.|%|\\*|=|\\[|\\]].*");

    @Override
    public String getTokenName() {
        return "NEWCATEGORY";
    }

    @Override
    public boolean parse(MigrationRule migrationRule, String value, String gameModeName) {
        if (StringUtils.isBlank(value)) {
            Logging.log(Logging.LST_ERROR, "Invalid empty " + this.getTokenName() + " value.");
            return false;
        }
        if (this.invalidKeyPattern.matcher(value).matches()) {
            Logging.log(Logging.LST_ERROR, "Invalid characters in value '" + value + "' of " + this.getTokenName() + ":" + value);
            return false;
        }
        migrationRule.setNewCategory(value);
        return true;
    }
}

