/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.datacontrol;

import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.fact.FactDefinition;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.StringPClassUtil;

public class FactDefToken
extends AbstractTokenWithSeparator<FactDefinition>
implements CDOMPrimaryToken<FactDefinition> {
    @Override
    public String getTokenName() {
        return "FACTDEF";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, FactDefinition def, String value) {
        Class cl;
        StringTokenizer aTok = new StringTokenizer(value, "|");
        String usableLocation = aTok.nextToken();
        if (!aTok.hasMoreTokens()) {
            return new ParseResult.Fail(this.getTokenName() + " expects 2 PIPE separated values, found 1 in: " + value, context);
        }
        String factName = aTok.nextToken();
        if (aTok.hasMoreTokens()) {
            return new ParseResult.Fail(this.getTokenName() + " expects 3 PIPE separated values, found too many in: " + value, context);
        }
        if ("GLOBAL".equals(usableLocation)) {
            cl = CDOMObject.class;
        } else {
            cl = StringPClassUtil.getClassFor(usableLocation);
            if (cl == null) {
                throw new IllegalArgumentException("Invalid Data Definition Location (no class): " + usableLocation);
            }
        }
        def.setUsableLocation(cl);
        def.setFactName(factName);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, FactDefinition def) {
        Class cl = def.getUsableLocation();
        String name = def.getFactName();
        if (cl == null) {
            if (name == null) {
                return null;
            }
            context.addWriteMessage("Found FactDefinition with location but no name");
            return null;
        }
        if (name == null) {
            context.addWriteMessage("Found FactDefinition with name but no location");
            return null;
        }
        return new String[]{StringPClassUtil.getStringFor(cl) + "|" + name};
    }

    @Override
    public Class<FactDefinition> getTokenClass() {
        return FactDefinition.class;
    }
}

