/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import java.util.ArrayList;
import java.util.List;

public class TableColumnInformation {
    private List<ColStruct> columns = null;

    public TableColumnInformation(int initialCapacity) {
        this.columns = new ArrayList<ColStruct>(initialCapacity);
    }

    public void addColumn(int columnIndex, String columnKey, Class<?> columnClass, Object defaultValue, boolean editable, String label) {
        this.columns.add(columnIndex, new ColStruct(columnKey, columnClass, defaultValue, editable, label));
    }

    public void addColumn(String columnKey, Class<?> columnClass, Object defaultValue, boolean editable, String label) {
        this.columns.add(new ColStruct(columnKey, columnClass, defaultValue, editable, label));
    }

    public int columnFromKey(String key) {
        int returnValue = -1;
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get((int)i).columnKey.equals(key)) continue;
            returnValue = i;
            break;
        }
        return returnValue;
    }

    public Class<?> getClass(int column) {
        return this.columns.get((int)column).columnClass;
    }

    public Class<?> getClass(String key) {
        return this.getClass(this.columnFromKey(key));
    }

    public int getColumCount() {
        return this.columns.size();
    }

    public Object getDefaultValue(int column) {
        return this.columns.get((int)column).defaultValue;
    }

    public Object getDefaultValue(String key) {
        return this.getDefaultValue(this.columnFromKey(key));
    }

    public String getKey(int column) {
        return this.columns.get((int)column).columnKey;
    }

    public String getLabel(int column) {
        return this.columns.get((int)column).label;
    }

    public String getLabel(String key) {
        return this.getLabel(this.columnFromKey(key));
    }

    public boolean isColumnEditable(int column) {
        return this.columns.get((int)column).editable;
    }

    public boolean isColumnEditable(String key) {
        return this.isColumnEditable(this.columnFromKey(key));
    }

    public void removeAll() {
        this.columns.clear();
    }

    public void removeColumn(int columnIndex) {
        this.columns.remove(columnIndex);
    }

    public void removeColumn(String key) {
        this.columns.remove(this.columnFromKey(key));
    }

    public void setClass(int column, Class<?> pClass) {
        this.columns.get((int)column).columnClass = pClass;
    }

    public void setClass(String key, Class<?> pClass) {
        this.setClass(this.columnFromKey(key), pClass);
    }

    public void setColumnEditable(int column, boolean editable) {
        this.columns.get((int)column).editable = editable;
    }

    public void setColumnEditable(String key, boolean editable) {
        this.setColumnEditable(this.columnFromKey(key), editable);
    }

    public void setDefaultValue(int column, Object value) {
        this.columns.get((int)column).defaultValue = value;
    }

    public void setDefaultValue(String key, Object value) {
        this.setDefaultValue(this.columnFromKey(key), value);
    }

    public void setKey(int column, String key) {
        this.columns.get((int)column).columnKey = key;
    }

    public void setKey(String key, String keyValue) {
        this.setKey(this.columnFromKey(key), keyValue);
    }

    public void setLabel(int column, String label) {
        this.columns.get((int)column).label = label;
    }

    public void setLabel(String key, String label) {
        this.setLabel(this.columnFromKey(key), label);
    }

    private static class ColStruct {
        public Class<?> columnClass = null;
        public String columnKey = null;
        public Object defaultValue = null;
        public boolean editable = false;
        public String label = null;

        public ColStruct() {
        }

        public ColStruct(String pcolumnKey, Class<?> pcolumnClass, Object pdefaultValue, boolean peditable, String plabel) {
            this.columnKey = pcolumnKey;
            this.columnClass = pcolumnClass;
            this.defaultValue = pdefaultValue;
            this.editable = peditable;
            this.label = plabel;
        }
    }
}

