/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.facade.core.AbilityCategoryFacade;
import pcgen.facade.core.AbilityFacade;
import pcgen.facade.core.AlignmentFacade;
import pcgen.facade.core.BodyStructureFacade;
import pcgen.facade.core.CampaignFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.facade.core.DataSetFacade;
import pcgen.facade.core.DeityFacade;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.GameModeFacade;
import pcgen.facade.core.GearBuySellFacade;
import pcgen.facade.core.KitFacade;
import pcgen.facade.core.RaceFacade;
import pcgen.facade.core.SizeAdjustmentFacade;
import pcgen.facade.core.SkillFacade;
import pcgen.facade.core.StatFacade;
import pcgen.facade.core.TemplateFacade;
import pcgen.facade.core.generator.StatGenerationFacade;
import pcgen.facade.util.AbstractMapFacade;
import pcgen.facade.util.DelegatingListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.MapFacade;
import pcgen.facade.util.event.MapEvent;
import pcgen.facade.util.event.MapListener;

public class DelegatingDataSet
implements DataSetFacade {
    private final DelegatingListFacade<RaceFacade> races;
    private final DelegatingListFacade<ClassFacade> classes;
    private final DelegatingListFacade<DeityFacade> deities;
    private final DelegatingListFacade<SkillFacade> skills;
    private final DelegatingListFacade<TemplateFacade> templates;
    private final DelegatingListFacade<AlignmentFacade> alignments;
    private final DelegatingListFacade<KitFacade> kits;
    private final DelegatingListFacade<StatFacade> stats;
    private final DelegatingAbilitiesMap abilities;
    private final DelegatingListFacade<CampaignFacade> campaigns;
    private final DelegatingListFacade<BodyStructureFacade> bodyStructures;
    private final DelegatingListFacade<EquipmentFacade> equipment;
    private final DelegatingListFacade<String> xpTableNames;
    private final DelegatingListFacade<GearBuySellFacade> gearBuySellSchemes;
    private final DelegatingListFacade<String> characterTypes;
    private final DelegatingListFacade<SizeAdjustmentFacade> sizes;
    private final DataSetFacade delegate;

    public DelegatingDataSet(DataSetFacade delegate) {
        this.delegate = delegate;
        this.abilities = new DelegatingAbilitiesMap(delegate.getAbilities());
        this.races = new DelegatingListFacade<RaceFacade>(delegate.getRaces());
        this.classes = new DelegatingListFacade<ClassFacade>(delegate.getClasses());
        this.deities = new DelegatingListFacade<DeityFacade>(delegate.getDeities());
        this.skills = new DelegatingListFacade<SkillFacade>(delegate.getSkills());
        this.templates = new DelegatingListFacade<TemplateFacade>(delegate.getTemplates());
        this.alignments = new DelegatingListFacade<AlignmentFacade>(delegate.getAlignments());
        this.kits = new DelegatingListFacade<KitFacade>(delegate.getKits());
        this.stats = new DelegatingListFacade<StatFacade>(delegate.getStats());
        this.campaigns = new DelegatingListFacade<CampaignFacade>(delegate.getCampaigns());
        this.bodyStructures = new DelegatingListFacade<BodyStructureFacade>(delegate.getEquipmentLocations());
        this.equipment = new DelegatingListFacade<EquipmentFacade>(delegate.getEquipment());
        this.xpTableNames = new DelegatingListFacade<String>(delegate.getXPTableNames());
        this.gearBuySellSchemes = new DelegatingListFacade<GearBuySellFacade>(delegate.getGearBuySellSchemes());
        this.characterTypes = new DelegatingListFacade<String>(delegate.getCharacterTypes());
        this.sizes = new DelegatingListFacade<SizeAdjustmentFacade>(delegate.getSizes());
    }

    public void detachDelegates() {
        this.abilities.detach();
        this.races.setDelegate(null);
        this.classes.setDelegate(null);
        this.deities.setDelegate(null);
        this.skills.setDelegate(null);
        this.templates.setDelegate(null);
        this.alignments.setDelegate(null);
        this.kits.setDelegate(null);
        this.stats.setDelegate(null);
        this.campaigns.setDelegate(null);
        this.bodyStructures.setDelegate(null);
        this.equipment.setDelegate(null);
        this.xpTableNames.setDelegate(null);
        this.gearBuySellSchemes.setDelegate(null);
        this.characterTypes.setDelegate(null);
        this.sizes.setDelegate(null);
    }

    @Override
    public MapFacade<AbilityCategoryFacade, ListFacade<AbilityFacade>> getAbilities() {
        return this.abilities;
    }

    @Override
    public List<AbilityFacade> getPrereqAbilities(AbilityFacade abilityFacade) {
        return this.delegate.getPrereqAbilities(abilityFacade);
    }

    @Override
    public ListFacade<SkillFacade> getSkills() {
        return this.skills;
    }

    @Override
    public ListFacade<RaceFacade> getRaces() {
        return this.races;
    }

    @Override
    public ListFacade<ClassFacade> getClasses() {
        return this.classes;
    }

    @Override
    public ListFacade<DeityFacade> getDeities() {
        return this.deities;
    }

    @Override
    public ListFacade<TemplateFacade> getTemplates() {
        return this.templates;
    }

    @Override
    public ListFacade<CampaignFacade> getCampaigns() {
        return this.campaigns;
    }

    @Override
    public GameModeFacade getGameMode() {
        return this.delegate.getGameMode();
    }

    @Override
    public ListFacade<AlignmentFacade> getAlignments() {
        return this.alignments;
    }

    @Override
    public ListFacade<StatFacade> getStats() {
        return this.stats;
    }

    @Override
    public ListFacade<StatGenerationFacade> getStatGenerators() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SkillFacade getSpeakLanguageSkill() {
        return this.delegate.getSpeakLanguageSkill();
    }

    @Override
    public ListFacade<EquipmentFacade> getEquipment() {
        return this.equipment;
    }

    @Override
    public void addEquipment(EquipmentFacade equip) {
        this.delegate.addEquipment(equip);
    }

    @Override
    public ListFacade<BodyStructureFacade> getEquipmentLocations() {
        return this.bodyStructures;
    }

    @Override
    public ListFacade<String> getXPTableNames() {
        return this.xpTableNames;
    }

    @Override
    public ListFacade<String> getCharacterTypes() {
        return this.characterTypes;
    }

    @Override
    public ListFacade<GearBuySellFacade> getGearBuySellSchemes() {
        return this.gearBuySellSchemes;
    }

    @Override
    public ListFacade<KitFacade> getKits() {
        return this.kits;
    }

    @Override
    public ListFacade<SizeAdjustmentFacade> getSizes() {
        return this.sizes;
    }

    @Override
    public void refreshEquipment() {
        this.delegate.refreshEquipment();
    }

    private class DelegatingAbilitiesMap
    extends AbstractMapFacade<AbilityCategoryFacade, ListFacade<AbilityFacade>>
    implements MapListener<AbilityCategoryFacade, ListFacade<AbilityFacade>> {
        private final Map<AbilityCategoryFacade, DelegatingListFacade<AbilityFacade>> abilitiesMap;
        private final MapFacade<AbilityCategoryFacade, ListFacade<AbilityFacade>> abilitiesDelegate;

        public DelegatingAbilitiesMap(MapFacade<AbilityCategoryFacade, ListFacade<AbilityFacade>> abilitiesDelegate) {
            this.abilitiesDelegate = abilitiesDelegate;
            this.abilitiesMap = new HashMap<AbilityCategoryFacade, DelegatingListFacade<AbilityFacade>>();
            this.populateMap();
            abilitiesDelegate.addMapListener(this);
        }

        public void detach() {
            this.abilitiesDelegate.removeMapListener(this);
            for (DelegatingListFacade<AbilityFacade> list : this.abilitiesMap.values()) {
                list.setDelegate(null);
            }
        }

        @Override
        public Set<AbilityCategoryFacade> getKeys() {
            return this.abilitiesDelegate.getKeys();
        }

        @Override
        public ListFacade<AbilityFacade> getValue(AbilityCategoryFacade key) {
            return this.abilitiesMap.get(key);
        }

        @Override
        public void keyAdded(MapEvent<AbilityCategoryFacade, ListFacade<AbilityFacade>> e) {
            AbilityCategoryFacade key = e.getKey();
            DelegatingListFacade<AbilityFacade> newValue = new DelegatingListFacade<AbilityFacade>(e.getNewValue());
            this.abilitiesMap.put(key, newValue);
            this.fireKeyAdded(this, key, newValue);
        }

        @Override
        public void keyRemoved(MapEvent<AbilityCategoryFacade, ListFacade<AbilityFacade>> e) {
            AbilityCategoryFacade key = e.getKey();
            DelegatingListFacade<AbilityFacade> oldValue = this.abilitiesMap.remove(key);
            this.fireKeyRemoved(this, key, oldValue);
            oldValue.setDelegate(null);
        }

        @Override
        public void keyModified(MapEvent<AbilityCategoryFacade, ListFacade<AbilityFacade>> e) {
            this.fireKeyModified(this, e.getKey(), this.abilitiesMap.get(e.getKey()), e);
        }

        @Override
        public void valueChanged(MapEvent<AbilityCategoryFacade, ListFacade<AbilityFacade>> e) {
            AbilityCategoryFacade key = e.getKey();
            DelegatingListFacade<AbilityFacade> oldValue = this.abilitiesMap.get(key);
            DelegatingListFacade<AbilityFacade> newValue = new DelegatingListFacade<AbilityFacade>(e.getNewValue());
            this.abilitiesMap.put(key, newValue);
            this.fireValueChanged(this, key, oldValue, newValue);
            oldValue.setDelegate(null);
        }

        @Override
        public void valueModified(MapEvent<AbilityCategoryFacade, ListFacade<AbilityFacade>> e) {
            this.fireValueModified(this, e.getKey(), this.abilitiesMap.get(e.getKey()), e);
        }

        private void populateMap() {
            for (AbilityCategoryFacade key : this.abilitiesDelegate.getKeys()) {
                DelegatingListFacade<AbilityFacade> value = new DelegatingListFacade<AbilityFacade>(this.abilitiesDelegate.getValue(key));
                this.abilitiesMap.put(key, value);
            }
        }

        @Override
        public void keysChanged(MapEvent<AbilityCategoryFacade, ListFacade<AbilityFacade>> e) {
            ArrayList<DelegatingListFacade<AbilityFacade>> deadLists = new ArrayList<DelegatingListFacade<AbilityFacade>>(this.abilitiesMap.values());
            this.abilitiesMap.clear();
            this.populateMap();
            for (DelegatingListFacade<AbilityFacade> delegatingListFacade : deadLists) {
                delegatingListFacade.setDelegate(null);
            }
        }
    }
}

