/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import pcgen.gui2.tools.Utility;
import pcgen.system.LanguageBundle;

public abstract class AbstractDialog
extends JDialog {
    private static final long serialVersionUID = -6457261103398090360L;
    protected static final int GAP = 12;
    private JButton okButton;

    public AbstractDialog(Frame f, String title, boolean modal) {
        super(f, title, modal);
        this.initialize();
    }

    private void initialize() {
        this.okButton = new JButton(LanguageBundle.getString(this.getOkKey()));
        this.okButton.setMnemonic(LanguageBundle.getMnemonic(this.getOkMnKey()));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractDialog.this.okButtonActionPerformed();
            }
        });
        JButton cancelButton = new JButton(LanguageBundle.getString(this.getCancelKey()));
        cancelButton.setMnemonic(LanguageBundle.getMnemonic(this.getCancelMnKey()));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractDialog.this.cancelButtonActionPerformed();
            }
        });
        JButton bApply = null;
        if (this.includeApplyButton()) {
            bApply = new JButton(LanguageBundle.getString("in_apply"));
            bApply.setMnemonic(LanguageBundle.getMnemonic("in_mn_apply"));
            bApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AbstractDialog.this.applyButtonActionPerformed();
                }
            });
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(UIManager.getBorder("OptionPane.border"));
        buttonPanel.setLayout(new FlowLayout(2));
        boolean sameSize = UIManager.getBoolean("OptionPane.sameSizeButtons");
        if (sameSize) {
            int max = Math.max(this.okButton.getPreferredSize().width, cancelButton.getPreferredSize().width);
            if (this.includeApplyButton()) {
                max = Math.max(max, bApply.getPreferredSize().width);
                bApply.setPreferredSize(new Dimension(max, bApply.getPreferredSize().height));
            }
            this.okButton.setPreferredSize(new Dimension(max, this.okButton.getPreferredSize().height));
            cancelButton.setPreferredSize(new Dimension(max, cancelButton.getPreferredSize().height));
        }
        boolean isYesLast = UIManager.getBoolean("OptionPane.isYesLast");
        int padding = UIManager.getInt("OptionPane.buttonPadding");
        if (isYesLast) {
            if (this.includeApplyButton()) {
                buttonPanel.add(bApply);
                buttonPanel.add(Box.createHorizontalStrut(padding));
            }
            buttonPanel.add(cancelButton);
            buttonPanel.add(Box.createHorizontalStrut(padding));
            buttonPanel.add(this.okButton);
        } else {
            buttonPanel.add(this.okButton);
            buttonPanel.add(Box.createHorizontalStrut(padding));
            if (this.includeApplyButton()) {
                buttonPanel.add(bApply);
                buttonPanel.add(Box.createHorizontalStrut(padding));
            }
            buttonPanel.add(cancelButton);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getCenter(), "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        if (this.shouldSetOkAsDefault()) {
            this.setOkAsDefault();
        }
        if (this.shouldInstallEsc()) {
            Utility.installEscapeCloseOperation(this);
        }
    }

    protected void setOkAsDefault() {
        this.getRootPane().setDefaultButton(this.okButton);
    }

    protected boolean shouldSetOkAsDefault() {
        return true;
    }

    protected boolean shouldInstallEsc() {
        return true;
    }

    protected String getCancelMnKey() {
        return "in_mn_cancel";
    }

    protected String getCancelKey() {
        return "in_cancel";
    }

    protected String getOkMnKey() {
        return "in_mn_ok";
    }

    protected String getOkKey() {
        return "in_ok";
    }

    protected abstract JComponent getCenter();

    protected boolean includeApplyButton() {
        return false;
    }

    public void okButtonActionPerformed() {
        this.applyButtonActionPerformed();
        this.close();
    }

    public void cancelButtonActionPerformed() {
        this.close();
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }

    protected abstract void applyButtonActionPerformed();
}

