/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import pcgen.base.formula.Formula;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.base.BonusContainer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Ability;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.ChooseActivation;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.BonusPair;
import pcgen.core.bonus.util.MissingObject;
import pcgen.core.display.BonusDisplay;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.util.Delta;
import pcgen.util.Logging;

public class BonusManager {
    private static final String VALUE_TOKEN_REPLACEMENT = "%LIST";
    private static final String LIST_TOKEN_REPLACEMENT = "LIST";
    private static final String VALUE_TOKEN_PATTERN = Pattern.quote("%LIST");
    private static final String VAR_TOKEN_REPLACEMENT = "%VAR";
    private static final String VAR_TOKEN_PATTERN = Pattern.quote("%VAR");
    private static final List<String> NO_ASSOC_LIST = Collections.singletonList("");
    private Map<String, String> activeBonusMap = new ConcurrentHashMap<String, String>();
    private Map<String, Double> cachedActiveBonusSumsMap = new ConcurrentHashMap<String, Double>();
    private Map<BonusObj, Object> activeBonusBySource = new IdentityHashMap<BonusObj, Object>();
    private Map<BonusObj, TempBonusInfo> tempBonusBySource = new IdentityHashMap<BonusObj, TempBonusInfo>();
    private Set<String> tempBonusFilters = new TreeSet<String>();
    private final PlayerCharacter pc;
    private Map<String, String> checkpointMap;

    public BonusManager(PlayerCharacter p) {
        this.pc = p;
    }

    private double sumActiveBonusMap(String fullyQualifiedBonusType) {
        double bonus = 0.0;
        if (fullyQualifiedBonusType == null) {
            Logging.errorPrint("Unable to sum BONUS when request is null");
            return bonus;
        }
        if (this.cachedActiveBonusSumsMap.containsKey(fullyQualifiedBonusType = fullyQualifiedBonusType.toUpperCase())) {
            return this.cachedActiveBonusSumsMap.get(fullyQualifiedBonusType);
        }
        ArrayList<String> aList = new ArrayList<String>();
        for (String fullyQualifedCurrentBonus : this.activeBonusMap.keySet()) {
            if (aList.contains(fullyQualifedCurrentBonus)) continue;
            if (fullyQualifedCurrentBonus == null) {
                Logging.errorPrint("null BONUS: loaded into activeBonusMap. " + fullyQualifiedBonusType + " was requested");
                continue;
            }
            String currentTypedBonusNameInfo = fullyQualifedCurrentBonus;
            if (currentTypedBonusNameInfo.endsWith(".STACK")) {
                currentTypedBonusNameInfo = currentTypedBonusNameInfo.substring(0, currentTypedBonusNameInfo.length() - 6);
            } else if (currentTypedBonusNameInfo.endsWith(".REPLACE")) {
                currentTypedBonusNameInfo = currentTypedBonusNameInfo.substring(0, currentTypedBonusNameInfo.length() - 8);
            }
            if (currentTypedBonusNameInfo == null) {
                Logging.errorPrint("Unable to process BONUS: " + fullyQualifedCurrentBonus + " when " + fullyQualifiedBonusType + " was requested");
                continue;
            }
            if (currentTypedBonusNameInfo.length() > fullyQualifiedBonusType.length() && !currentTypedBonusNameInfo.startsWith(fullyQualifiedBonusType + ":") || !currentTypedBonusNameInfo.startsWith(fullyQualifiedBonusType)) continue;
            aList.add(currentTypedBonusNameInfo);
            aList.add(currentTypedBonusNameInfo + ".STACK");
            aList.add(currentTypedBonusNameInfo + ".REPLACE");
            double aBonus = this.getActiveBonusForMapKey(currentTypedBonusNameInfo, Double.NaN);
            double replaceBonus = this.getActiveBonusForMapKey(currentTypedBonusNameInfo + ".REPLACE", Double.NaN);
            double stackBonus = this.getActiveBonusForMapKey(currentTypedBonusNameInfo + ".STACK", 0.0);
            if (Double.isNaN(aBonus)) {
                if (!Double.isNaN(replaceBonus)) {
                    bonus += replaceBonus;
                }
            } else {
                bonus = Double.isNaN(replaceBonus) ? (bonus += aBonus) : (bonus += Math.max(aBonus, replaceBonus));
            }
            bonus += stackBonus;
        }
        this.cachedActiveBonusSumsMap.put(fullyQualifiedBonusType, bonus);
        return bonus;
    }

    private double getActiveBonusForMapKey(String fullyQualifiedBonusType, double defaultValue) {
        String regVal = this.activeBonusMap.get(fullyQualifiedBonusType = fullyQualifiedBonusType.toUpperCase());
        if (regVal != null) {
            return Double.parseDouble(regVal);
        }
        return defaultValue;
    }

    public double getBonusDueToType(String bonusName, String bonusInfo, String bonusType) {
        String typeString = bonusName + "." + bonusInfo + ":" + bonusType;
        return this.sumActiveBonusMap(typeString);
    }

    public double getTotalBonusTo(String bonusName, String bonusInfo) {
        String prefix = bonusName + '.' + bonusInfo;
        return this.sumActiveBonusMap(prefix);
    }

    public String getSpellBonusType(String bonusName, String bonusInfo) {
        String prefix = bonusName + '.' + bonusInfo;
        prefix = prefix.toUpperCase();
        Iterator<String> i$ = this.activeBonusMap.keySet().iterator();
        while (i$.hasNext()) {
            String fullyQualifedBonusType;
            String typedBonusNameInfo = fullyQualifedBonusType = i$.next();
            if (fullyQualifedBonusType.endsWith(".STACK")) {
                typedBonusNameInfo = fullyQualifedBonusType.substring(0, fullyQualifedBonusType.length() - 6);
            } else if (fullyQualifedBonusType.endsWith(".REPLACE")) {
                typedBonusNameInfo = fullyQualifedBonusType.substring(0, fullyQualifedBonusType.length() - 8);
            }
            if (typedBonusNameInfo.length() > prefix.length() && !typedBonusNameInfo.startsWith(prefix + ":") || !typedBonusNameInfo.startsWith(prefix)) continue;
            int typeIndex = typedBonusNameInfo.indexOf(":");
            if (typeIndex > 0) {
                return fullyQualifedBonusType.substring(typeIndex + 1);
            }
            return "";
        }
        return "";
    }

    void buildActiveBonusMap() {
        this.activeBonusMap = new ConcurrentHashMap<String, String>();
        this.cachedActiveBonusSumsMap = new ConcurrentHashMap<String, Double>();
        ConcurrentHashMap<String, String> nonStackMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> stackMap = new ConcurrentHashMap<String, String>();
        WrappedMapSet processedBonuses = new WrappedMapSet(IdentityHashMap.class);
        ArrayList<BonusObj> bonusListCopy = new ArrayList<BonusObj>();
        bonusListCopy.addAll(this.getActiveBonusList());
        for (BonusObj bonus : bonusListCopy) {
            if (!bonus.isValueStatic()) continue;
            Object source = this.getSourceObject(bonus);
            if (source == null) {
                if (!Logging.isDebugMode()) continue;
                Logging.debugPrint("BONUS: " + bonus + " ignored due to no creator");
                continue;
            }
            processedBonuses.add(bonus);
            for (BonusPair bp : this.getStringListFromBonus(bonus)) {
                double iBonus = bp.resolve(this.pc).doubleValue();
                this.setActiveBonusStack(iBonus, bp.fullyQualifiedBonusType, nonStackMap, stackMap);
                this.totalBonusesForType(nonStackMap, stackMap, bp.fullyQualifiedBonusType, this.activeBonusMap);
                if (!Logging.isDebugMode()) continue;
                String id = source instanceof CDOMObject ? ((CDOMObject)source).getDisplayName() : source.toString();
                Logging.debugPrint("BONUS: " + id + " : " + iBonus + " : " + bp.fullyQualifiedBonusType);
            }
        }
        bonusListCopy = new ArrayList();
        bonusListCopy.addAll(this.getActiveBonusList());
        for (BonusObj bonus : this.getActiveBonusList()) {
            CDOMObject anObj;
            if (processedBonuses.contains(bonus) || (anObj = (CDOMObject)this.getSourceObject(bonus)) == null) continue;
            try {
                this.processBonus(bonus, (Set<BonusObj>)new WrappedMapSet(IdentityHashMap.class), (Set<BonusObj>)processedBonuses, nonStackMap, stackMap);
            }
            catch (Exception e) {
                Logging.errorPrint(e.getLocalizedMessage(), e);
            }
        }
    }

    private void totalBonusesForType(Map<String, String> nonStackMap, Map<String, String> stackMap, String fullyQualifiedBonusType, Map<String, String> targetMap) {
        String nonStackString;
        if (fullyQualifiedBonusType != null) {
            fullyQualifiedBonusType = fullyQualifiedBonusType.toUpperCase();
        }
        Float nonStackVal = Float.valueOf((nonStackString = nonStackMap.get(fullyQualifiedBonusType)) == null ? 0.0f : Float.valueOf(nonStackString).floatValue());
        String stackString = stackMap.get(fullyQualifiedBonusType);
        Float stackVal = Float.valueOf(stackString == null ? 0.0f : Float.valueOf(stackString).floatValue());
        Float FullValue = Float.valueOf(nonStackVal.floatValue() + stackVal.floatValue());
        this.putActiveBonusMap(fullyQualifiedBonusType, String.valueOf(FullValue), targetMap);
    }

    public Collection<BonusObj> getActiveBonusList() {
        return this.activeBonusBySource.keySet();
    }

    public void setActiveBonusList() {
        this.activeBonusBySource = this.getAllActiveBonuses();
    }

    public String listBonusesFor(String bonusName, String bonusInfo) {
        String prefix = bonusName + '.' + bonusInfo;
        StringBuilder buf = new StringBuilder();
        ArrayList<String> aList = new ArrayList<String>();
        TreeSet<String> keys = new TreeSet<String>();
        for (String fullyQualifiedBonusType : this.activeBonusMap.keySet()) {
            if (!fullyQualifiedBonusType.startsWith(prefix)) continue;
            keys.add(fullyQualifiedBonusType);
        }
        for (String fullyQualifiedBonusType : keys) {
            int b;
            if (fullyQualifiedBonusType.endsWith(".REPLACE")) {
                aList.add(fullyQualifiedBonusType);
                continue;
            }
            String reason = "";
            if (fullyQualifiedBonusType.length() > prefix.length()) {
                reason = fullyQualifiedBonusType.substring(prefix.length() + 1);
            }
            if ((b = (int)this.getActiveBonusForMapKey(fullyQualifiedBonusType, 0.0)) == 0) continue;
            if (!"NULL".equals(reason) && reason.length() > 0) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(reason).append(' ');
            }
            buf.append(Delta.toString(b));
        }
        for (String fullyQualifiedBonusType_Replace : aList) {
            String reason;
            if (fullyQualifiedBonusType_Replace.length() <= 7) continue;
            String aKey = fullyQualifiedBonusType_Replace.substring(0, fullyQualifiedBonusType_Replace.length() - 8);
            double replaceBonus = this.getActiveBonusForMapKey(fullyQualifiedBonusType_Replace, 0.0);
            double aBonus = this.getActiveBonusForMapKey(aKey, 0.0);
            int b = (int)Math.max(aBonus += this.getActiveBonusForMapKey(aKey + ".STACK", 0.0), replaceBonus);
            if (b == 0) continue;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            if (!"NULL".equals(reason = aKey.substring(prefix.length() + 1))) {
                buf.append(reason).append(' ');
            }
            buf.append(Delta.toString(b));
        }
        return buf.toString();
    }

    private void processBonus(BonusObj aBonus, Set<BonusObj> prevProcessed, Set<BonusObj> processedBonuses, Map<String, String> nonStackMap, Map<String, String> stackMap) {
        if (prevProcessed.contains(aBonus)) {
            if (Logging.isDebugMode()) {
                Logging.log(Logging.DEBUG, "Ignoring bonus loop for " + aBonus + " as it was already processed. Bonuses already processed: " + prevProcessed);
                Logging.log(Logging.DEBUG, " Depend map is " + aBonus.listDependsMap());
            }
            return;
        }
        prevProcessed.add(aBonus);
        ArrayList<BonusObj> aList = new ArrayList<BonusObj>();
        for (BonusObj newBonus : this.getActiveBonusList()) {
            if (processedBonuses.contains(newBonus) || !aBonus.getDependsOn(newBonus.getUnparsedBonusInfoList()) && !aBonus.getDependsOnBonusName(newBonus.getBonusName())) continue;
            aList.add(newBonus);
        }
        for (BonusObj newBonus : aList) {
            this.processBonus(newBonus, prevProcessed, processedBonuses, nonStackMap, stackMap);
        }
        if (processedBonuses.contains(aBonus)) {
            return;
        }
        processedBonuses.add(aBonus);
        CDOMObject anObj = (CDOMObject)this.getSourceObject(aBonus);
        if (anObj == null) {
            prevProcessed.remove(aBonus);
            return;
        }
        for (BonusPair bp : this.getStringListFromBonus(aBonus)) {
            double iBonus = bp.resolve(this.pc).doubleValue();
            this.setActiveBonusStack(iBonus, bp.fullyQualifiedBonusType, nonStackMap, stackMap);
            this.totalBonusesForType(nonStackMap, stackMap, bp.fullyQualifiedBonusType, this.activeBonusMap);
        }
        prevProcessed.remove(aBonus);
    }

    private void setActiveBonusStack(double bonus, String fullyQualifiedBonusType, Map<String, String> nonStackbonusMap, Map<String, String> stackingBonusMap) {
        String aVal;
        if (fullyQualifiedBonusType != null) {
            if (!((fullyQualifiedBonusType = fullyQualifiedBonusType.toUpperCase()).startsWith("ITEMWEIGHT") || fullyQualifiedBonusType.startsWith("ITEMCOST") || fullyQualifiedBonusType.startsWith("ACVALUE") || fullyQualifiedBonusType.startsWith("ITEMCAPACITY") || fullyQualifiedBonusType.startsWith("LOADMULT") || fullyQualifiedBonusType.startsWith("FEAT") || fullyQualifiedBonusType.indexOf("DAMAGEMULT") >= 0)) {
                bonus = (int)bonus;
            }
        } else {
            return;
        }
        int index = -1;
        StringTokenizer aTok = new StringTokenizer(fullyQualifiedBonusType, ":");
        if (aTok.countTokens() == 2) {
            aTok.nextToken();
            String aString = aTok.nextToken();
            if (aString != null) {
                index = SettingsHandler.getGame().getUnmodifiableBonusStackList().indexOf(aString);
            }
        } else {
            index = 1;
        }
        if (fullyQualifiedBonusType.endsWith(".STACK") || fullyQualifiedBonusType.endsWith(".REPLACE")) {
            index = 1;
        }
        if (bonus < 0.0) {
            index = 1;
        }
        if (index == -1) {
            aVal = nonStackbonusMap.get(fullyQualifiedBonusType);
            if (aVal == null) {
                this.putActiveBonusMap(fullyQualifiedBonusType, String.valueOf(bonus), nonStackbonusMap);
            } else {
                float existingBonus = Float.parseFloat(aVal);
                this.putActiveBonusMap(fullyQualifiedBonusType, String.valueOf(Math.max(bonus, (double)existingBonus)), nonStackbonusMap);
            }
        } else {
            aVal = stackingBonusMap.get(fullyQualifiedBonusType);
            if (aVal == null) {
                this.putActiveBonusMap(fullyQualifiedBonusType, String.valueOf(bonus), stackingBonusMap);
            } else {
                this.putActiveBonusMap(fullyQualifiedBonusType, String.valueOf(bonus + (double)Float.parseFloat(aVal)), stackingBonusMap);
            }
        }
    }

    private void putActiveBonusMap(String fullyQualifiedBonusType, String bonusValue, Map<String, String> bonusMap) {
        if (fullyQualifiedBonusType.equalsIgnoreCase("SKILL.LIST")) {
            this.pc.setDisplayUpdate(true);
            return;
        }
        bonusMap.put(fullyQualifiedBonusType, bonusValue);
    }

    public int getPartialStatBonusFor(PCStat stat, boolean useTemp, boolean useEquip) {
        String statAbbr = stat.getKeyName();
        String prefix = "STAT." + statAbbr;
        HashMap<String, String> bonusMap = new HashMap<String, String>();
        ConcurrentHashMap<String, String> nonStackMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> stackMap = new ConcurrentHashMap<String, String>();
        for (BonusObj bonus : this.getActiveBonusList()) {
            List<String> types;
            if (!this.pc.isApplied(bonus) || !bonus.getBonusName().equals("STAT")) continue;
            boolean found = false;
            Object co = this.getSourceObject(bonus);
            block1: for (Object element : bonus.getBonusInfoList()) {
                String name;
                if (element instanceof PCStat && ((PCStat)element).equals(stat)) {
                    found = true;
                    break;
                }
                if (!(element instanceof MissingObject) || !VALUE_TOKEN_REPLACEMENT.equals(name = ((MissingObject)element).getObjectName()) && !LIST_TOKEN_REPLACEMENT.equals(name) || !(co instanceof CDOMObject)) continue;
                CDOMObject creator = (CDOMObject)co;
                for (String assoc : this.pc.getConsolidatedAssociationList(creator)) {
                    if (!assoc.contains(statAbbr)) continue;
                    found = true;
                    continue block1;
                }
            }
            if (!found) continue;
            boolean addIt = false;
            addIt = co instanceof Equipment || co instanceof EquipmentModifier ? useEquip : (co instanceof Ability ? ((types = ((Ability)co).getTypes()).contains("Equipment") ? useEquip : true) : (this.tempBonusBySource.containsKey(bonus) ? useTemp : true));
            if (!addIt) continue;
            for (BonusPair bp : this.getStringListFromBonus(bonus)) {
                if (!bp.fullyQualifiedBonusType.startsWith(prefix)) continue;
                this.setActiveBonusStack(bp.resolve(this.pc).doubleValue(), bp.fullyQualifiedBonusType, nonStackMap, stackMap);
                this.totalBonusesForType(nonStackMap, stackMap, bp.fullyQualifiedBonusType, bonusMap);
            }
        }
        int total = 0;
        for (String bKey : bonusMap.keySet()) {
            total = (int)((float)total + Float.parseFloat((String)bonusMap.get(bKey)));
        }
        return total;
    }

    public BonusManager buildDeepClone(PlayerCharacter apc) {
        BonusManager clone = new BonusManager(apc);
        clone.activeBonusBySource.putAll(this.activeBonusBySource);
        clone.tempBonusBySource.putAll(this.tempBonusBySource);
        clone.activeBonusMap.putAll(this.activeBonusMap);
        clone.tempBonusFilters.addAll(this.tempBonusFilters);
        return clone;
    }

    public void checkpointBonusMap() {
        this.checkpointMap = this.activeBonusMap;
    }

    public boolean compareToCheckpoint() {
        return this.checkpointMap != null && this.checkpointMap.equals(this.activeBonusMap);
    }

    public Map<BonusObj, TempBonusInfo> getTempBonusMap() {
        return new IdentityHashMap<BonusObj, TempBonusInfo>(this.tempBonusBySource);
    }

    public Map<String, String> getBonuses(String bonusName, String bonusInfo) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String prefix = bonusName + "." + bonusInfo + ".";
        for (Map.Entry<String, String> entry : this.activeBonusMap.entrySet()) {
            String fullyQualifiedBonusType = entry.getKey();
            if (!fullyQualifiedBonusType.startsWith(prefix)) continue;
            returnMap.put(fullyQualifiedBonusType, entry.getValue());
        }
        return returnMap;
    }

    public TempBonusInfo addTempBonus(BonusObj bonus, Object source, Object target) {
        TempBonusInfo tempBonusInfo = new TempBonusInfo(source, target);
        this.tempBonusBySource.put(bonus, tempBonusInfo);
        return tempBonusInfo;
    }

    public void removeTempBonus(BonusObj bonus) {
        this.tempBonusBySource.remove(bonus);
    }

    public Set<String> getTempBonusDisplayNames() {
        TreeSet<String> ret = new TreeSet<String>();
        for (Map.Entry<BonusObj, TempBonusInfo> me : this.tempBonusBySource.entrySet()) {
            ret.add(BonusDisplay.getBonusDisplayName(me.getValue()));
        }
        return ret;
    }

    public List<BonusObj> getTempBonusList(String aCreator, String aTarget) {
        ArrayList<BonusObj> aList = new ArrayList<BonusObj>();
        for (Map.Entry<BonusObj, TempBonusInfo> me : this.tempBonusBySource.entrySet()) {
            BonusObj bonus = me.getKey();
            Object aTO = me.getValue().target;
            Object aCO = me.getValue().source;
            String targetName = "";
            String creatorName = "";
            if (aCO instanceof CDOMObject) {
                creatorName = ((CDOMObject)aCO).getKeyName();
            }
            if (aTO instanceof PlayerCharacter) {
                targetName = ((PlayerCharacter)aTO).getName();
            } else if (aTO instanceof CDOMObject) {
                targetName = ((CDOMObject)aTO).getKeyName();
            }
            if (!creatorName.equals(aCreator) || !targetName.equals(aTarget)) continue;
            aList.add(bonus);
        }
        return aList;
    }

    public List<String> getNamedTempBonusList() {
        ArrayList<String> aList = new ArrayList<String>();
        Map<BonusObj, TempBonusInfo> filteredTempBonusList = this.getFilteredTempBonusList();
        for (Map.Entry<BonusObj, TempBonusInfo> me : filteredTempBonusList.entrySet()) {
            String aName;
            CDOMObject aCreator;
            BonusObj aBonus = me.getKey();
            if (aBonus == null || !this.pc.isApplied(aBonus) || (aCreator = (CDOMObject)me.getValue().source) == null || aList.contains(aName = aCreator.getKeyName())) continue;
            aList.add(aName);
        }
        return aList;
    }

    public List<String> getNamedTempBonusDescList() {
        ArrayList<String> aList = new ArrayList<String>();
        Map<BonusObj, TempBonusInfo> filteredTempBonusList = this.getFilteredTempBonusList();
        for (Map.Entry<BonusObj, TempBonusInfo> me : filteredTempBonusList.entrySet()) {
            String aDesc;
            CDOMObject aCreator;
            BonusObj aBonus = me.getKey();
            if (aBonus == null || !this.pc.isApplied(aBonus) || (aCreator = (CDOMObject)me.getValue().source) == null || aList.contains(aDesc = aCreator.getSafe(StringKey.DESCRIPTION))) continue;
            aList.add(aDesc);
        }
        return aList;
    }

    public Map<BonusObj, TempBonusInfo> getFilteredTempBonusList() {
        IdentityHashMap<BonusObj, TempBonusInfo> ret = new IdentityHashMap<BonusObj, TempBonusInfo>();
        for (Map.Entry<BonusObj, TempBonusInfo> me : this.tempBonusBySource.entrySet()) {
            BonusObj bonus = me.getKey();
            TempBonusInfo ti = me.getValue();
            if (this.tempBonusFilters.contains(BonusDisplay.getBonusDisplayName(ti))) continue;
            ret.put(bonus, ti);
        }
        return ret;
    }

    public Set<String> getTempBonusFilters() {
        return this.tempBonusFilters;
    }

    public void addTempBonusFilter(String bonusStr) {
        this.tempBonusFilters.add(bonusStr);
    }

    public void removeTempBonusFilter(String bonusStr) {
        this.tempBonusFilters.remove(bonusStr);
    }

    public Map<BonusObj, Object> getTempBonuses() {
        IdentityHashMap<BonusObj, Object> map = new IdentityHashMap<BonusObj, Object>();
        for (Map.Entry<BonusObj, TempBonusInfo> me : this.getFilteredTempBonusList().entrySet()) {
            CDOMObject cdomsource;
            BonusObj bonus = me.getKey();
            this.pc.setApplied(bonus, false);
            Object source = me.getValue().source;
            CDOMObject cDOMObject = cdomsource = source instanceof CDOMObject ? (CDOMObject)source : null;
            if (bonus.qualifies(this.pc, cdomsource)) {
                this.pc.setApplied(bonus, true);
            }
            if (!this.pc.isApplied(bonus)) continue;
            map.put(bonus, source);
        }
        return map;
    }

    public Map<BonusObj, TempBonusInfo> getTempBonusMap(String aCreator, String aTarget) {
        IdentityHashMap<BonusObj, TempBonusInfo> aMap = new IdentityHashMap<BonusObj, TempBonusInfo>();
        for (Map.Entry<BonusObj, TempBonusInfo> me : this.tempBonusBySource.entrySet()) {
            BonusObj bonus = me.getKey();
            TempBonusInfo tbi = me.getValue();
            Object aTO = tbi.target;
            Object aCO = tbi.source;
            String targetName = "";
            String creatorName = "";
            if (aCO instanceof CDOMObject) {
                creatorName = ((CDOMObject)aCO).getKeyName();
            }
            if (aTO instanceof PlayerCharacter) {
                targetName = ((PlayerCharacter)aTO).getName();
            } else if (aTO instanceof CDOMObject) {
                targetName = ((CDOMObject)aTO).getKeyName();
            }
            if (!creatorName.equals(aCreator) || !targetName.equals(aTarget)) continue;
            aMap.put(bonus, tbi);
        }
        return aMap;
    }

    public String getBonusContext(BonusObj bo, boolean shortForm) {
        String type;
        StringBuilder sb = new StringBuilder(50);
        boolean bEmpty = true;
        sb.append('[');
        if (bo.hasPrerequisites()) {
            for (Prerequisite p : bo.getPrerequisiteList()) {
                if (!bEmpty) {
                    sb.append(',');
                }
                sb.append(p.getDescription(shortForm));
                bEmpty = false;
            }
        }
        if ((type = bo.getTypeString()).length() != 0) {
            if (!shortForm) {
                if (!bEmpty) {
                    sb.append('|');
                }
                sb.append("TYPE=");
                bEmpty = false;
            }
            if (!shortForm || sb.charAt(sb.length() - 1) == '[') {
                sb.append(type);
                bEmpty = false;
            }
        }
        if (!bEmpty) {
            sb.append('|');
        }
        sb.append(this.getSourceString(bo));
        sb.append(']');
        return sb.toString();
    }

    private String getSourceString(BonusObj bo) {
        Object source = this.getSourceObject(bo);
        if (source == null) {
            return "NONE";
        }
        if (source instanceof PlayerCharacter) {
            return ((PlayerCharacter)source).getName();
        }
        return source.toString();
    }

    private Object getSourceObject(BonusObj bo) {
        TempBonusInfo tbi;
        Object source = this.activeBonusBySource.get(bo);
        if (source == null && (tbi = this.tempBonusBySource.get(bo)) != null) {
            source = tbi.source;
        }
        return source;
    }

    public List<BonusPair> getStringListFromBonus(BonusObj bo) {
        List<String> associatedList;
        Object creatorObj = this.getSourceObject(bo);
        CDOMObject anObj = null;
        if (creatorObj instanceof CDOMObject) {
            anObj = (CDOMObject)creatorObj;
            associatedList = this.pc.getConsolidatedAssociationList(anObj);
            if (associatedList == null || associatedList.isEmpty()) {
                associatedList = NO_ASSOC_LIST;
            }
        } else {
            associatedList = NO_ASSOC_LIST;
        }
        ArrayList<BonusPair> bonusList = new ArrayList<BonusPair>();
        String bonusName = bo.getBonusName();
        String[] bonusInfoArray = bo.getBonusInfo().split(",");
        String bonusType = bo.getTypeString();
        for (String assoc : associatedList) {
            Formula newFormula;
            String replacedName = bonusName.indexOf(VALUE_TOKEN_REPLACEMENT) >= 0 ? bonusName.replaceAll(VALUE_TOKEN_PATTERN, assoc) : bonusName;
            ArrayList<String> replacedInfoList = new ArrayList<String>(4);
            for (String bonusInfo : bonusInfoArray) {
                if (bonusInfo.indexOf(VALUE_TOKEN_REPLACEMENT) >= 0) {
                    replacedInfoList.add(bonusInfo.replaceAll(VALUE_TOKEN_PATTERN, assoc));
                    continue;
                }
                if (bonusInfo.indexOf(VAR_TOKEN_REPLACEMENT) >= 0) {
                    replacedInfoList.add(bonusName.replaceAll(VAR_TOKEN_PATTERN, assoc));
                    continue;
                }
                if (bonusInfo.equals(LIST_TOKEN_REPLACEMENT)) {
                    replacedInfoList.add(assoc);
                    continue;
                }
                replacedInfoList.add(bonusInfo);
            }
            if (bo.isValueStatic()) {
                newFormula = bo.getFormula();
            } else {
                String value = bo.getValue();
                int listIndex = value.indexOf(VALUE_TOKEN_REPLACEMENT);
                String thisValue = value;
                if (listIndex >= 0) {
                    thisValue = value.replaceAll(VALUE_TOKEN_PATTERN, assoc);
                }
                if (thisValue.length() == 0) {
                    thisValue = "0";
                }
                newFormula = FormulaFactory.getFormulaFor(thisValue);
            }
            for (String replacedInfo : replacedInfoList) {
                StringBuilder sb = new StringBuilder(100);
                sb.append(replacedName).append('.').append(replacedInfo);
                if (bo.hasTypeString()) {
                    sb.append(':').append(bonusType);
                }
                bonusList.add(new BonusPair(sb.toString(), newFormula, creatorObj));
            }
        }
        return bonusList;
    }

    public double calcBonusesWithCost(List<BonusObj> list) {
        double totalBonus = 0.0;
        for (BonusObj aBonus : list) {
            int k;
            CDOMObject anObj = (CDOMObject)this.getSourceObject(aBonus);
            if (anObj == null) continue;
            double iBonus = 0.0;
            if (aBonus.qualifies(this.pc, anObj)) {
                iBonus = aBonus.resolve(this.pc, anObj.getQualifiedKey()).doubleValue();
            }
            if (ChooseActivation.hasNewChooseToken(anObj)) {
                k = 0;
                for (String aString : this.pc.getConsolidatedAssociationList(anObj)) {
                    if (!aString.equalsIgnoreCase(aBonus.getBonusInfo())) continue;
                    ++k;
                }
            } else {
                k = 1;
            }
            if (k == 0 && !CoreUtility.doublesEqual(iBonus, 0.0)) {
                totalBonus += iBonus;
                continue;
            }
            totalBonus += iBonus * (double)k;
        }
        return totalBonus;
    }

    public boolean hasTempBonusesApplied(CDOMObject mod) {
        for (TempBonusInfo tbi : this.tempBonusBySource.values()) {
            if (!tbi.source.equals(mod)) continue;
            return true;
        }
        return false;
    }

    private Map<BonusObj, Object> getAllActiveBonuses() {
        IdentityHashMap<BonusObj, Object> ret = new IdentityHashMap<BonusObj, Object>();
        for (BonusContainer pobj : this.pc.getBonusContainerList()) {
            if (pobj == null || pobj instanceof EquipmentModifier) continue;
            boolean use = true;
            if (pobj instanceof PCClass) {
                boolean bl = use = this.pc.getLevel((PCClass)pobj) > 0;
            }
            if (!use) continue;
            pobj.activateBonuses(this.pc);
            List<BonusObj> abs = pobj.getActiveBonuses(this.pc);
            for (BonusObj bo : abs) {
                ret.put(bo, pobj);
            }
        }
        if (this.pc.getUseTempMods()) {
            ret.putAll(this.getTempBonuses());
        }
        return ret;
    }

    public void logChangeFromCheckpoint() {
        HashMap<String, String> addedMap = new HashMap<String, String>(this.activeBonusMap);
        for (Map.Entry<String, String> prevEntry : this.checkpointMap.entrySet()) {
            String addedValue = (String)addedMap.get(prevEntry.getKey());
            if (!prevEntry.getValue().equals(addedValue)) continue;
            addedMap.remove(prevEntry.getKey());
        }
        HashMap<String, String> removedMap = new HashMap<String, String>(this.checkpointMap);
        for (Map.Entry<String, String> prevEntry : this.activeBonusMap.entrySet()) {
            String addedValue = (String)removedMap.get(prevEntry.getKey());
            if (!prevEntry.getValue().equals(addedValue)) continue;
            removedMap.remove(prevEntry.getKey());
        }
        Logging.errorPrint("..Bonuses removed last round: " + removedMap);
        Logging.errorPrint("..Bonuses added last round: " + addedMap);
    }

    public static class TempBonusInfo {
        public final Object source;
        public final Object target;

        public TempBonusInfo(Object src, Object tgt) {
            this.source = src;
            this.target = tgt;
        }
    }
}

