/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class IdentityList<T>
implements List<T> {
    private final List<Identity<T>> embeddedList = new LinkedList<Identity<T>>();

    public IdentityList() {
    }

    public IdentityList(List<T> list) {
        this.addAll((Collection<? extends T>)list);
    }

    private <V> Identity<V> getIdentity(V value) {
        return new Identity<V>(value);
    }

    @Override
    public void add(int index, T element) {
        this.embeddedList.add(index, this.getIdentity(element));
    }

    @Override
    public final boolean add(T element) {
        return this.embeddedList.add(this.getIdentity(element));
    }

    @Override
    public final boolean addAll(Collection<? extends T> collection) {
        for (T element : collection) {
            this.add(element);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        int location = index;
        for (T element : collection) {
            this.add(location++, element);
        }
        return true;
    }

    @Override
    public void clear() {
        this.embeddedList.clear();
    }

    @Override
    public boolean contains(Object element) {
        return this.embeddedList.contains(this.getIdentity(element));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object element : collection) {
            if (this.embeddedList.contains(this.getIdentity(element))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof IdentityList && this.embeddedList.equals(((IdentityList)obj).embeddedList);
    }

    @Override
    public T get(int index) {
        return this.embeddedList.get(index).getUnderlying();
    }

    @Override
    public int hashCode() {
        return this.embeddedList.hashCode();
    }

    @Override
    public int indexOf(Object element) {
        return this.embeddedList.indexOf(this.getIdentity(element));
    }

    @Override
    public boolean isEmpty() {
        return this.embeddedList.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new IdentityIterator(this.embeddedList.listIterator());
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.embeddedList.lastIndexOf(this.getIdentity(element));
    }

    @Override
    public ListIterator<T> listIterator() {
        return new IdentityIterator(this.embeddedList.listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new IdentityIterator(this.embeddedList.listIterator(index));
    }

    @Override
    public T remove(int index) {
        return this.embeddedList.remove(index).getUnderlying();
    }

    @Override
    public boolean remove(Object element) {
        return this.embeddedList.remove(this.getIdentity(element));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean result = true;
        for (Object o : collection) {
            result &= this.remove(o);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        return this.embeddedList.set(index, this.getIdentity(element)).getUnderlying();
    }

    @Override
    public int size() {
        return this.embeddedList.size();
    }

    @Override
    public List<T> subList(int startIndex, int endIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        Object[] array = this.embeddedList.toArray();
        this.putIntoArray(array, array);
        return array;
    }

    private <V> void putIntoArray(Object[] source, V[] target) {
        for (int i = 0; i < source.length; ++i) {
            Identity identity = (Identity)source[i];
            target[i] = identity.getUnderlying();
        }
    }

    @Override
    public <V> V[] toArray(V[] newArray) {
        Object[] array = this.embeddedList.toArray();
        int size = this.embeddedList.size();
        Object[] returnArray = newArray;
        if (newArray.length < size) {
            returnArray = (Object[])Array.newInstance(newArray.getClass().getComponentType(), size);
        }
        this.putIntoArray(array, returnArray);
        return returnArray;
    }

    private class IdentityIterator<I>
    implements ListIterator<I> {
        private final ListIterator<Identity<I>> iter;

        public IdentityIterator(ListIterator<Identity<I>> iterator) {
            this.iter = iterator;
        }

        @Override
        public void add(I item) {
            this.iter.add(IdentityList.this.getIdentity(item));
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public I next() {
            return this.iter.next().getUnderlying();
        }

        @Override
        public int nextIndex() {
            return this.iter.nextIndex();
        }

        @Override
        public I previous() {
            return this.iter.previous().getUnderlying();
        }

        @Override
        public int previousIndex() {
            return this.iter.previousIndex();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        @Override
        public void set(I item) {
            this.iter.set(IdentityList.this.getIdentity(item));
        }
    }

    private static final class Identity<T> {
        private final T underlying;

        public Identity(T item) {
            this.underlying = item;
        }

        public boolean equals(Object obj) {
            return obj instanceof Identity && ((Identity)obj).underlying == this.underlying;
        }

        public int hashCode() {
            return this.underlying.hashCode();
        }

        public T getUnderlying() {
            return this.underlying;
        }
    }
}

