/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.skill;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SkillArmorCheck;
import pcgen.core.Skill;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class AcheckToken
extends AbstractNonEmptyToken<Skill>
implements CDOMPrimaryToken<Skill> {
    public String getTokenName() {
        return "ACHECK";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, Skill skill, String value) {
        SkillArmorCheck aCheck;
        try {
            aCheck = SkillArmorCheck.valueOf((String)value);
        }
        catch (IllegalArgumentException iae) {
            char first = value.charAt(0);
            if (first == 'N') {
                aCheck = SkillArmorCheck.NONE;
            }
            if (first == 'Y') {
                aCheck = SkillArmorCheck.YES;
            }
            if (first == 'P') {
                aCheck = SkillArmorCheck.NONPROF;
            }
            if (first == 'D') {
                aCheck = SkillArmorCheck.DOUBLE;
            }
            if (first == 'W') {
                aCheck = SkillArmorCheck.WEIGHT;
            }
            return new ParseResult.Fail("Skill " + this.getTokenName() + " Did not understand: " + value, context);
        }
        context.getObjectContext().put((CDOMObject)skill, ObjectKey.ARMOR_CHECK, (Object)aCheck);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Skill skill) {
        SkillArmorCheck sac = (SkillArmorCheck)context.getObjectContext().getObject((CDOMObject)skill, ObjectKey.ARMOR_CHECK);
        if (sac == null) {
            return null;
        }
        return new String[]{sac.toString()};
    }

    public Class<Skill> getTokenClass() {
        return Skill.class;
    }
}

