/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.application;

import com.jgoodies.common.swing.Listeners;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.components.util.TreeUtils;
import com.jgoodies.jdiskreport.gui.application.JDNavigationModel;
import com.jgoodies.jdiskreport.gui.application.JDResources;
import com.jgoodies.jdiskreport.gui.node.DirectoryNode;
import com.jgoodies.layout.factories.Paddings;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public final class JDNavigationView {
    private final JDNavigationModel model;
    private JTree tree;
    private JScrollPane scrollPane;

    JDNavigationView(JDNavigationModel navigationModel) {
        this.model = navigationModel;
        this.initComponents();
        this.initEventHandling();
    }

    private void initComponents() {
        this.tree = new JTree(this.model.getDataModel());
        this.tree.setSelectionModel(this.model.getSelectionModel());
        this.tree.setCellRenderer(new FileTreeRenderer());
        this.tree.setBorder(Paddings.createPadding("2dlu, 2dlu, 0, 0", new Object[0]));
        this.tree.setLargeModel(true);
        this.tree.setBackground(JDResources.background());
        this.tree.setRowHeight(ScreenScaling.toPhysical(22));
        this.scrollPane = new JScrollPane(this.tree);
        this.scrollPane.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        this.scrollPane.getHorizontalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
    }

    private void initEventHandling() {
        this.model.addPropertyChangeListener("selection", this::onSelectionChanged);
        this.tree.addMouseListener(Listeners.contextMenu(this.model::onContextMenuRequested));
    }

    private void onSelectionChanged(PropertyChangeEvent evt) {
        this.updateExpansionState();
    }

    JComponent buildPanel() {
        return this.scrollPane;
    }

    private void updateExpansionState() {
        TreePath pathToRoot = this.tree.getSelectionPath();
        if (pathToRoot == null) {
            return;
        }
        boolean expanded = this.tree.isExpanded(pathToRoot);
        TreeUtils.collapseAllSiblings(this.tree, pathToRoot);
        if (!expanded) {
            // empty if block
        }
        this.tree.expandPath(pathToRoot);
        this.tree.scrollPathToVisible(pathToRoot);
    }

    private static final class FileTreeRenderer
    extends DefaultTreeCellRenderer {
        private Font cachedOriginalFont;
        private Font boldFont;

        FileTreeRenderer() {
            this.setBackgroundNonSelectionColor(JDResources.background());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            super.getTreeCellRendererComponent(tree, value, this.selected, expanded, false, row, focus);
            DirectoryNode node = (DirectoryNode)value;
            this.setForeground(sel ? this.getTextSelectionColor() : this.getTextNonSelectionColor());
            this.selected = sel;
            this.setIcon(node.getIcon(this.selected));
            this.setText(node.getNodeName());
            this.setFont(node.getAbsoluteSize() > (double)0.15f ? this.getBoldFont(tree.getFont()) : tree.getFont());
            return this;
        }

        private Font getBoldFont(Font originalFont) {
            if (originalFont != this.cachedOriginalFont) {
                this.boldFont = originalFont.deriveFont(1);
                this.cachedOriginalFont = originalFont;
            }
            return this.boldFont;
        }
    }
}

