/* Summermute 1.2
 *
 * Namespace: SM_ / sm_
 */

/* Copyright (c) 2009, The Static Void Project
 *
 * Permission to use, copy, modify, and/or distribute this software for 
 * any purpose with or without fee is hereby granted, provided that the 
 * above copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN 
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */


/* Rule state type  */
#define SM_NOT_MATCHED  0
#define SM_MATCHED      1
typedef int             SM_RULE_STATE;

/* Rule function mode type */
#define SM_STATE        0
#define SM_FIRE         1
typedef int             SM_MODE;

/* Rule function type */
typedef SM_RULE_STATE   (* SM_RULE)(SM_MODE);

/* Number of rules type */
typedef int             SM_N_RULES;

/* Preprocessor black magic
 */
#define SM_RULE_FUNCTION(f)     SM_RULE_STATE f (SM_MODE sm_m)
#define SM_CONDITIONS           if (sm_m == SM_STATE)
#define SM_EFFECTS              else
#define SM_RULE_MATCHED         return SM_MATCHED
#define SM_RULE_NOT_MATCHED     return SM_NOT_MATCHED
#define SM_RULE_FIRED           return SM_NOT_MATCHED


/* Function prototypes
 */
void    sm_apply_rules(const SM_RULE *, SM_N_RULES);

