/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util.CharConvBuilder;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.StreamTokenizer;
import oracle.gss.util.CharConvBuilder.CharDataParser;
import oracle.gss.util.CharConvBuilder.TokenParser;

public class DataTypeParser
extends CharDataParser {
    private static final boolean DEBUG = false;
    private long INTEGERMASK = -1L;
    private long HIGHBYTEMASK = -65536L;
    private int MAXLEADCODE = 4;
    private char[] LeadCode = new char[this.MAXLEADCODE];
    private int maxByte;
    private boolean fixedWidth;
    private boolean tooManyLeadCode;
    private boolean isEBCDICBASED;
    private boolean isASCIIBASED;
    private boolean isFIXEDWIDTH;
    private boolean isSHIFT;
    private boolean isUNICODE;
    private boolean isSPECIALRANGE;
    public int baseCharID;
    public int typeID;

    public DataTypeParser(FileInputStream fileInputStream) throws IOException {
        int n;
        StreamTokenizer streamTokenizer = TokenParser.getTokenizer(fileInputStream);
        boolean bl = false;
        int n2 = 0;
        String string = "";
        int n3 = 1;
        this.maxByte = 0;
        this.fixedWidth = true;
        this.isEBCDICBASED = false;
        this.isASCIIBASED = false;
        this.isFIXEDWIDTH = false;
        this.isSHIFT = false;
        this.isUNICODE = false;
        this.isSPECIALRANGE = false;
        this.tooManyLeadCode = false;
        this.typeID = -1;
        this.baseCharID = -1;
        int n4 = 0;
        while (n4 < this.MAXLEADCODE) {
            this.LeadCode[n4] = '\u0000';
            ++n4;
        }
        while ((n = streamTokenizer.nextToken()) != -1 && !bl) {
            block0 : switch (n2) {
                case 0: 
                case 2: {
                    if (n == -3 || n == 34) {
                        string = String.valueOf(string) + streamTokenizer.sval;
                        n2 = 1;
                        n3 = 1;
                        break;
                    }
                    string = "";
                    break;
                }
                case 1: {
                    switch (n) {
                        case 95: {
                            string = String.valueOf(string) + (char)n;
                            n2 = 2;
                            break block0;
                        }
                        case 61: {
                            n2 = 3;
                            break block0;
                        }
                        case -3: {
                            TokenParser.skipToEndOfDelimiter(streamTokenizer, n3);
                            n2 = 0;
                            string = "";
                            break block0;
                        }
                    }
                    n2 = TokenParser.processSyntaxError(streamTokenizer, n3);
                    string = "";
                    break;
                }
                case 3: {
                    switch (n) {
                        case 123: {
                            if (string.compareTo("character_data") == 0) {
                                this.parseCharInfo(streamTokenizer, n3);
                            } else if (string.compareTo("flags") == 0) {
                                this.parseFlagInfo(streamTokenizer, n3);
                            } else {
                                n3 = 2;
                                TokenParser.skipToEndOfDelimiter(streamTokenizer, n3);
                            }
                            n2 = 0;
                            string = "";
                            break block0;
                        }
                    }
                    if (string.compareTo("base_char_set") == 0) {
                        this.baseCharID = TokenParser.getInteger(streamTokenizer);
                        n2 = 0;
                        string = "";
                        break;
                    }
                    TokenParser.skipToEndOfDelimiter(streamTokenizer, n3);
                    n2 = 0;
                    string = "";
                    break;
                }
                default: {
                    n2 = TokenParser.processSyntaxError(streamTokenizer, n3);
                    string = "";
                    break;
                }
            }
        }
        if (this.tooManyLeadCode) {
            System.err.println("Ginstall can not support character sets with");
            System.err.println("more than 4 lead codes");
            this.typeID = -1;
            return;
        }
        if (this.isUNICODE) {
            return;
        }
        switch (this.maxByte) {
            case 1: {
                this.typeID = 0;
                return;
            }
            case 2: {
                this.typeID = this.isSHIFT ? 7 : (this.isFIXEDWIDTH ? 6 : (this.isSPECIALRANGE ? 4 : 1));
                return;
            }
            case 3: {
                if (!this.isFIXEDWIDTH) {
                    this.typeID = 2;
                }
                return;
            }
            case 4: {
                this.typeID = this.isFIXEDWIDTH ? 3 : 5;
                return;
            }
        }
        System.err.println("Ginstall can not support character sets with");
        System.err.println("characters longer than 4 bytes");
        this.typeID = -1;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseCharInfo(StreamTokenizer var1_1, int var2_2) throws IOException {
        var4_3 = 0;
        var5_4 = 0L;
        var7_5 = 0L;
        while ((var3_6 = var1_1.nextToken()) != -1) {
            block2 : switch (var4_3) {
                case 0: {
                    switch (var3_6) {
                        case -2: {
                            try {
                                var5_4 = TokenParser.getLong(var1_1);
                                var9_7 = (char)((var5_4 & this.HIGHBYTEMASK) >> 16);
                                if (var5_4 > 65535L) {
                                    var10_8 = 0;
                                    while (var10_8 < this.MAXLEADCODE) {
                                        if (this.LeadCode[var10_8] == '\u0000') {
                                            this.LeadCode[var10_8] = var9_7;
                                            break;
                                        }
                                        if (this.LeadCode[var10_8] == var9_7) break;
                                        ++var10_8;
                                    }
                                    if (var10_8 >= this.MAXLEADCODE) {
                                        var4_3 = TokenParser.processSyntaxError(var1_1, var2_2);
                                        this.tooManyLeadCode = true;
                                    }
                                }
                                if (var5_4 > 0xFFFFFFL) {
                                    this.maxByte = Math.max(this.maxByte, 4);
                                } else if (var5_4 > 65535L) {
                                    this.maxByte = Math.max(this.maxByte, 3);
                                } else if (var5_4 > 255L) {
                                    this.maxByte = Math.max(this.maxByte, 2);
                                } else {
                                    this.maxByte = Math.max(this.maxByte, 1);
                                    if (var5_4 > 127L) {
                                        this.isSPECIALRANGE = true;
                                    }
                                }
                                var4_3 = 14;
                                ** break;
                            }
                            catch (NumberFormatException v0) {
                                System.err.println("sourceCodePoint = " + Long.toHexString(var5_4));
                                TokenParser.processSyntaxError(var1_1, var2_2);
                                return false;
                            }
                        }
                        case 125: {
                            return true;
                        }
                        default: {
                            break block2;
                        }
                    }
                }
                case 14: {
                    if (var3_6 != 58) {
                        TokenParser.processSyntaxError(var1_1, var2_2);
                        return false;
                    }
                    var4_3 = 9;
                    break;
                }
                case 9: {
                    try {
                        var7_5 = TokenParser.getLong(var1_1);
                        var4_3 = 15;
                        break;
                    }
                    catch (NumberFormatException v1) {
                        TokenParser.processSyntaxError(var1_1, var2_2);
                        return false;
                    }
                }
                case 15: {
                    switch (var3_6) {
                        case 44: 
                        case 125: {
                            if (var3_6 != 44) {
                                return true;
                            }
                            var4_3 = 0;
                            break block2;
                        }
                    }
                    TokenParser.processSyntaxError(var1_1, var2_2);
                    return false;
                }
lbl73:
                // 1 sources

                break;
            }
        }
        return true;
    }

    private boolean parseFlagInfo(StreamTokenizer streamTokenizer, int n) throws IOException {
        int n2;
        String string = null;
        while ((n2 = streamTokenizer.nextToken()) != -1) {
            switch (n2) {
                case 125: {
                    return true;
                }
                case -3: {
                    string = TokenParser.getString(streamTokenizer, 125);
                    if (string.indexOf("ascii") != -1) {
                        this.isASCIIBASED = true;
                    }
                    if (string.indexOf("fixed") != -1) {
                        this.isFIXEDWIDTH = true;
                    }
                    if (string.indexOf("ebcdic") != -1) {
                        this.isEBCDICBASED = true;
                    }
                    if (string.indexOf("shift") != -1) {
                        this.isSHIFT = true;
                    }
                    if (string.indexOf("unicode") != -1) {
                        this.isUNICODE = true;
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

