/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.Stack;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.ast.ASTReferenceType;
import net.sourceforge.pmd.ast.ASTType;
import net.sourceforge.pmd.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.ast.SimpleJavaNode;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.util.NumericConstants;

public class MoreThanOneLogger
extends AbstractRule {
    private Stack<Integer> stack = new Stack();
    private Integer count;

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        return this.init(node, data);
    }

    public Object visit(ASTEnumDeclaration node, Object data) {
        return this.init(node, data);
    }

    private Object init(SimpleJavaNode node, Object data) {
        this.stack.push(this.count);
        this.count = NumericConstants.ZERO;
        node.childrenAccept(this, data);
        if (this.count > 1) {
            this.addViolation(data, node);
        }
        this.count = this.stack.pop();
        return data;
    }

    public Object visit(ASTVariableDeclarator node, Object data) {
        SimpleNode classOrIntType;
        SimpleNode reftypeNode;
        if (this.count > 1) {
            return super.visit(node, data);
        }
        SimpleNode type = ((SimpleNode)node.jjtGetParent()).getFirstChildOfType(ASTType.class);
        if (type != null && (reftypeNode = (SimpleNode)type.jjtGetChild(0)) instanceof ASTReferenceType && (classOrIntType = (SimpleNode)reftypeNode.jjtGetChild(0)) instanceof ASTClassOrInterfaceType && "Logger".equals(classOrIntType.getImage())) {
            this.count = this.count + 1;
        }
        return super.visit(node, data);
    }
}

