/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.model;

import java.util.Collection;
import java.util.Properties;
import org.dbuml.base.model.DBElement;
import org.dbuml.base.model.FKey;
import org.dbuml.base.model.PKeyInterface;
import org.dbuml.base.model.Table;

public class Column
extends DBElement {
    private String typeNameJdbc = null;
    protected short jdbcType = 0;
    private static final String PROP_INDEX_NAME = "INDEX_NAME";
    private static final String PROP_PK_NAME = "PK_NAME";
    private static final String PROP_KEY_SEQ = "KEY_SEQ";
    private static final String PROP_LENGTH = "LENGTH";
    private static final String PROP_PRECISION = "PRECISION";
    private static final String PROP_SCALE = "SCALE";
    private static final String PROP_DEFAULT = "DEFAULT";
    private int length = 0;
    private int scale = 0;
    private String defValue = "";
    private String typeName = null;
    private boolean unique = false;
    private boolean partOfUniqueConstraint = false;
    protected Table table;
    private boolean allowNulls = true;
    private boolean homogeneousArray = true;
    private String homogeneousTypeName = null;
    private PKeyInterface key;

    public Column() {
    }

    public Column(String name) {
        this.setName(name);
    }

    public Column(String sName, Object objModel, Properties properties) {
        super(sName, objModel, properties);
    }

    public boolean allowsNulls() {
        return this.allowNulls;
    }

    public boolean allowsNulls(boolean includeKey) {
        if (includeKey && this.isPrimaryKey()) {
            return false;
        }
        return this.allowNulls;
    }

    public void setAllowsNulls(boolean flag) {
        this.allowNulls = flag;
    }

    public boolean isPartOfUniqueConstraint() {
        return this.partOfUniqueConstraint;
    }

    public void isPartOfUniqueConstraint(boolean flag) {
        this.partOfUniqueConstraint = flag;
    }

    public boolean isHomogeneousArray() {
        return this.homogeneousArray;
    }

    public void isHomogeneousArray(boolean flag) {
        this.homogeneousArray = flag;
    }

    public String getHomogeneousArrayTypeName() {
        return this.homogeneousTypeName;
    }

    public void setHomogeneousArrayTypeName(String name) {
        this.homogeneousTypeName = name;
    }

    public String getStereostring() {
        String val = null;
        if (this.key != null) {
            val = this.key.getType();
        } else if (this.isUnique()) {
            val = "Unique";
        }
        return val;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void isUnique(boolean flag) {
        this.unique = flag;
    }

    public void setIndexInfo(String iname) {
        if (this.getIndexNames().length == 0) {
            this.setProperty(PROP_INDEX_NAME, iname);
        } else {
            this.setProperty(PROP_INDEX_NAME, this.getProperty(PROP_INDEX_NAME) + ":" + iname);
        }
        if (this.table != null) {
            this.table.recordIndex(this);
        }
    }

    public String[] getIndexNames() {
        String indexStr = this.getProperty(PROP_INDEX_NAME);
        String[] val = null;
        val = indexStr != null && !indexStr.equals("") ? indexStr.split(":") : new String[]{};
        return val;
    }

    public boolean hasStereotype() {
        return this.getStereostring() != null;
    }

    public int getLength() {
        String prec;
        String val;
        int retLength = this.length;
        boolean typeUnknown = true;
        if ((this.isStringType() || this.jdbcType == 0) && (val = this.getProperty(PROP_LENGTH)) != null) {
            try {
                retLength = Integer.valueOf(val);
            }
            catch (NumberFormatException nf) {
                System.err.println(nf.getMessage());
            }
            typeUnknown = false;
        }
        if (typeUnknown && (this.isDecimalType() || this.jdbcType == 0) && (prec = this.getProperty(PROP_PRECISION)) != null) {
            try {
                retLength = Integer.valueOf(prec);
            }
            catch (NumberFormatException nf) {
                System.err.println(nf.getMessage());
            }
        }
        return retLength;
    }

    public void setLength(int len) {
        this.length = len;
        if (this.isStringType()) {
            this.setProperty(PROP_LENGTH, String.valueOf(len));
        } else if (this.isDecimalType()) {
            this.setProperty(PROP_PRECISION, String.valueOf(len));
        }
    }

    public int getScale() {
        String val = this.getProperty(PROP_SCALE);
        int retVal = this.scale;
        if (val != null) {
            try {
                retVal = Integer.valueOf(val);
            }
            catch (NumberFormatException nf) {
                System.err.println(nf.getMessage());
            }
        }
        return retVal;
    }

    public void setScale(int digit) {
        this.scale = digit;
        if (this.isDecimalType() && digit > 0) {
            this.setProperty(PROP_SCALE, String.valueOf(digit));
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String name) {
        this.typeName = name;
    }

    public String getTypeNameJdbc() {
        return this.typeNameJdbc;
    }

    public void setTypeNameJdbc(String name) {
        this.typeNameJdbc = name;
    }

    public final boolean isPrimaryKey() {
        return this.key != null && (this.key.getType() == "PK" || this.key.getType() == "PFK");
    }

    public final boolean isForeignKey() {
        return this.key != null && this.key.isForeignKey();
    }

    public void setKey(PKeyInterface k) {
        if (this.key != null && k instanceof FKey) {
            ((FKey)k).setColumn(this);
            this.key.setForeignInfo((FKey)k);
        } else {
            this.key = k;
            if (this.key instanceof FKey) {
                ((FKey)this.key).setColumn(this);
            } else {
                this.setProperty(PROP_PK_NAME, this.key.getKeyName());
                this.setProperty(PROP_KEY_SEQ, new Short(this.key.getKeySequence()).toString());
            }
        }
    }

    public PKeyInterface getKey() {
        return this.key;
    }

    public boolean isRef() {
        return 2006 == this.jdbcType;
    }

    public boolean isArray() {
        return 2003 == this.jdbcType;
    }

    public boolean isRelated() {
        return this.isRef() && this.typeName != null || this.isForeignKey();
    }

    public String getRelatedTableName() {
        String tName = null;
        if (this.isForeignKey()) {
            tName = this.getKey().getForeignKey().getNativeTableName();
        } else if (this.isRef()) {
            tName = this.getTypeName();
        }
        return tName != null ? this.fixName(tName) : tName;
    }

    public boolean inherited() {
        return false;
    }

    public void setJdbcType(short type) {
        this.jdbcType = type;
    }

    public short getJdbcType() {
        return this.jdbcType;
    }

    public boolean isComplexKey() {
        return this.key != null && this.key.getType() == "PFK";
    }

    public void setTable(Table t) {
        this.table = t;
    }

    public Collection getIndexSets() {
        return this.table.getIndexSets(this);
    }

    private boolean isStringType() {
        return 1 == this.jdbcType || 12 == this.jdbcType || -2 == this.jdbcType || -1 == this.jdbcType;
    }

    private boolean isDecimalType() {
        return 2 == this.jdbcType || 7 == this.jdbcType || 3 == this.jdbcType;
    }

    public String toString() {
        return this.getName();
    }

    public void setDefault(String defaultValue) {
        this.setProperty(PROP_DEFAULT, defaultValue);
    }

    public String getDefault() {
        String defaultValue = this.getProperty(PROP_DEFAULT);
        String val = this.defValue;
        if (defaultValue != null) {
            val = String.valueOf(defaultValue).toString();
        }
        return val;
    }
}

