/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.dbuml.base.database.UpdateTransaction;

public class GenericUpdateTransaction
extends UpdateTransaction {
    public GenericUpdateTransaction(Connection conn) throws IllegalArgumentException, SQLException {
        if (conn.isClosed()) {
            throw new IllegalArgumentException();
        }
        this.setConnection(conn);
    }

    public void executeUpdate(String sSQL) throws SQLException {
        if (sSQL == null) {
            throw new IllegalArgumentException();
        }
        Statement stmt = this.getConnection().createStatement();
        StringTokenizer strtok = new StringTokenizer(sSQL, ";");
        try {
            while (strtok.hasMoreTokens()) {
                String sql = strtok.nextToken();
                if (sql == null || sql.length() <= 2) continue;
                stmt.executeUpdate(sql);
            }
        }
        catch (SQLException e) {
            this.rollback();
            throw e;
        }
        stmt.close();
    }

    public void commit() throws SQLException {
        this.getConnection().commit();
    }

    public void rollback() throws SQLException {
        this.getConnection().rollback();
    }
}

