/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.argo.uml.diagram.ui;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Action;
import org.argouml.i18n.Translator;
import org.argouml.ui.ArgoJMenu;
import org.argouml.uml.diagram.static_structure.ui.FigClass;
import org.argouml.uml.diagram.ui.ActionAddNote;
import org.dbuml.argo.uml.diagram.ui.DBFigure;
import org.dbuml.argo.uml.ui.ActionAddNotNullConstraint;
import org.dbuml.argo.uml.ui.ActionAddUniqueConstraint;
import org.dbuml.argo.uml.ui.ActionBrowseInstances;
import org.dbuml.argo.uml.ui.ActionCreateColumn;
import org.dbuml.argo.uml.ui.ActionCreatePKEY;
import org.dbuml.argo.uml.ui.ActionGenerateSource;
import org.dbuml.argo.uml.ui.ActionUpdateCatalog;
import org.dbuml.base.model.DBModelFacade;
import org.dbuml.base.model.Database;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.undo.UndoableAction;

public class FigTable
extends FigClass
implements DBFigure {
    private static Color filler = new Color(255, 255, 200);

    public FigTable(Object modelElement, int x, int y, int w, int h) {
        super(modelElement, x, y, w, h);
        this.setFillColor(this.getFiller());
    }

    public FigTable(GraphModel gm, Object node) {
        super(gm, node);
        this.setFillColor(this.getFiller());
    }

    protected Color getFiller() {
        return filler;
    }

    public Vector getAdditionalPopUpActions() {
        Vector<UndoableAction> popUpActions = new Vector<UndoableAction>();
        Database database = DBModelFacade.getInstance().getOwningDatabase(this.getOwner());
        if (database != null) {
            if (database.isConnected()) {
                popUpActions.addElement(ActionUpdateCatalog.SINGLETON);
                popUpActions.addElement(ActionBrowseInstances.SINGLETON);
            }
            popUpActions.addElement(ActionGenerateSource.SINGLETON);
        }
        return popUpActions;
    }

    public Vector getPopUpActions(MouseEvent me) {
        Vector popUpActions = super.getPopUpActions(me);
        Iterator it = popUpActions.iterator();
        int i = 0;
        while (it.hasNext()) {
            ArgoJMenu menue;
            Object obj = it.next();
            if (obj instanceof ArgoJMenu && (menue = (ArgoJMenu)obj).getText().equals(Translator.localize((String)"menu.popup.add"))) {
                popUpActions.removeElement(obj);
                ArgoJMenu addMenu = new ArgoJMenu("menu.popup.add");
                addMenu.add((Action)((Object)ActionCreateColumn.getInstance()));
                addMenu.add((Action)((Object)ActionCreatePKEY.getInstance()));
                addMenu.add((Action)((Object)ActionAddNotNullConstraint.getInstance()));
                addMenu.add((Action)((Object)ActionAddUniqueConstraint.getInstance()));
                addMenu.add((Action)new ActionAddNote());
                popUpActions.insertElementAt(addMenu, i);
                break;
            }
            ++i;
        }
        popUpActions.addAll(this.getAdditionalPopUpActions());
        return popUpActions;
    }

    public String placeString() {
        return "new " + this.getDBFigName();
    }

    public String getTipString(MouseEvent me) {
        return this.getDBFigName() + ": " + this.getName();
    }

    public String getDBFigName() {
        return "Table";
    }
}

