/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u000f\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\tH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsDynamicCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkIdentifier", "name", "", "checkSpreadOperator", "reportInOperation", "reportedOn", "", "element", "js.frontend"})
@SourceDebugExtension(value={"SMAP\nJsDynamicCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsDynamicCallChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsDynamicCallChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1755#2,3:112\n*S KotlinDebug\n*F\n+ 1 JsDynamicCallChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsDynamicCallChecker\n*L\n110#1:112,3\n*E\n"})
public final class JsDynamicCallChecker
implements CallChecker {
    @NotNull
    public static final JsDynamicCallChecker INSTANCE = new JsDynamicCallChecker();

    private JsDynamicCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"getResultingDescriptor(...)");
        Object callee = obj;
        if (!DynamicCallsKt.isDynamic((DeclarationDescriptor)callee)) {
            this.checkSpreadOperator(resolvedCall2, context);
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"getCallElement(...)");
        KtElement element = ktElement;
        KtElement ktElement2 = element;
        if (ktElement2 instanceof KtArrayAccessExpression) {
            if (((KtArrayAccessExpression)element).getIndexExpressions().size() > 1) {
                context.getTrace().report(ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC.on(reportOn, "indexed access with more than one index"));
            }
        } else if (ktElement2 instanceof KtWhenConditionInRange) {
            this.reportInOperation(context, reportOn);
        } else if (ktElement2 instanceof KtBinaryExpression) {
            IElementType iElementType;
            IElementType iElementType2 = ((KtBinaryExpression)element).getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getOperationToken(...)");
            IElementType iElementType3 = iElementType = iElementType2;
            ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.IN_OPERATIONS;
            Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"IN_OPERATIONS");
            if (CollectionsKt.contains((Iterable)immutableSet, (Object)iElementType3)) {
                this.reportInOperation(context, reportOn);
            } else if (Intrinsics.areEqual((Object)iElementType3, (Object)KtTokens.RANGE) || Intrinsics.areEqual((Object)iElementType3, (Object)KtTokens.RANGE_UNTIL)) {
                KtSingleValueToken cfr_ignored_0 = (KtSingleValueToken)iElementType;
                context.getTrace().report(ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC.on(reportOn, '`' + ((KtSingleValueToken)iElementType).getValue() + "` operation"));
            }
        } else if (ktElement2 instanceof KtDestructuringDeclarationEntry) {
            PsiElement psiElement = ((KtDestructuringDeclarationEntry)element).getNode().getTreeParent().getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
            if (!this.reportedOn(context, psiElement)) {
                context.getTrace().report(ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC.on(((KtDestructuringDeclarationEntry)element).getParent(), "destructuring declaration"));
            }
        } else if (ktElement2 instanceof KtSimpleNameExpression) {
            this.checkIdentifier(((KtSimpleNameExpression)element).getReferencedName(), element, context);
        } else if (ktElement2 instanceof KtCallExpression && (ktExpression = ((KtCallExpression)element).getCalleeExpression()) instanceof KtSimpleNameExpression) {
            this.checkIdentifier(((KtSimpleNameExpression)ktExpression).getReferencedName(), ktExpression, context);
        }
        for (ValueArgument valueArgument : resolvedCall2.getCall().getValueArguments()) {
            LeafPsiElement it;
            if (valueArgument.getSpreadElement() == null) continue;
            boolean bl = false;
            context.getTrace().report(ErrorsJs.SPREAD_OPERATOR_IN_DYNAMIC_CALL.on(it));
        }
    }

    private final void checkIdentifier(String name2, PsiElement reportOn, CallCheckerContext context) {
        if (name2 == null || context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)NameSuggestion.Companion.sanitizeName(name2), (Object)name2)) {
            context.getTrace().report(ErrorsJs.NAME_CONTAINS_ILLEGAL_CHARS.on(reportOn));
        }
    }

    private final void checkSpreadOperator(ResolvedCall<?> resolvedCall2, CallCheckerContext context) {
        for (ValueArgument valueArgument : resolvedCall2.getCall().getValueArguments()) {
            KtExpression argExpression;
            if (valueArgument.getArgumentExpression() == null) continue;
            KotlinType kotlinType = context.getTrace().getBindingContext().getType(argExpression);
            boolean bl = kotlinType != null ? DynamicTypesKt.isDynamic(kotlinType) : false;
            if (!bl || valueArgument.getSpreadElement() == null) continue;
            context.getTrace().report(ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC.on(valueArgument.asElement(), "spread operator"));
        }
    }

    private final void reportInOperation(CallCheckerContext context, PsiElement reportOn) {
        context.getTrace().report(ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC.on(reportOn, "`in` operation"));
    }

    private final boolean reportedOn(CallCheckerContext context, PsiElement element) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = context.getTrace().getBindingContext().getDiagnostics().forElement(element);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getFactory(), ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

