/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTError;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Context;
import javax.media.j3d.Drawable;
import javax.media.j3d.DrawingSurfaceObject;
import javax.media.j3d.DrawingSurfaceObjectAWT;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GraphicsConfigInfo;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.MasterControl;
import javax.media.j3d.NativeConfigTemplate3D;
import javax.media.j3d.NativeContext;
import javax.media.j3d.NativeDrawable;
import javax.media.j3d.NativeScreenInfo;
import javax.media.j3d.NativeShaderObject;
import javax.media.j3d.Pipeline;
import javax.media.j3d.ShaderAttrLoc;
import javax.media.j3d.ShaderError;
import javax.media.j3d.ShaderId;
import javax.media.j3d.ShaderProgramId;
import javax.media.j3d.VirtualUniverse;

class NativePipeline
extends Pipeline {
    private static final String[] systemPathProps = new String[]{"sun.boot.library.path", "java.library.path"};
    private static final String libPrefix = "j3dcore";
    private boolean isD3D;
    private String rendererName;
    private boolean cgLibraryAvailable = false;
    private boolean glslLibraryAvailable = false;
    private static boolean oglChkLibraryLoaded = false;

    static String getSupportedOglVendor() {
        if (!oglChkLibraryLoaded) {
            try {
                NativePipeline.loadLibrary("j3dcore-ogl-chk", true);
            }
            catch (Exception exception) {
                MasterControl.getCoreLogger().severe(exception.toString());
                return null;
            }
            catch (Error error) {
                MasterControl.getCoreLogger().severe(error.toString());
                return null;
            }
            oglChkLibraryLoaded = true;
        }
        return NativePipeline.getSupportedOglVendorNative();
    }

    private static native String getSupportedOglVendorNative();

    protected NativePipeline() {
    }

    void initialize(Pipeline.Type type) {
        super.initialize(type);
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit = null;
        }
        catch (AWTError aWTError) {
            // empty catch block
        }
        switch (type) {
            case NATIVE_OGL: {
                this.isD3D = false;
                this.rendererName = "ogl";
                break;
            }
            case NATIVE_D3D: {
                this.isD3D = true;
                this.rendererName = "d3d";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        NativeConfigTemplate3D.createNativeConfigTemplate3D();
        NativeScreenInfo.createNativeScreenInfo();
    }

    void loadLibraries(int n) {
        try {
            NativePipeline.loadLibrary("jawt", false);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (unsatisfiedLinkError.getMessage().indexOf("already loaded") == -1) {
                MasterControl.getCoreLogger().severe(unsatisfiedLinkError.toString());
            }
        }
        catch (Error error) {
            MasterControl.getCoreLogger().severe(error.toString());
        }
        catch (Exception exception) {
            MasterControl.getCoreLogger().severe(exception.toString());
        }
        String string = "j3dcore-" + this.rendererName;
        NativePipeline.loadLibrary(string, true);
        if (n == 2) {
            String string2 = "j3dcore-" + this.rendererName + "-cg";
            String[] stringArray = this.setupLibPath(string2);
            this.cgLibraryAvailable = this.loadNativeCgLibrary(stringArray);
        }
        if (n == 1 && this.getPipelineType() == Pipeline.Type.NATIVE_OGL) {
            this.glslLibraryAvailable = true;
        }
    }

    boolean isCgLibraryAvailable() {
        return this.cgLibraryAvailable;
    }

    boolean isGLSLLibraryAvailable() {
        return this.glslLibraryAvailable;
    }

    private static void loadLibrary(final String string, boolean bl) {
        final boolean bl2 = bl && MasterControl.isAppletLauncher();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (bl2) {
                        Class<?> clazz = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                        Method method = clazz.getDeclaredMethod("loadLibrary", String.class);
                        method.invoke(null, string);
                    } else {
                        System.loadLibrary(string);
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                return null;
            }
        });
    }

    private String[] setupLibPath(String string) {
        final String string2 = string;
        return (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList<String> arrayList = new ArrayList<String>();
                String string = System.mapLibraryName(string2);
                for (int i = 0; i < systemPathProps.length; ++i) {
                    String string22 = System.getProperty(systemPathProps[i]);
                    boolean bl = false;
                    int n = 0;
                    while (!bl) {
                        String string3;
                        File file;
                        int n2 = string22.indexOf(File.pathSeparator, n);
                        if (n2 == -1) {
                            n2 = string22.length();
                            bl = true;
                        }
                        if ((file = new File(string3 = string22.substring(n, n2), string)).exists()) {
                            arrayList.add(file.getAbsolutePath());
                        }
                        n = n2 + 1;
                    }
                }
                if (arrayList.size() == 0) {
                    arrayList.add(string);
                }
                return arrayList.toArray(new String[0]);
            }
        });
    }

    private native boolean loadNativeCgLibrary(String[] var1);

    private long unbox(Context context) {
        if (context == null) {
            return 0L;
        }
        return ((NativeContext)context).getNativeCtx();
    }

    private Context boxContext(long l) {
        if (l == 0L) {
            return null;
        }
        return new NativeContext(l);
    }

    private long unbox(Drawable drawable) {
        if (drawable == null) {
            return 0L;
        }
        return ((NativeDrawable)drawable).getNativeDrawable();
    }

    private Drawable boxDrawable(long l) {
        if (l == 0L) {
            return null;
        }
        return new NativeDrawable(l);
    }

    private long unbox(ShaderProgramId shaderProgramId) {
        if (shaderProgramId == null) {
            return 0L;
        }
        return ((NativeShaderObject)shaderProgramId).getNativeId();
    }

    private ShaderProgramId boxShaderProgramId(long l) {
        if (l == 0L) {
            return null;
        }
        return new NativeShaderObject(l);
    }

    private long unbox(ShaderId shaderId) {
        if (shaderId == null) {
            return 0L;
        }
        return ((NativeShaderObject)shaderId).getNativeId();
    }

    private ShaderId boxShaderId(long l) {
        if (l == 0L) {
            return null;
        }
        return new NativeShaderObject(l);
    }

    private long unbox(ShaderAttrLoc shaderAttrLoc) {
        if (shaderAttrLoc == null) {
            return -1L;
        }
        return ((NativeShaderObject)shaderAttrLoc).getNativeId();
    }

    private ShaderAttrLoc boxShaderAttrLoc(long l) {
        if (l == -1L) {
            return null;
        }
        return new NativeShaderObject(l);
    }

    native void freeD3DArray(GeometryArrayRetained var1, boolean var2);

    native void execute(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, boolean var7, int var8, int var9, int var10, int var11, int[] var12, int var13, int[] var14, int var15, int var16, int[] var17, float[] var18, float[] var19, int var20);

    void execute(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5, int[] nArray, int n6, int[] nArray2, int n7, int n8, int[] nArray3, float[] fArray, float[] fArray2, int n9) {
        this.execute(this.unbox(context), geometryArrayRetained, n, bl, bl2, bl3, n2, n3, n4, n5, nArray, n6, nArray2, n7, n8, nArray3, fArray, fArray2, n9);
    }

    native void executeVA(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, float[] var11, double[] var12, int var13, float[] var14, byte[] var15, int var16, float[] var17, int var18, int[] var19, int[] var20, float[][] var21, int var22, int[] var23, int var24, int[] var25, int var26, Object[] var27, int var28);

    void executeVA(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, float[] fArray, double[] dArray, int n6, float[] fArray2, byte[] byArray, int n7, float[] fArray3, int n8, int[] nArray, int[] nArray2, float[][] fArray4, int n9, int[] nArray3, int n10, int[] nArray4, int n11, Object[] objectArray, int n12) {
        this.executeVA(this.unbox(context), geometryArrayRetained, n, bl, bl2, n2, n3, n4, n5, fArray, dArray, n6, fArray2, byArray, n7, fArray3, n8, nArray, nArray2, fArray4, n9, nArray3, n10, nArray4, n11, objectArray, n12);
    }

    native void executeVABuffer(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, Object var11, int var12, Object var13, float[] var14, byte[] var15, int var16, Object var17, int var18, int[] var19, int[] var20, Object[] var21, int var22, int[] var23, int var24, int[] var25, int var26, Object[] var27, int var28);

    void executeVABuffer(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, Object object, int n6, Object object2, float[] fArray, byte[] byArray, int n7, Object object3, int n8, int[] nArray, int[] nArray2, Object[] objectArray, int n9, int[] nArray3, int n10, int[] nArray4, int n11, Object[] objectArray2, int n12) {
        this.executeVABuffer(this.unbox(context), geometryArrayRetained, n, bl, bl2, n2, n3, n4, n5, object, n6, object2, fArray, byArray, n7, object3, n8, nArray, nArray2, objectArray, n9, nArray3, n10, nArray4, n11, objectArray2, n12);
    }

    native void executeInterleavedBuffer(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, boolean var7, int var8, int var9, int var10, int var11, int[] var12, int var13, int[] var14, int var15, Object var16, float[] var17, int var18);

    void executeInterleavedBuffer(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5, int[] nArray, int n6, int[] nArray2, int n7, Object object, float[] fArray, int n8) {
        this.executeInterleavedBuffer(this.unbox(context), geometryArrayRetained, n, bl, bl2, bl3, n2, n3, n4, n5, nArray, n6, nArray2, n7, object, fArray, n8);
    }

    native void setVertexFormat(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6);

    void setVertexFormat(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2) {
        this.setVertexFormat(this.unbox(context), geometryArrayRetained, n, bl, bl2);
    }

    native void disableGlobalAlpha(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6);

    void disableGlobalAlpha(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2) {
        this.disableGlobalAlpha(this.unbox(context), geometryArrayRetained, n, bl, bl2);
    }

    native void buildGA(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, float var7, boolean var8, int var9, int var10, int var11, int var12, int[] var13, int var14, int[] var15, int var16, int[] var17, double[] var18, double[] var19, float[] var20);

    void buildGA(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, float f, boolean bl3, int n2, int n3, int n4, int n5, int[] nArray, int n6, int[] nArray2, int n7, int[] nArray3, double[] dArray, double[] dArray2, float[] fArray) {
        this.buildGA(this.unbox(context), geometryArrayRetained, n, bl, bl2, f, bl3, n2, n3, n4, n5, nArray, n6, nArray2, n7, nArray3, dArray, dArray2, fArray);
    }

    native void buildGAForByRef(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, float var7, boolean var8, int var9, int var10, int var11, int var12, float[] var13, double[] var14, int var15, float[] var16, byte[] var17, int var18, float[] var19, int var20, int[] var21, int[] var22, float[][] var23, int var24, int[] var25, int[] var26, int var27, Object[] var28, double[] var29, double[] var30);

    void buildGAForByRef(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, float f, boolean bl3, int n2, int n3, int n4, int n5, float[] fArray, double[] dArray, int n6, float[] fArray2, byte[] byArray, int n7, float[] fArray3, int n8, int[] nArray, int[] nArray2, float[][] fArray4, int n9, int[] nArray3, int[] nArray4, int n10, Object[] objectArray, double[] dArray2, double[] dArray3) {
        this.buildGAForByRef(this.unbox(context), geometryArrayRetained, n, bl, bl2, f, bl3, n2, n3, n4, n5, fArray, dArray, n6, fArray2, byArray, n7, fArray3, n8, nArray, nArray2, fArray4, n9, nArray3, nArray4, n10, objectArray, dArray2, dArray3);
    }

    native void executeIndexedGeometry(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, boolean var7, int var8, int var9, int var10, int var11, int var12, int[] var13, int var14, int[] var15, int var16, int[] var17, int var18, float[] var19, float[] var20, int var21, int[] var22);

    void executeIndexedGeometry(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5, int n6, int[] nArray, int n7, int[] nArray2, int n8, int[] nArray3, int n9, float[] fArray, float[] fArray2, int n10, int[] nArray4) {
        this.executeIndexedGeometry(this.unbox(context), geometryArrayRetained, n, bl, bl2, bl3, n2, n3, n4, n5, n6, nArray, n7, nArray2, n8, nArray3, n9, fArray, fArray2, n10, nArray4);
    }

    native void executeIndexedGeometryBuffer(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, boolean var7, int var8, int var9, int var10, int var11, int var12, int[] var13, int var14, int[] var15, int var16, Object var17, float[] var18, int var19, int[] var20);

    void executeIndexedGeometryBuffer(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5, int n6, int[] nArray, int n7, int[] nArray2, int n8, Object object, float[] fArray, int n9, int[] nArray3) {
        this.executeIndexedGeometryBuffer(this.unbox(context), geometryArrayRetained, n, bl, bl2, bl3, n2, n3, n4, n5, n6, nArray, n7, nArray2, n8, object, fArray, n9, nArray3);
    }

    native void executeIndexedGeometryVA(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int var11, float[] var12, double[] var13, float[] var14, byte[] var15, float[] var16, int var17, int[] var18, float[][] var19, int var20, int[] var21, int var22, int var23, Object[] var24, int var25, int[] var26);

    void executeIndexedGeometryVA(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, int n6, float[] fArray, double[] dArray, float[] fArray2, byte[] byArray, float[] fArray3, int n7, int[] nArray, float[][] fArray4, int n8, int[] nArray2, int n9, int n10, Object[] objectArray, int n11, int[] nArray3) {
        this.executeIndexedGeometryVA(this.unbox(context), geometryArrayRetained, n, bl, bl2, n2, n3, n4, n5, n6, fArray, dArray, fArray2, byArray, fArray3, n7, nArray, fArray4, n8, nArray2, n9, n10, objectArray, n11, nArray3);
    }

    native void executeIndexedGeometryVABuffer(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int var11, Object var12, Object var13, float[] var14, byte[] var15, Object var16, int var17, int[] var18, Object[] var19, int var20, int[] var21, int var22, int var23, Object[] var24, int var25, int[] var26);

    void executeIndexedGeometryVABuffer(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, int n6, Object object, Object object2, float[] fArray, byte[] byArray, Object object3, int n7, int[] nArray, Object[] objectArray, int n8, int[] nArray2, int n9, int n10, Object[] objectArray2, int n11, int[] nArray3) {
        this.executeIndexedGeometryVABuffer(this.unbox(context), geometryArrayRetained, n, bl, bl2, n2, n3, n4, n5, n6, object, object2, fArray, byArray, object3, n7, nArray, objectArray, n8, nArray2, n9, n10, objectArray2, n11, nArray3);
    }

    native void buildIndexedGeometry(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, float var7, boolean var8, int var9, int var10, int var11, int var12, int var13, int[] var14, int var15, int[] var16, int var17, int[] var18, double[] var19, double[] var20, float[] var21, int[] var22);

    void buildIndexedGeometry(Context context, GeometryArrayRetained geometryArrayRetained, int n, boolean bl, boolean bl2, float f, boolean bl3, int n2, int n3, int n4, int n5, int n6, int[] nArray, int n7, int[] nArray2, int n8, int[] nArray3, double[] dArray, double[] dArray2, float[] fArray, int[] nArray4) {
        this.buildIndexedGeometry(this.unbox(context), geometryArrayRetained, n, bl, bl2, f, bl3, n2, n3, n4, n5, n6, nArray, n7, nArray2, n8, nArray3, dArray, dArray2, fArray, nArray4);
    }

    native void readRaster(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, Object var11, int var12, Object var13);

    void readRaster(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object, int n9, Object object2) {
        this.readRaster(this.unbox(context), n, n2, n3, n4, n5, n6, n7, n8, object, n9, object2);
    }

    native ShaderError setCgUniform1i(long var1, long var3, long var5, int var7);

    ShaderError setCgUniform1i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n) {
        return this.setCgUniform1i(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n);
    }

    native ShaderError setCgUniform1f(long var1, long var3, long var5, float var7);

    ShaderError setCgUniform1f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float f) {
        return this.setCgUniform1f(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), f);
    }

    native ShaderError setCgUniform2i(long var1, long var3, long var5, int[] var7);

    ShaderError setCgUniform2i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int[] nArray) {
        return this.setCgUniform2i(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), nArray);
    }

    native ShaderError setCgUniform2f(long var1, long var3, long var5, float[] var7);

    ShaderError setCgUniform2f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        return this.setCgUniform2f(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), fArray);
    }

    native ShaderError setCgUniform3i(long var1, long var3, long var5, int[] var7);

    ShaderError setCgUniform3i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int[] nArray) {
        return this.setCgUniform3i(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), nArray);
    }

    native ShaderError setCgUniform3f(long var1, long var3, long var5, float[] var7);

    ShaderError setCgUniform3f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        return this.setCgUniform3f(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), fArray);
    }

    native ShaderError setCgUniform4i(long var1, long var3, long var5, int[] var7);

    ShaderError setCgUniform4i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int[] nArray) {
        return this.setCgUniform4i(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), nArray);
    }

    native ShaderError setCgUniform4f(long var1, long var3, long var5, float[] var7);

    ShaderError setCgUniform4f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        return this.setCgUniform4f(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), fArray);
    }

    native ShaderError setCgUniformMatrix3f(long var1, long var3, long var5, float[] var7);

    ShaderError setCgUniformMatrix3f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        return this.setCgUniformMatrix3f(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), fArray);
    }

    native ShaderError setCgUniformMatrix4f(long var1, long var3, long var5, float[] var7);

    ShaderError setCgUniformMatrix4f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        return this.setCgUniformMatrix4f(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), fArray);
    }

    native ShaderError setCgUniform1iArray(long var1, long var3, long var5, int var7, int[] var8);

    ShaderError setCgUniform1iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, int[] nArray) {
        return this.setCgUniform1iArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, nArray);
    }

    native ShaderError setCgUniform1fArray(long var1, long var3, long var5, int var7, float[] var8);

    ShaderError setCgUniform1fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        return this.setCgUniform1fArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, fArray);
    }

    native ShaderError setCgUniform2iArray(long var1, long var3, long var5, int var7, int[] var8);

    ShaderError setCgUniform2iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, int[] nArray) {
        return this.setCgUniform2iArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, nArray);
    }

    native ShaderError setCgUniform2fArray(long var1, long var3, long var5, int var7, float[] var8);

    ShaderError setCgUniform2fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        return this.setCgUniform2fArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, fArray);
    }

    native ShaderError setCgUniform3iArray(long var1, long var3, long var5, int var7, int[] var8);

    ShaderError setCgUniform3iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, int[] nArray) {
        return this.setCgUniform3iArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, nArray);
    }

    native ShaderError setCgUniform3fArray(long var1, long var3, long var5, int var7, float[] var8);

    ShaderError setCgUniform3fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        return this.setCgUniform3fArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, fArray);
    }

    native ShaderError setCgUniform4iArray(long var1, long var3, long var5, int var7, int[] var8);

    ShaderError setCgUniform4iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, int[] nArray) {
        return this.setCgUniform4iArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, nArray);
    }

    native ShaderError setCgUniform4fArray(long var1, long var3, long var5, int var7, float[] var8);

    ShaderError setCgUniform4fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        return this.setCgUniform4fArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, fArray);
    }

    native ShaderError setCgUniformMatrix3fArray(long var1, long var3, long var5, int var7, float[] var8);

    ShaderError setCgUniformMatrix3fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        return this.setCgUniformMatrix3fArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, fArray);
    }

    native ShaderError setCgUniformMatrix4fArray(long var1, long var3, long var5, int var7, float[] var8);

    ShaderError setCgUniformMatrix4fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        return this.setCgUniformMatrix4fArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, fArray);
    }

    native ShaderError createCgShader(long var1, int var3, long[] var4);

    ShaderError createCgShader(Context context, int n, ShaderId[] shaderIdArray) {
        long[] lArray = new long[1];
        ShaderError shaderError = this.createCgShader(this.unbox(context), n, lArray);
        shaderIdArray[0] = this.boxShaderId(lArray[0]);
        return shaderError;
    }

    native ShaderError destroyCgShader(long var1, long var3);

    ShaderError destroyCgShader(Context context, ShaderId shaderId) {
        return this.destroyCgShader(this.unbox(context), this.unbox(shaderId));
    }

    native ShaderError compileCgShader(long var1, long var3, String var5);

    ShaderError compileCgShader(Context context, ShaderId shaderId, String string) {
        return this.compileCgShader(this.unbox(context), this.unbox(shaderId), string);
    }

    native ShaderError createCgShaderProgram(long var1, long[] var3);

    ShaderError createCgShaderProgram(Context context, ShaderProgramId[] shaderProgramIdArray) {
        long[] lArray = new long[1];
        ShaderError shaderError = this.createCgShaderProgram(this.unbox(context), lArray);
        shaderProgramIdArray[0] = this.boxShaderProgramId(lArray[0]);
        return shaderError;
    }

    native ShaderError destroyCgShaderProgram(long var1, long var3);

    ShaderError destroyCgShaderProgram(Context context, ShaderProgramId shaderProgramId) {
        return this.destroyCgShaderProgram(this.unbox(context), this.unbox(shaderProgramId));
    }

    native ShaderError linkCgShaderProgram(long var1, long var3, long[] var5);

    ShaderError linkCgShaderProgram(Context context, ShaderProgramId shaderProgramId, ShaderId[] shaderIdArray) {
        assert (shaderIdArray != null);
        long[] lArray = new long[shaderIdArray.length];
        for (int i = 0; i < shaderIdArray.length; ++i) {
            lArray[i] = this.unbox(shaderIdArray[i]);
        }
        return this.linkCgShaderProgram(this.unbox(context), this.unbox(shaderProgramId), lArray);
    }

    native void lookupCgVertexAttrNames(long var1, long var3, int var5, String[] var6, boolean[] var7);

    void lookupCgVertexAttrNames(Context context, ShaderProgramId shaderProgramId, int n, String[] stringArray, boolean[] blArray) {
        this.lookupCgVertexAttrNames(this.unbox(context), this.unbox(shaderProgramId), n, stringArray, blArray);
    }

    native void lookupCgShaderAttrNames(long var1, long var3, int var5, String[] var6, long[] var7, int[] var8, int[] var9, boolean[] var10);

    void lookupCgShaderAttrNames(Context context, ShaderProgramId shaderProgramId, int n, String[] stringArray, ShaderAttrLoc[] shaderAttrLocArray, int[] nArray, int[] nArray2, boolean[] blArray) {
        int n2;
        assert (n == shaderAttrLocArray.length);
        long[] lArray = new long[n];
        for (n2 = 0; n2 < n; ++n2) {
            lArray[n2] = -1L;
        }
        this.lookupCgShaderAttrNames(this.unbox(context), this.unbox(shaderProgramId), n, stringArray, lArray, nArray, nArray2, blArray);
        for (n2 = 0; n2 < n; ++n2) {
            shaderAttrLocArray[n2] = this.boxShaderAttrLoc(lArray[n2]);
        }
    }

    native ShaderError useCgShaderProgram(long var1, long var3);

    ShaderError useCgShaderProgram(Context context, ShaderProgramId shaderProgramId) {
        return this.useCgShaderProgram(this.unbox(context), this.unbox(shaderProgramId));
    }

    native ShaderError setGLSLUniform1i(long var1, long var3, long var5, int var7);

    ShaderError setGLSLUniform1i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n) {
        return this.setGLSLUniform1i(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n);
    }

    native ShaderError setGLSLUniform1f(long var1, long var3, long var5, float var7);

    ShaderError setGLSLUniform1f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float f) {
        return this.setGLSLUniform1f(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), f);
    }

    native ShaderError setGLSLUniform2i(long var1, long var3, long var5, int[] var7);

    ShaderError setGLSLUniform2i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int[] nArray) {
        return this.setGLSLUniform2i(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), nArray);
    }

    native ShaderError setGLSLUniform2f(long var1, long var3, long var5, float[] var7);

    ShaderError setGLSLUniform2f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        return this.setGLSLUniform2f(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), fArray);
    }

    native ShaderError setGLSLUniform3i(long var1, long var3, long var5, int[] var7);

    ShaderError setGLSLUniform3i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int[] nArray) {
        return this.setGLSLUniform3i(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), nArray);
    }

    native ShaderError setGLSLUniform3f(long var1, long var3, long var5, float[] var7);

    ShaderError setGLSLUniform3f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        return this.setGLSLUniform3f(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), fArray);
    }

    native ShaderError setGLSLUniform4i(long var1, long var3, long var5, int[] var7);

    ShaderError setGLSLUniform4i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int[] nArray) {
        return this.setGLSLUniform4i(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), nArray);
    }

    native ShaderError setGLSLUniform4f(long var1, long var3, long var5, float[] var7);

    ShaderError setGLSLUniform4f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        return this.setGLSLUniform4f(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), fArray);
    }

    native ShaderError setGLSLUniformMatrix3f(long var1, long var3, long var5, float[] var7);

    ShaderError setGLSLUniformMatrix3f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        return this.setGLSLUniformMatrix3f(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), fArray);
    }

    native ShaderError setGLSLUniformMatrix4f(long var1, long var3, long var5, float[] var7);

    ShaderError setGLSLUniformMatrix4f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        return this.setGLSLUniformMatrix4f(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), fArray);
    }

    native ShaderError setGLSLUniform1iArray(long var1, long var3, long var5, int var7, int[] var8);

    ShaderError setGLSLUniform1iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, int[] nArray) {
        return this.setGLSLUniform1iArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, nArray);
    }

    native ShaderError setGLSLUniform1fArray(long var1, long var3, long var5, int var7, float[] var8);

    ShaderError setGLSLUniform1fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        return this.setGLSLUniform1fArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, fArray);
    }

    native ShaderError setGLSLUniform2iArray(long var1, long var3, long var5, int var7, int[] var8);

    ShaderError setGLSLUniform2iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, int[] nArray) {
        return this.setGLSLUniform2iArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, nArray);
    }

    native ShaderError setGLSLUniform2fArray(long var1, long var3, long var5, int var7, float[] var8);

    ShaderError setGLSLUniform2fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        return this.setGLSLUniform2fArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, fArray);
    }

    native ShaderError setGLSLUniform3iArray(long var1, long var3, long var5, int var7, int[] var8);

    ShaderError setGLSLUniform3iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, int[] nArray) {
        return this.setGLSLUniform3iArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, nArray);
    }

    native ShaderError setGLSLUniform3fArray(long var1, long var3, long var5, int var7, float[] var8);

    ShaderError setGLSLUniform3fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        return this.setGLSLUniform3fArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, fArray);
    }

    native ShaderError setGLSLUniform4iArray(long var1, long var3, long var5, int var7, int[] var8);

    ShaderError setGLSLUniform4iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, int[] nArray) {
        return this.setGLSLUniform4iArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, nArray);
    }

    native ShaderError setGLSLUniform4fArray(long var1, long var3, long var5, int var7, float[] var8);

    ShaderError setGLSLUniform4fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        return this.setGLSLUniform4fArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, fArray);
    }

    native ShaderError setGLSLUniformMatrix3fArray(long var1, long var3, long var5, int var7, float[] var8);

    ShaderError setGLSLUniformMatrix3fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        return this.setGLSLUniformMatrix3fArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, fArray);
    }

    native ShaderError setGLSLUniformMatrix4fArray(long var1, long var3, long var5, int var7, float[] var8);

    ShaderError setGLSLUniformMatrix4fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n, float[] fArray) {
        return this.setGLSLUniformMatrix4fArray(this.unbox(context), this.unbox(shaderProgramId), this.unbox(shaderAttrLoc), n, fArray);
    }

    native ShaderError createGLSLShader(long var1, int var3, long[] var4);

    ShaderError createGLSLShader(Context context, int n, ShaderId[] shaderIdArray) {
        long[] lArray = new long[1];
        ShaderError shaderError = this.createGLSLShader(this.unbox(context), n, lArray);
        shaderIdArray[0] = this.boxShaderId(lArray[0]);
        return shaderError;
    }

    native ShaderError destroyGLSLShader(long var1, long var3);

    ShaderError destroyGLSLShader(Context context, ShaderId shaderId) {
        return this.destroyGLSLShader(this.unbox(context), this.unbox(shaderId));
    }

    native ShaderError compileGLSLShader(long var1, long var3, String var5);

    ShaderError compileGLSLShader(Context context, ShaderId shaderId, String string) {
        return this.compileGLSLShader(this.unbox(context), this.unbox(shaderId), string);
    }

    native ShaderError createGLSLShaderProgram(long var1, long[] var3);

    ShaderError createGLSLShaderProgram(Context context, ShaderProgramId[] shaderProgramIdArray) {
        long[] lArray = new long[1];
        ShaderError shaderError = this.createGLSLShaderProgram(this.unbox(context), lArray);
        shaderProgramIdArray[0] = this.boxShaderProgramId(lArray[0]);
        return shaderError;
    }

    native ShaderError destroyGLSLShaderProgram(long var1, long var3);

    ShaderError destroyGLSLShaderProgram(Context context, ShaderProgramId shaderProgramId) {
        return this.destroyGLSLShaderProgram(this.unbox(context), this.unbox(shaderProgramId));
    }

    native ShaderError linkGLSLShaderProgram(long var1, long var3, long[] var5);

    ShaderError linkGLSLShaderProgram(Context context, ShaderProgramId shaderProgramId, ShaderId[] shaderIdArray) {
        assert (shaderIdArray != null);
        long[] lArray = new long[shaderIdArray.length];
        for (int i = 0; i < shaderIdArray.length; ++i) {
            lArray[i] = this.unbox(shaderIdArray[i]);
        }
        return this.linkGLSLShaderProgram(this.unbox(context), this.unbox(shaderProgramId), lArray);
    }

    native ShaderError bindGLSLVertexAttrName(long var1, long var3, String var5, int var6);

    ShaderError bindGLSLVertexAttrName(Context context, ShaderProgramId shaderProgramId, String string, int n) {
        return this.bindGLSLVertexAttrName(this.unbox(context), this.unbox(shaderProgramId), string, n);
    }

    native void lookupGLSLShaderAttrNames(long var1, long var3, int var5, String[] var6, long[] var7, int[] var8, int[] var9, boolean[] var10);

    void lookupGLSLShaderAttrNames(Context context, ShaderProgramId shaderProgramId, int n, String[] stringArray, ShaderAttrLoc[] shaderAttrLocArray, int[] nArray, int[] nArray2, boolean[] blArray) {
        int n2;
        assert (n == shaderAttrLocArray.length);
        long[] lArray = new long[n];
        for (n2 = 0; n2 < n; ++n2) {
            lArray[n2] = -1L;
        }
        this.lookupGLSLShaderAttrNames(this.unbox(context), this.unbox(shaderProgramId), n, stringArray, lArray, nArray, nArray2, blArray);
        for (n2 = 0; n2 < n; ++n2) {
            shaderAttrLocArray[n2] = this.boxShaderAttrLoc(lArray[n2]);
        }
    }

    native ShaderError useGLSLShaderProgram(long var1, long var3);

    ShaderError useGLSLShaderProgram(Context context, ShaderProgramId shaderProgramId) {
        return this.useGLSLShaderProgram(this.unbox(context), this.unbox(shaderProgramId));
    }

    native void cleanupRenderer();

    native void updateColoringAttributes(long var1, float var3, float var4, float var5, float var6, float var7, float var8, float var9, boolean var10, int var11);

    void updateColoringAttributes(Context context, float f, float f2, float f3, float f4, float f5, float f6, float f7, boolean bl, int n) {
        this.updateColoringAttributes(this.unbox(context), f, f2, f3, f4, f5, f6, f7, bl, n);
    }

    native void updateDirectionalLight(long var1, int var3, float var4, float var5, float var6, float var7, float var8, float var9);

    void updateDirectionalLight(Context context, int n, float f, float f2, float f3, float f4, float f5, float f6) {
        this.updateDirectionalLight(this.unbox(context), n, f, f2, f3, f4, f5, f6);
    }

    native void updatePointLight(long var1, int var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12);

    void updatePointLight(Context context, int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.updatePointLight(this.unbox(context), n, f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    native void updateSpotLight(long var1, int var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17);

    void updateSpotLight(Context context, int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14) {
        this.updateSpotLight(this.unbox(context), n, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14);
    }

    native void updateExponentialFog(long var1, float var3, float var4, float var5, float var6);

    void updateExponentialFog(Context context, float f, float f2, float f3, float f4) {
        this.updateExponentialFog(this.unbox(context), f, f2, f3, f4);
    }

    native void updateLinearFog(long var1, float var3, float var4, float var5, double var6, double var8);

    void updateLinearFog(Context context, float f, float f2, float f3, double d, double d2) {
        this.updateLinearFog(this.unbox(context), f, f2, f3, d, d2);
    }

    native void updateLineAttributes(long var1, float var3, int var4, int var5, int var6, boolean var7);

    void updateLineAttributes(Context context, float f, int n, int n2, int n3, boolean bl) {
        this.updateLineAttributes(this.unbox(context), f, n, n2, n3, bl);
    }

    native void updateMaterial(long var1, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, int var20, boolean var21);

    void updateMaterial(Context context, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, int n, boolean bl) {
        this.updateMaterial(this.unbox(context), f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, n, bl);
    }

    native void updateModelClip(long var1, int var3, boolean var4, double var5, double var7, double var9, double var11);

    void updateModelClip(Context context, int n, boolean bl, double d, double d2, double d3, double d4) {
        this.updateModelClip(this.unbox(context), n, bl, d, d2, d3, d4);
    }

    native void updatePointAttributes(long var1, float var3, boolean var4);

    void updatePointAttributes(Context context, float f, boolean bl) {
        this.updatePointAttributes(this.unbox(context), f, bl);
    }

    native void updatePolygonAttributes(long var1, int var3, int var4, boolean var5, float var6, float var7);

    void updatePolygonAttributes(Context context, int n, int n2, boolean bl, float f, float f2) {
        this.updatePolygonAttributes(this.unbox(context), n, n2, bl, f, f2);
    }

    native void updateRenderingAttributes(long var1, boolean var3, boolean var4, boolean var5, boolean var6, int var7, float var8, int var9, boolean var10, boolean var11, int var12, boolean var13, boolean var14, int var15, int var16, int var17, int var18, int var19, int var20, int var21);

    void updateRenderingAttributes(Context context, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, float f, int n2, boolean bl5, boolean bl6, int n3, boolean bl7, boolean bl8, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.updateRenderingAttributes(this.unbox(context), bl, bl2, bl3, bl4, n, f, n2, bl5, bl6, n3, bl7, bl8, n4, n5, n6, n7, n8, n9, n10);
    }

    native void updateTexCoordGeneration(long var1, boolean var3, int var4, int var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20, float var21, double[] var22);

    void updateTexCoordGeneration(Context context, boolean bl, int n, int n2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, double[] dArray) {
        this.updateTexCoordGeneration(this.unbox(context), bl, n, n2, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, dArray);
    }

    native void updateTransparencyAttributes(long var1, float var3, int var4, int var5, boolean var6, boolean var7, int var8, int var9, int var10);

    void updateTransparencyAttributes(Context context, float f, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5) {
        this.updateTransparencyAttributes(this.unbox(context), f, n, n2, bl, bl2, n3, n4, n5);
    }

    native void updateTextureAttributes(long var1, double[] var3, boolean var4, int var5, int var6, float var7, float var8, float var9, float var10, int var11);

    void updateTextureAttributes(Context context, double[] dArray, boolean bl, int n, int n2, float f, float f2, float f3, float f4, int n3) {
        this.updateTextureAttributes(this.unbox(context), dArray, bl, n, n2, f, f2, f3, f4, n3);
    }

    native void updateRegisterCombiners(long var1, double[] var3, boolean var4, int var5, int var6, float var7, float var8, float var9, float var10, int var11, int var12, int var13, int[] var14, int[] var15, int[] var16, int[] var17, int var18, int var19);

    void updateRegisterCombiners(Context context, double[] dArray, boolean bl, int n, int n2, float f, float f2, float f3, float f4, int n3, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n6, int n7) {
        this.updateRegisterCombiners(this.unbox(context), dArray, bl, n, n2, f, f2, f3, f4, n3, n4, n5, nArray, nArray2, nArray3, nArray4, n6, n7);
    }

    native void updateTextureColorTable(long var1, int var3, int var4, int[] var5);

    void updateTextureColorTable(Context context, int n, int n2, int[] nArray) {
        this.updateTextureColorTable(this.unbox(context), n, n2, nArray);
    }

    native void updateCombiner(long var1, int var3, int var4, int[] var5, int[] var6, int[] var7, int[] var8, int var9, int var10);

    void updateCombiner(Context context, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n3, int n4) {
        this.updateCombiner(this.unbox(context), n, n2, nArray, nArray2, nArray3, nArray4, n3, n4);
    }

    native void updateTextureUnitState(long var1, int var3, boolean var4);

    void updateTextureUnitState(Context context, int n, boolean bl) {
        this.updateTextureUnitState(this.unbox(context), n, bl);
    }

    native void bindTexture2D(long var1, int var3, boolean var4);

    void bindTexture2D(Context context, int n, boolean bl) {
        this.bindTexture2D(this.unbox(context), n, bl);
    }

    native void updateTexture2DImage(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, Object var11, boolean var12);

    void updateTexture2DImage(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object, boolean bl) {
        this.updateTexture2DImage(this.unbox(context), n, n2, n3, n4, n5, n6, n7, n8, object, bl);
    }

    native void updateTexture2DSubImage(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, Object var14, boolean var15);

    void updateTexture2DSubImage(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, Object object, boolean bl) {
        this.updateTexture2DSubImage(this.unbox(context), n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, object, bl);
    }

    native void updateTexture2DLodRange(long var1, int var3, int var4, float var5, float var6);

    void updateTexture2DLodRange(Context context, int n, int n2, float f, float f2) {
        this.updateTexture2DLodRange(this.unbox(context), n, n2, f, f2);
    }

    native void updateTexture2DLodOffset(long var1, float var3, float var4, float var5);

    void updateTexture2DLodOffset(Context context, float f, float f2, float f3) {
        this.updateTexture2DLodOffset(this.unbox(context), f, f2, f3);
    }

    native void updateTexture2DBoundary(long var1, int var3, int var4, float var5, float var6, float var7, float var8);

    void updateTexture2DBoundary(Context context, int n, int n2, float f, float f2, float f3, float f4) {
        this.updateTexture2DBoundary(this.unbox(context), n, n2, f, f2, f3, f4);
    }

    native void updateTexture2DFilterModes(long var1, int var3, int var4);

    void updateTexture2DFilterModes(Context context, int n, int n2) {
        this.updateTexture2DFilterModes(this.unbox(context), n, n2);
    }

    native void updateTexture2DSharpenFunc(long var1, int var3, float[] var4);

    void updateTexture2DSharpenFunc(Context context, int n, float[] fArray) {
        this.updateTexture2DSharpenFunc(this.unbox(context), n, fArray);
    }

    native void updateTexture2DFilter4Func(long var1, int var3, float[] var4);

    void updateTexture2DFilter4Func(Context context, int n, float[] fArray) {
        this.updateTexture2DFilter4Func(this.unbox(context), n, fArray);
    }

    native void updateTexture2DAnisotropicFilter(long var1, float var3);

    void updateTexture2DAnisotropicFilter(Context context, float f) {
        this.updateTexture2DAnisotropicFilter(this.unbox(context), f);
    }

    native void bindTexture3D(long var1, int var3, boolean var4);

    void bindTexture3D(Context context, int n, boolean bl) {
        this.bindTexture3D(this.unbox(context), n, bl);
    }

    native void updateTexture3DImage(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, Object var12, boolean var13);

    void updateTexture3DImage(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object, boolean bl) {
        this.updateTexture3DImage(this.unbox(context), n, n2, n3, n4, n5, n6, n7, n8, n9, object, bl);
    }

    native void updateTexture3DSubImage(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, Object var18, boolean var19);

    void updateTexture3DSubImage(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, Object object, boolean bl) {
        this.updateTexture3DSubImage(this.unbox(context), n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, object, bl);
    }

    native void updateTexture3DLodRange(long var1, int var3, int var4, float var5, float var6);

    void updateTexture3DLodRange(Context context, int n, int n2, float f, float f2) {
        this.updateTexture3DLodRange(this.unbox(context), n, n2, f, f2);
    }

    native void updateTexture3DLodOffset(long var1, float var3, float var4, float var5);

    void updateTexture3DLodOffset(Context context, float f, float f2, float f3) {
        this.updateTexture3DLodOffset(this.unbox(context), f, f2, f3);
    }

    native void updateTexture3DBoundary(long var1, int var3, int var4, int var5, float var6, float var7, float var8, float var9);

    void updateTexture3DBoundary(Context context, int n, int n2, int n3, float f, float f2, float f3, float f4) {
        this.updateTexture3DBoundary(this.unbox(context), n, n2, n3, f, f2, f3, f4);
    }

    native void updateTexture3DFilterModes(long var1, int var3, int var4);

    void updateTexture3DFilterModes(Context context, int n, int n2) {
        this.updateTexture3DFilterModes(this.unbox(context), n, n2);
    }

    native void updateTexture3DSharpenFunc(long var1, int var3, float[] var4);

    void updateTexture3DSharpenFunc(Context context, int n, float[] fArray) {
        this.updateTexture3DSharpenFunc(this.unbox(context), n, fArray);
    }

    native void updateTexture3DFilter4Func(long var1, int var3, float[] var4);

    void updateTexture3DFilter4Func(Context context, int n, float[] fArray) {
        this.updateTexture3DFilter4Func(this.unbox(context), n, fArray);
    }

    native void updateTexture3DAnisotropicFilter(long var1, float var3);

    void updateTexture3DAnisotropicFilter(Context context, float f) {
        this.updateTexture3DAnisotropicFilter(this.unbox(context), f);
    }

    native void bindTextureCubeMap(long var1, int var3, boolean var4);

    void bindTextureCubeMap(Context context, int n, boolean bl) {
        this.bindTextureCubeMap(this.unbox(context), n, bl);
    }

    native void updateTextureCubeMapImage(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, Object var12, boolean var13);

    void updateTextureCubeMapImage(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object, boolean bl) {
        this.updateTextureCubeMapImage(this.unbox(context), n, n2, n3, n4, n5, n6, n7, n8, n9, object, bl);
    }

    native void updateTextureCubeMapSubImage(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, Object var15, boolean var16);

    void updateTextureCubeMapSubImage(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, Object object, boolean bl) {
        this.updateTextureCubeMapSubImage(this.unbox(context), n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, object, bl);
    }

    native void updateTextureCubeMapLodRange(long var1, int var3, int var4, float var5, float var6);

    void updateTextureCubeMapLodRange(Context context, int n, int n2, float f, float f2) {
        this.updateTextureCubeMapLodRange(this.unbox(context), n, n2, f, f2);
    }

    native void updateTextureCubeMapLodOffset(long var1, float var3, float var4, float var5);

    void updateTextureCubeMapLodOffset(Context context, float f, float f2, float f3) {
        this.updateTextureCubeMapLodOffset(this.unbox(context), f, f2, f3);
    }

    native void updateTextureCubeMapBoundary(long var1, int var3, int var4, float var5, float var6, float var7, float var8);

    void updateTextureCubeMapBoundary(Context context, int n, int n2, float f, float f2, float f3, float f4) {
        this.updateTextureCubeMapBoundary(this.unbox(context), n, n2, f, f2, f3, f4);
    }

    native void updateTextureCubeMapFilterModes(long var1, int var3, int var4);

    void updateTextureCubeMapFilterModes(Context context, int n, int n2) {
        this.updateTextureCubeMapFilterModes(this.unbox(context), n, n2);
    }

    native void updateTextureCubeMapSharpenFunc(long var1, int var3, float[] var4);

    void updateTextureCubeMapSharpenFunc(Context context, int n, float[] fArray) {
        this.updateTextureCubeMapSharpenFunc(this.unbox(context), n, fArray);
    }

    native void updateTextureCubeMapFilter4Func(long var1, int var3, float[] var4);

    void updateTextureCubeMapFilter4Func(Context context, int n, float[] fArray) {
        this.updateTextureCubeMapFilter4Func(this.unbox(context), n, fArray);
    }

    native void updateTextureCubeMapAnisotropicFilter(long var1, float var3);

    void updateTextureCubeMapAnisotropicFilter(Context context, float f) {
        this.updateTextureCubeMapAnisotropicFilter(this.unbox(context), f);
    }

    native long getAWT();

    native boolean initializeJ3D(boolean var1);

    native int getMaximumLights();

    native long createNewContext(Canvas3D var1, long var2, long var4, long var6, long var8, boolean var10, boolean var11, boolean var12, boolean var13);

    Context createNewContext(Canvas3D canvas3D, long l, Drawable drawable, long l2, Context context, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        long l3 = this.createNewContext(canvas3D, l, this.unbox(drawable), l2, this.unbox(context), bl, bl2, bl3, bl4);
        return this.boxContext(l3);
    }

    native void createQueryContext(Canvas3D var1, long var2, long var4, long var6, boolean var8, int var9, int var10, boolean var11, boolean var12);

    void createQueryContext(Canvas3D canvas3D, long l, Drawable drawable, long l2, boolean bl, int n, int n2, boolean bl2, boolean bl3) {
        this.createQueryContext(canvas3D, l, this.unbox(drawable), l2, bl, n, n2, bl2, bl3);
    }

    native long createOffScreenBuffer(Canvas3D var1, long var2, long var4, long var6, int var8, int var9);

    Drawable createOffScreenBuffer(Canvas3D canvas3D, Context context, long l, long l2, int n, int n2) {
        long l3 = this.createOffScreenBuffer(canvas3D, this.unbox(context), l, l2, n, n2);
        return this.boxDrawable(l3);
    }

    native void destroyOffScreenBuffer(Canvas3D var1, long var2, long var4, long var6, long var8);

    void destroyOffScreenBuffer(Canvas3D canvas3D, Context context, long l, long l2, Drawable drawable) {
        this.destroyOffScreenBuffer(canvas3D, this.unbox(context), l, l2, this.unbox(drawable));
    }

    native void readOffScreenBuffer(Canvas3D var1, long var2, int var4, int var5, Object var6, int var7, int var8);

    void readOffScreenBuffer(Canvas3D canvas3D, Context context, int n, int n2, Object object, int n3, int n4) {
        this.readOffScreenBuffer(canvas3D, this.unbox(context), n, n2, object, n3, n4);
    }

    native int swapBuffers(Canvas3D var1, long var2, long var4, long var6);

    int swapBuffers(Canvas3D canvas3D, Context context, long l, Drawable drawable) {
        return this.swapBuffers(canvas3D, this.unbox(context), l, this.unbox(drawable));
    }

    native int resizeD3DCanvas(Canvas3D var1, long var2);

    int resizeD3DCanvas(Canvas3D canvas3D, Context context) {
        return this.resizeD3DCanvas(canvas3D, this.unbox(context));
    }

    native int toggleFullScreenMode(Canvas3D var1, long var2);

    int toggleFullScreenMode(Canvas3D canvas3D, Context context) {
        return this.toggleFullScreenMode(canvas3D, this.unbox(context));
    }

    native void updateMaterialColor(long var1, float var3, float var4, float var5, float var6);

    void updateMaterialColor(Context context, float f, float f2, float f3, float f4) {
        this.updateMaterialColor(this.unbox(context), f, f2, f3, f4);
    }

    native void destroyContext(long var1, long var3, long var5);

    void destroyContext(long l, Drawable drawable, Context context) {
        if (!$assertionsDisabled && l == 0L) {
            if (!VirtualUniverse.mc.isWindows()) {
                throw new AssertionError();
            }
        }
        assert (context != null);
        assert (drawable != null);
        this.destroyContext(l, this.unbox(drawable), this.unbox(context));
    }

    native void accum(long var1, float var3);

    void accum(Context context, float f) {
        this.accum(this.unbox(context), f);
    }

    native void accumReturn(long var1);

    void accumReturn(Context context) {
        this.accumReturn(this.unbox(context));
    }

    native void clearAccum(long var1);

    void clearAccum(Context context) {
        this.clearAccum(this.unbox(context));
    }

    native int getNumCtxLights(long var1);

    int getNumCtxLights(Context context) {
        return this.getNumCtxLights(this.unbox(context));
    }

    native boolean decal1stChildSetup(long var1);

    boolean decal1stChildSetup(Context context) {
        return this.decal1stChildSetup(this.unbox(context));
    }

    native void decalNthChildSetup(long var1);

    void decalNthChildSetup(Context context) {
        this.decalNthChildSetup(this.unbox(context));
    }

    native void decalReset(long var1, boolean var3);

    void decalReset(Context context, boolean bl) {
        this.decalReset(this.unbox(context), bl);
    }

    native void ctxUpdateEyeLightingEnable(long var1, boolean var3);

    void ctxUpdateEyeLightingEnable(Context context, boolean bl) {
        this.ctxUpdateEyeLightingEnable(this.unbox(context), bl);
    }

    native void setBlendColor(long var1, float var3, float var4, float var5, float var6);

    void setBlendColor(Context context, float f, float f2, float f3, float f4) {
        this.setBlendColor(this.unbox(context), f, f2, f3, f4);
    }

    native void setBlendFunc(long var1, int var3, int var4);

    void setBlendFunc(Context context, int n, int n2) {
        this.setBlendFunc(this.unbox(context), n, n2);
    }

    native void setFogEnableFlag(long var1, boolean var3);

    void setFogEnableFlag(Context context, boolean bl) {
        this.setFogEnableFlag(this.unbox(context), bl);
    }

    native void setFullSceneAntialiasing(long var1, boolean var3);

    void setFullSceneAntialiasing(Context context, boolean bl) {
        this.setFullSceneAntialiasing(this.unbox(context), bl);
    }

    native void setGlobalAlpha(long var1, float var3);

    void setGlobalAlpha(Context context, float f) {
        this.setGlobalAlpha(this.unbox(context), f);
    }

    native void updateSeparateSpecularColorEnable(long var1, boolean var3);

    void updateSeparateSpecularColorEnable(Context context, boolean bl) {
        this.updateSeparateSpecularColorEnable(this.unbox(context), bl);
    }

    native void beginScene(long var1);

    void beginScene(Context context) {
        this.beginScene(this.unbox(context));
    }

    native void endScene(long var1);

    void endScene(Context context) {
        this.endScene(this.unbox(context));
    }

    native boolean validGraphicsMode();

    native void setLightEnables(long var1, long var3, int var5);

    void setLightEnables(Context context, long l, int n) {
        this.setLightEnables(this.unbox(context), l, n);
    }

    native void setSceneAmbient(long var1, float var3, float var4, float var5);

    void setSceneAmbient(Context context, float f, float f2, float f3) {
        this.setSceneAmbient(this.unbox(context), f, f2, f3);
    }

    native void disableFog(long var1);

    void disableFog(Context context) {
        this.disableFog(this.unbox(context));
    }

    native void disableModelClip(long var1);

    void disableModelClip(Context context) {
        this.disableModelClip(this.unbox(context));
    }

    native void resetRenderingAttributes(long var1, boolean var3, boolean var4);

    void resetRenderingAttributes(Context context, boolean bl, boolean bl2) {
        this.resetRenderingAttributes(this.unbox(context), bl, bl2);
    }

    native void resetTextureNative(long var1, int var3);

    void resetTextureNative(Context context, int n) {
        this.resetTextureNative(this.unbox(context), n);
    }

    native void activeTextureUnit(long var1, int var3);

    void activeTextureUnit(Context context, int n) {
        this.activeTextureUnit(this.unbox(context), n);
    }

    native void resetTexCoordGeneration(long var1);

    void resetTexCoordGeneration(Context context) {
        this.resetTexCoordGeneration(this.unbox(context));
    }

    native void resetTextureAttributes(long var1);

    void resetTextureAttributes(Context context) {
        this.resetTextureAttributes(this.unbox(context));
    }

    native void resetPolygonAttributes(long var1);

    void resetPolygonAttributes(Context context) {
        this.resetPolygonAttributes(this.unbox(context));
    }

    native void resetLineAttributes(long var1);

    void resetLineAttributes(Context context) {
        this.resetLineAttributes(this.unbox(context));
    }

    native void resetPointAttributes(long var1);

    void resetPointAttributes(Context context) {
        this.resetPointAttributes(this.unbox(context));
    }

    native void resetTransparency(long var1, int var3, int var4, boolean var5, boolean var6);

    void resetTransparency(Context context, int n, int n2, boolean bl, boolean bl2) {
        this.resetTransparency(this.unbox(context), n, n2, bl, bl2);
    }

    native void resetColoringAttributes(long var1, float var3, float var4, float var5, float var6, boolean var7);

    void resetColoringAttributes(Context context, float f, float f2, float f3, float f4, boolean bl) {
        this.resetColoringAttributes(this.unbox(context), f, f2, f3, f4, bl);
    }

    native void syncRender(long var1, boolean var3);

    void syncRender(Context context, boolean bl) {
        this.syncRender(this.unbox(context), bl);
    }

    native boolean useCtx(long var1, long var3, long var5);

    boolean useCtx(Context context, long l, Drawable drawable) {
        if (!$assertionsDisabled && l == 0L) {
            if (!VirtualUniverse.mc.isWindows()) {
                throw new AssertionError();
            }
        }
        return this.useCtx(this.unbox(context), l, this.unbox(drawable));
    }

    native void clear(long var1, float var3, float var4, float var5, boolean var6);

    void clear(Context context, float f, float f2, float f3, boolean bl) {
        this.clear(this.unbox(context), f, f2, f3, bl);
    }

    native void textureFillBackground(long var1, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, boolean var11);

    void textureFillBackground(Context context, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, boolean bl) {
        this.textureFillBackground(this.unbox(context), f, f2, f3, f4, f5, f6, f7, f8, bl);
    }

    native void textureFillRaster(long var1, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, boolean var13);

    void textureFillRaster(Context context, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, boolean bl) {
        this.textureFillRaster(this.unbox(context), f, f2, f3, f4, f5, f6, f7, f8, f9, f10, bl);
    }

    native void executeRasterDepth(long var1, float var3, float var4, float var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, Object var13);

    void executeRasterDepth(Context context, float f, float f2, float f3, int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
        this.executeRasterDepth(this.unbox(context), f, f2, f3, n, n2, n3, n4, n5, n6, n7, object);
    }

    native void setModelViewMatrix(long var1, double[] var3, double[] var4);

    void setModelViewMatrix(Context context, double[] dArray, double[] dArray2) {
        this.setModelViewMatrix(this.unbox(context), dArray, dArray2);
    }

    native void setProjectionMatrix(long var1, double[] var3);

    void setProjectionMatrix(Context context, double[] dArray) {
        this.setProjectionMatrix(this.unbox(context), dArray);
    }

    native void setViewport(long var1, int var3, int var4, int var5, int var6);

    void setViewport(Context context, int n, int n2, int n3, int n4) {
        this.setViewport(this.unbox(context), n, n2, n3, n4);
    }

    native void newDisplayList(long var1, int var3);

    void newDisplayList(Context context, int n) {
        this.newDisplayList(this.unbox(context), n);
    }

    native void endDisplayList(long var1);

    void endDisplayList(Context context) {
        this.endDisplayList(this.unbox(context));
    }

    native void callDisplayList(long var1, int var3, boolean var4);

    void callDisplayList(Context context, int n, boolean bl) {
        this.callDisplayList(this.unbox(context), n, bl);
    }

    native void freeDisplayList(long var1, int var3);

    void freeDisplayList(Context context, int n) {
        this.freeDisplayList(this.unbox(context), n);
    }

    native void freeTexture(long var1, int var3);

    void freeTexture(Context context, int n) {
        this.freeTexture(this.unbox(context), n);
    }

    native void texturemapping(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, byte[] var14, int var15, int var16);

    void texturemapping(Context context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, byte[] byArray, int n12, int n13) {
        this.texturemapping(this.unbox(context), n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, byArray, n12, n13);
    }

    native boolean initTexturemapping(long var1, int var3, int var4, int var5);

    boolean initTexturemapping(Context context, int n, int n2, int n3) {
        return this.initTexturemapping(this.unbox(context), n, n2, n3);
    }

    native void setRenderMode(long var1, int var3, boolean var4);

    void setRenderMode(Context context, int n, boolean bl) {
        this.setRenderMode(this.unbox(context), n, bl);
    }

    native void setDepthBufferWriteEnable(long var1, boolean var3);

    void setDepthBufferWriteEnable(Context context, boolean bl) {
        this.setDepthBufferWriteEnable(this.unbox(context), bl);
    }

    GraphicsConfiguration getGraphicsConfig(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration;
    }

    long getFbConfig(GraphicsConfigInfo graphicsConfigInfo) {
        long l = (Long)graphicsConfigInfo.getPrivateData();
        if (l == 0L) {
            throw new IllegalArgumentException(J3dI18N.getString("Canvas3D23"));
        }
        return l;
    }

    GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration[] graphicsConfigurationArray) {
        return NativeConfigTemplate3D.getNativeConfigTemplate3D().getBestConfiguration(graphicsConfigTemplate3D, graphicsConfigurationArray);
    }

    boolean isGraphicsConfigSupported(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration graphicsConfiguration) {
        return NativeConfigTemplate3D.getNativeConfigTemplate3D().isGraphicsConfigSupported(graphicsConfigTemplate3D, graphicsConfiguration);
    }

    boolean hasDoubleBuffer(Canvas3D canvas3D) {
        return NativeConfigTemplate3D.getNativeConfigTemplate3D().hasDoubleBuffer(canvas3D);
    }

    boolean hasStereo(Canvas3D canvas3D) {
        return NativeConfigTemplate3D.getNativeConfigTemplate3D().hasStereo(canvas3D);
    }

    int getStencilSize(Canvas3D canvas3D) {
        return NativeConfigTemplate3D.getNativeConfigTemplate3D().getStencilSize(canvas3D);
    }

    boolean hasSceneAntialiasingMultisample(Canvas3D canvas3D) {
        return NativeConfigTemplate3D.getNativeConfigTemplate3D().hasSceneAntialiasingMultisample(canvas3D);
    }

    boolean hasSceneAntialiasingAccum(Canvas3D canvas3D) {
        return NativeConfigTemplate3D.getNativeConfigTemplate3D().hasSceneAntialiasingAccum(canvas3D);
    }

    long getDisplay() {
        return NativeScreenInfo.getNativeScreenInfo().getDisplay();
    }

    int getScreen(GraphicsDevice graphicsDevice) {
        return NativeScreenInfo.getNativeScreenInfo().getScreen(graphicsDevice);
    }

    DrawingSurfaceObject createDrawingSurfaceObject(Canvas3D canvas3D) {
        return new DrawingSurfaceObjectAWT(canvas3D, VirtualUniverse.mc.awt, canvas3D.screen.display, canvas3D.screen.screen, VirtualUniverse.mc.xineramaDisabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeDrawingSurface(Canvas3D canvas3D, DrawingSurfaceObject drawingSurfaceObject) {
        DrawingSurfaceObject drawingSurfaceObject2 = drawingSurfaceObject;
        synchronized (drawingSurfaceObject2) {
            DrawingSurfaceObjectAWT drawingSurfaceObjectAWT = (DrawingSurfaceObjectAWT)drawingSurfaceObject;
            long l = drawingSurfaceObjectAWT.getDS();
            long[] lArray = new long[]{l, drawingSurfaceObjectAWT.getDSI()};
            if (l != 0L) {
                VirtualUniverse.mc.postRequest(MasterControl.FREE_DRAWING_SURFACE, lArray);
            }
            drawingSurfaceObject.invalidate();
        }
    }

    void freeDrawingSurfaceNative(Object object) {
        DrawingSurfaceObjectAWT.freeDrawingSurface(object);
    }
}

