/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import megamek.common.BipedMech;
import megamek.common.CriticalSlot;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.QuadMech;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;

public class MepFile
implements IMechLoader {
    String version;
    String name;
    String mechYear;
    String innerSphere;
    String techYear;
    String chassisType;
    String tonnage;
    String engineType;
    String heatSinkType;
    String armorType;
    String internalType;
    String walkMP;
    String jumpMP;
    String heatSinks;
    String armorPoints;
    String armorPoints1;
    String armorPoints2;
    String headArmor;
    String larmArmor;
    String ltArmor;
    String ltrArmor;
    String ctArmor;
    String ctrArmor;
    String rtArmor;
    String rtrArmor;
    String rarmArmor;
    String llegArmor;
    String rlegArmor;
    String eqCount;
    String[] equipData;
    String eqWeight;
    String eqSlots;
    String[] critData;
    Hashtable<EquipmentType, Mounted> hSharedEquip = new Hashtable();

    public MepFile(InputStream inputStream) throws EntityLoadingException {
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.version = bufferedReader.readLine();
            this.name = bufferedReader.readLine();
            bufferedReader.readLine();
            bufferedReader.readLine();
            bufferedReader.readLine();
            bufferedReader.readLine();
            bufferedReader.readLine();
            this.mechYear = bufferedReader.readLine();
            this.innerSphere = bufferedReader.readLine();
            this.techYear = bufferedReader.readLine();
            this.chassisType = bufferedReader.readLine();
            this.tonnage = bufferedReader.readLine();
            this.engineType = bufferedReader.readLine();
            this.heatSinkType = bufferedReader.readLine();
            this.internalType = bufferedReader.readLine();
            this.armorType = bufferedReader.readLine();
            this.walkMP = bufferedReader.readLine();
            this.jumpMP = bufferedReader.readLine();
            this.heatSinks = bufferedReader.readLine();
            bufferedReader.readLine();
            this.armorPoints = bufferedReader.readLine();
            this.armorPoints1 = bufferedReader.readLine();
            this.armorPoints2 = bufferedReader.readLine();
            this.headArmor = bufferedReader.readLine();
            this.larmArmor = bufferedReader.readLine();
            this.ltArmor = bufferedReader.readLine();
            this.ltrArmor = bufferedReader.readLine();
            this.ctArmor = bufferedReader.readLine();
            this.ctrArmor = bufferedReader.readLine();
            this.rtArmor = bufferedReader.readLine();
            this.rtrArmor = bufferedReader.readLine();
            this.rarmArmor = bufferedReader.readLine();
            this.llegArmor = bufferedReader.readLine();
            this.rlegArmor = bufferedReader.readLine();
            this.eqCount = bufferedReader.readLine();
            int n2 = Integer.parseInt(this.eqCount.substring(1));
            this.equipData = new String[n2];
            for (n = 0; n < n2; ++n) {
                this.equipData[n] = bufferedReader.readLine();
            }
            this.eqWeight = bufferedReader.readLine();
            this.eqSlots = bufferedReader.readLine();
            bufferedReader.readLine();
            n = 78;
            this.critData = new String[n];
            for (int i = 0; i < n; ++i) {
                this.critData[i] = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new EntityLoadingException("I/O error occured during file read");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new EntityLoadingException("StringIndexOutOfBoundsException reading file (format error)");
        }
        catch (NumberFormatException numberFormatException) {
            throw new EntityLoadingException("NumberFormatException reading file (format error)");
        }
    }

    public Entity getEntity() throws EntityLoadingException {
        try {
            Mech mech = "Quad".equals(this.chassisType.trim()) ? new QuadMech() : new BipedMech();
            int n = this.name.indexOf(" ");
            if (n != -1) {
                mech.setChassis(this.name.substring(n).trim());
                mech.setModel(this.name.substring(5, n).trim());
            } else {
                mech.setChassis(this.name.substring(5).trim());
                mech.setModel(this.name.substring(5).trim());
            }
            mech.setWeight(Integer.decode(this.tonnage.trim()).intValue());
            mech.setYear(Integer.parseInt(this.techYear.trim()));
            mech.setOmni("OmniMech".equals(this.chassisType.trim()));
            if ("InnerSphere".equals(this.innerSphere.trim())) {
                if (mech.getYear() == 3025) {
                    mech.setTechLevel(0);
                } else {
                    mech.setTechLevel(1);
                }
            } else {
                mech.setTechLevel(2);
            }
            int n2 = 0;
            if (mech.isClan()) {
                n2 = 1;
            }
            int n3 = Integer.parseInt(this.walkMP.trim()) * (int)mech.getWeight();
            mech.setEngine(new Engine(n3, Engine.getEngineTypeByString(this.engineType), n2));
            mech.addEngineCrits();
            mech.addCockpit();
            mech.addGyro();
            mech.setOriginalJumpMP(Integer.parseInt(this.jumpMP.trim()));
            boolean bl = "Double".equals(this.heatSinkType.trim());
            mech.addEngineSinks(Integer.parseInt(this.heatSinks.trim()), bl);
            mech.setStructureType(this.internalType);
            mech.setArmorType(this.armorType);
            this.decodeArmorAndInternals(mech, 0, this.headArmor);
            this.decodeArmorAndInternals(mech, 5, this.larmArmor);
            this.decodeArmorAndInternals(mech, 3, this.ltArmor);
            this.decodeRearArmor(mech, 3, this.ltrArmor);
            this.decodeArmorAndInternals(mech, 1, this.ctArmor);
            this.decodeRearArmor(mech, 1, this.ctrArmor);
            this.decodeArmorAndInternals(mech, 2, this.rtArmor);
            this.decodeRearArmor(mech, 2, this.rtrArmor);
            this.decodeArmorAndInternals(mech, 4, this.rarmArmor);
            this.decodeArmorAndInternals(mech, 6, this.rlegArmor);
            this.decodeArmorAndInternals(mech, 7, this.llegArmor);
            for (int i = 0; i < this.equipData.length; ++i) {
                String string = new String(this.equipData[i]);
                if ((string = string.substring(5, 28).trim()).equals("No Lower Right Arm")) {
                    mech.removeCriticals(4, new CriticalSlot(0, 9));
                    mech.removeCriticals(4, new CriticalSlot(0, 10));
                    continue;
                }
                if (string.equals("No Lower Left Arm")) {
                    mech.removeCriticals(5, new CriticalSlot(0, 9));
                    mech.removeCriticals(5, new CriticalSlot(0, 10));
                    continue;
                }
                if (string.equals("No Right Hand")) {
                    mech.removeCriticals(4, new CriticalSlot(0, 10));
                    continue;
                }
                if (!string.equals("No Left Hand")) continue;
                mech.removeCriticals(5, new CriticalSlot(0, 10));
            }
            String string = mech.getTechLevel() == 2 ? "Clan " : "IS ";
            for (int i = 0; i < this.critData.length; ++i) {
                EquipmentType equipmentType;
                int n4 = mech.getLocationFromAbbr(this.critData[i].substring(3, 5));
                int n5 = Integer.parseInt(this.critData[i].substring(5, 7));
                boolean bl2 = false;
                String string2 = this.critData[i].substring(7).trim();
                if (mech.getCritical(n4, n5) != null) continue;
                if (string2.startsWith("(R)")) {
                    bl2 = true;
                    string2 = string2.substring(3).trim();
                }
                if (string2.equalsIgnoreCase("Armored Cowl")) {
                    mech.setCowl(5);
                }
                if (string2.equals("Heat Sink") && bl) {
                    string2 = "Double Heat Sink";
                }
                if ((equipmentType = EquipmentType.get(string + string2)) == null) {
                    equipmentType = EquipmentType.get(string2);
                }
                if (equipmentType != null) {
                    try {
                        if (equipmentType.isSpreadable()) {
                            Mounted mounted = this.hSharedEquip.get(equipmentType);
                            if (mounted != null) {
                                mech.addCritical(n4, new CriticalSlot(1, mech.getEquipmentNum(mounted), equipmentType.isHittable(), mounted));
                                continue;
                            }
                            mounted = mech.addEquipment(equipmentType, n4, bl2);
                            this.hSharedEquip.put(equipmentType, mounted);
                            continue;
                        }
                        mech.addEquipment(equipmentType, n4, bl2);
                        continue;
                    }
                    catch (LocationFullException locationFullException) {
                        throw new EntityLoadingException(locationFullException.getMessage());
                    }
                }
                if (string2.equals("-----------------") || string2.equals("''")) continue;
                mech.addFailedEquipment(string2);
            }
            if (mech.isClan()) {
                mech.addClanCase();
            }
            return mech;
        }
        catch (NumberFormatException numberFormatException) {
            throw new EntityLoadingException("NumberFormatException parsing file");
        }
        catch (NullPointerException nullPointerException) {
            throw new EntityLoadingException("NullPointerException parsing file");
        }
    }

    private void decodeArmorAndInternals(Mech mech, int n, String string) {
        mech.initializeArmor(Integer.parseInt(string.substring(2, 4)), n);
        mech.initializeInternal(Integer.parseInt(string.substring(12)), n);
    }

    private void decodeRearArmor(Mech mech, int n, String string) {
        mech.initializeRearArmor(Integer.parseInt(string.substring(2, 4)), n);
    }
}

