/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.Messages;

public class TechConstants {
    public static final int T_ALLOWED_ALL = -2;
    public static final int T_TECH_UNKNOWN = -1;
    public static final int T_INTRO_BOXSET = 0;
    public static final int T_IS_TW_NON_BOX = 1;
    public static final int T_CLAN_TW = 2;
    public static final int T_IS_TW_ALL = 3;
    public static final int T_TW_ALL = 4;
    public static final int T_IS_ADVANCED = 5;
    public static final int T_CLAN_ADVANCED = 6;
    public static final int T_IS_EXPERIMENTAL = 7;
    public static final int T_CLAN_EXPERIMENTAL = 8;
    public static final int T_IS_UNOFFICIAL = 9;
    public static final int T_CLAN_UNOFFICIAL = 10;
    public static final int T_ALL = 11;
    public static final int SIZE_LEVEL_2 = 5;
    public static final String[] T_NAMES = new String[]{"IS_Box_Set", "IS_TW_Non_Box", "Clan_TW", "IS_TW", "All_TW", "IS_Advanced", "Clan_Advanced", "IS_Experimental", "Clan_Experimental", "IS_Unofficial", "Clan_Unofficial", "All"};
    public static final int SIZE = T_NAMES.length;
    public static final String[] T_SIMPLE_LEVEL = new String[]{"1", "2", "2", "-1", "-1", "3", "3", "4", "4", "5", "5", "-1"};

    public static String getLevelName(int n) {
        if (n == -2) {
            return "(allowed to all)";
        }
        if (n == -1) {
            return "(unknown tech level)";
        }
        if (n >= 0 && n < SIZE) {
            return T_NAMES[n];
        }
        throw new IllegalArgumentException("Unknown tech level");
    }

    public static String getLevelDisplayableName(int n) {
        if (n >= 0 && n < SIZE) {
            return Messages.getString("TechLevel." + T_NAMES[n]);
        }
        throw new IllegalArgumentException("Unknown tech level");
    }

    public static boolean isLegal(int n, int n2) {
        return TechConstants.isLegal(n, n2, false);
    }

    public static boolean isLegal(int n, int n2, boolean bl) {
        if (n2 == -2) {
            return true;
        }
        if (n2 == -1) {
            return bl;
        }
        if (n == n2) {
            return true;
        }
        if (n == 7 || n == 8 || n == 9 || n == 10) {
            return true;
        }
        if (n2 == 0 && (n == 1 || n == 3 || n == 4 || n == 5 || n == 6 || n == 11)) {
            return true;
        }
        if (n2 == 1 && (n == 3 || n == 4 || n == 5 || n == 6 || n == 11)) {
            return true;
        }
        if (n2 == 2 && (n == 2 || n == 6 || n == 5 || n == 11)) {
            return true;
        }
        if (n2 == 5 && (n == 6 || n == 11)) {
            return true;
        }
        return n2 == 6 && n == 5 || n == 11;
    }

    public static String getTechName(int n) {
        if (n == 0 || n == 1 || n == 5 || n == 7 || n == 9) {
            return "Inner Sphere";
        }
        if (n == 2 || n == 6 || n == 8 || n == 10) {
            return "Clan";
        }
        return "(Unknown Technology Base)";
    }
}

