/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import megamek.client.ui.AWT.HexTileset;
import megamek.client.ui.AWT.MechTileset;
import megamek.client.ui.AWT.util.ImageFileFactory;
import megamek.client.ui.AWT.util.PlayerColors;
import megamek.client.ui.AWT.util.RotateFilter;
import megamek.client.ui.ITilesetManager;
import megamek.common.Entity;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Mech;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.preference.IPreferenceChangeListener;
import megamek.common.preference.PreferenceChangeEvent;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.DirectoryItems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilesetManager
implements IPreferenceChangeListener,
ITilesetManager {
    private Component comp;
    private MediaTracker tracker;
    private boolean started = false;
    private boolean loaded = false;
    private DirectoryItems camos;
    private MechTileset mechTileset = new MechTileset("data/images/units/");
    private MechTileset wreckTileset = new MechTileset("data/images/units/wrecks/");
    private ArrayList<EntityImage> mechImageList = new ArrayList();
    private HashMap<Integer, EntityImage> mechImages = new HashMap();
    private HexTileset hexTileset = new HexTileset();
    private Image minefieldSign;
    private Image nightFog;
    private Image artilleryAutohit;
    private Image artilleryAdjusted;
    private Image artilleryIncoming;
    private HashMap<Integer, Image> ecmShades = new HashMap();
    private static final String NIGHT_IMAGE_FILE = "data/images/hexes/transparent/night.png";
    private static final String ARTILLERY_AUTOHIT_IMAGE_FILE = "data/images/hexes/artyauto.gif";
    private static final String ARTILLERY_ADJUSTED_IMAGE_FILE = "data/images/hexes/artyadj.gif";
    private static final String ARTILLERY_INCOMING_IMAGE_FILE = "data/images/hexes/artyinc.gif";
    public static final int ARTILLERY_AUTOHIT = 0;
    public static final int ARTILLERY_ADJUSTED = 1;
    public static final int ARTILLERY_INCOMING = 2;

    public TilesetManager(Component component) throws IOException {
        this.comp = component;
        this.tracker = new MediaTracker(component);
        try {
            this.camos = new DirectoryItems(new File("data/images/camo"), "", ImageFileFactory.getInstance());
        }
        catch (Exception exception) {
            this.camos = null;
        }
        this.mechTileset.loadFromFile("mechset.txt");
        this.wreckTileset.loadFromFile("wreckset.txt");
        try {
            this.hexTileset.loadFromFile(PreferenceManager.getClientPreferences().getMapTileset());
        }
        catch (Exception exception) {
            if (!new File("data/images/hexes/defaulthexset.txt").exists()) {
                this.createDefaultHexSet();
            }
            this.hexTileset.loadFromFile("defaulthexset.txt");
        }
        PreferenceManager.getClientPreferences().addPreferenceChangeListener(this);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getName().equals("MapTileset")) {
            HexTileset hexTileset = new HexTileset();
            try {
                hexTileset.loadFromFile((String)preferenceChangeEvent.getNewValue());
                this.hexTileset = hexTileset;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    @Override
    public Image iconFor(Entity entity) {
        EntityImage entityImage = this.mechImages.get(new Integer(entity.getId()));
        if (entityImage == null) {
            System.out.println("Loading image for " + entity.getShortNameRaw() + " on the fly.");
            this.loadImage(entity);
            entityImage = this.mechImages.get(new Integer(entity.getId()));
            if (entityImage == null) {
                System.out.println("Unable to load image for entity: " + entity.getShortNameRaw());
                return null;
            }
        }
        return entityImage.getIcon();
    }

    public Image wreckMarkerFor(Entity entity) {
        EntityImage entityImage = this.mechImages.get(new Integer(entity.getId()));
        if (entityImage == null) {
            System.out.println("Loading image for " + entity.getShortNameRaw() + " on the fly.");
            this.loadImage(entity);
            entityImage = this.mechImages.get(new Integer(entity.getId()));
            if (entityImage == null) {
                System.out.println("Unable to load image for entity: " + entity.getShortNameRaw());
                return null;
            }
        }
        return entityImage.getWreckFacing(entity.getFacing());
    }

    public Image imageFor(Entity entity) {
        if (entity instanceof Mech || entity instanceof Protomech) {
            return this.imageFor(entity, entity.getSecondaryFacing());
        }
        return this.imageFor(entity, entity.getFacing());
    }

    public Image imageFor(Entity entity, int n) {
        EntityImage entityImage = this.mechImages.get(new Integer(entity.getId()));
        if (entityImage == null) {
            System.out.println("Loading image for " + entity.getShortNameRaw() + " on the fly.");
            this.loadImage(entity);
            entityImage = this.mechImages.get(new Integer(entity.getId()));
            if (entityImage == null) {
                System.out.println("Unable to load image for entity: " + entity.getShortNameRaw());
                return null;
            }
        }
        return entityImage.getFacing(n);
    }

    public Image baseFor(IHex iHex) {
        return this.hexTileset.getBase(iHex, this.comp);
    }

    public List<Image> supersFor(IHex iHex) {
        return this.hexTileset.getSupers(iHex, this.comp);
    }

    public Image getMinefieldSign() {
        return this.minefieldSign;
    }

    public Image getNightFog() {
        return this.nightFog;
    }

    public Image getEcmShade(int n) {
        Image image = this.ecmShades.get(new Integer(n));
        if (image == null) {
            Image image2 = this.nightFog;
            int[] nArray = new int[6048];
            PixelGrabber pixelGrabber = new PixelGrabber(image2, 0, 0, 84, 72, nArray, 0, 84);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("EntityImage.applyColor(): Failed to grab pixels for mech image." + interruptedException.getMessage());
                return image;
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                System.err.println("EntityImage.applyColor(): Failed to grab pixels for mech image. ImageObserver aborted.");
                return image;
            }
            for (int i = 0; i < 6048; ++i) {
                int n2 = nArray[i];
                int n3 = n2 >> 24 & 0xFF;
                if (n3 == 0) continue;
                int n4 = n & 0xFFFFFF;
                nArray[i] = n3 << 24 | n4;
            }
            image = this.comp.createImage(new MemoryImageSource(84, 72, nArray, 0, 84));
            this.ecmShades.put(new Integer(n), image);
        }
        return image;
    }

    public Image getArtilleryTarget(int n) {
        switch (n) {
            case 0: {
                return this.artilleryAutohit;
            }
            case 1: {
                return this.artilleryAdjusted;
            }
        }
        return this.artilleryIncoming;
    }

    public boolean isStarted() {
        return this.started;
    }

    public synchronized boolean isLoaded() {
        if (!this.loaded) {
            this.loaded = this.tracker.checkAll(true);
        }
        return this.started && this.loaded;
    }

    public void loadNeededImages(IGame iGame) {
        this.loaded = false;
        IBoard iBoard = iGame.getBoard();
        for (int i = 0; i < iBoard.getHeight(); ++i) {
            for (int j = 0; j < iBoard.getWidth(); ++j) {
                IHex iHex = iBoard.getHex(j, i);
                this.loadHexImage(iHex);
            }
        }
        Enumeration<Entity> enumeration = iGame.getEntities();
        while (enumeration.hasMoreElements()) {
            this.loadImage(enumeration.nextElement());
        }
        this.minefieldSign = this.comp.getToolkit().getImage("data/images/hexes/minefieldsign.gif");
        this.nightFog = this.comp.getToolkit().getImage(NIGHT_IMAGE_FILE);
        this.artilleryAutohit = this.comp.getToolkit().getImage(ARTILLERY_AUTOHIT_IMAGE_FILE);
        this.artilleryAdjusted = this.comp.getToolkit().getImage(ARTILLERY_ADJUSTED_IMAGE_FILE);
        this.artilleryIncoming = this.comp.getToolkit().getImage(ARTILLERY_INCOMING_IMAGE_FILE);
        this.started = true;
    }

    private synchronized void loadHexImage(IHex iHex) {
        this.hexTileset.assignMatch(iHex, this.comp);
        this.hexTileset.trackHexImages(iHex, this.tracker);
    }

    public void clearHex(IHex iHex) {
        this.hexTileset.clearHex(iHex);
    }

    public synchronized void waitForHex(IHex iHex) {
        this.loadHexImage(iHex);
        try {
            this.tracker.waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public synchronized void loadAllHexes() {
        this.hexTileset.loadAllImages(this.comp, this.tracker);
    }

    @Override
    public Image loadPreviewImage(Entity entity, Image image, int n, Component component) {
        Image image2 = this.mechTileset.imageFor(entity, this.comp);
        EntityImage entityImage = new EntityImage(image2, n, image, component);
        Image image3 = entityImage.loadPreviewImage();
        MediaTracker mediaTracker = new MediaTracker(this.comp);
        mediaTracker.addImage(image3, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return image3;
    }

    @Override
    public Image getPlayerCamo(Player player) {
        if (null == player.getCamoCategory() || "-- No Camo --".equals(player.getCamoCategory())) {
            return null;
        }
        Image image = null;
        try {
            String string = player.getCamoCategory();
            if ("-- General --".equals(string)) {
                string = "";
            }
            image = (Image)this.camos.getItem(string, player.getCamoFileName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return image;
    }

    public synchronized void loadImage(Entity entity) {
        Image image = this.mechTileset.imageFor(entity, this.comp);
        Image image2 = this.wreckTileset.imageFor(entity, this.comp);
        Player player = entity.getOwner();
        int n = PlayerColors.getColorRGB(player.getColorIndex());
        Image image3 = this.getPlayerCamo(player);
        EntityImage entityImage = null;
        for (EntityImage entityImage2 : this.mechImageList) {
            if (entityImage2.getBase() != image || entityImage2.tint != n) continue;
            entityImage = entityImage2;
            break;
        }
        if (entityImage == null) {
            entityImage = new EntityImage(image, image2, n, image3, this.comp);
            this.mechImageList.add(entityImage);
            entityImage.loadFacings();
            for (int i = 0; i < 6; ++i) {
                this.tracker.addImage(entityImage.getFacing(i), 1);
            }
        }
        this.mechImages.put(new Integer(entity.getId()), entityImage);
    }

    public synchronized void reset() {
        this.loaded = false;
        this.started = false;
        this.tracker = new MediaTracker(this.comp);
        this.hexTileset.reset();
    }

    private void createDefaultHexSet() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File("data/images/hexes/defaulthexset.txt"));
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("# suggested hex tileset");
            printStream.println("#");
            printStream.println("# format is:");
            printStream.println("# base/super <elevation> <terrains> <theme> <image>");
            printStream.println("#");
            printStream.println("");
            printStream.println("super * \"elevator:10\" \"\" \"boring/elevator1.gif\"");
            printStream.println("super * \"elevator:2\" \"\" \"boring/elevator2.gif\"");
            printStream.println("");
            printStream.println("super * \"geyser:1\" \"\" \"boring/geyservent.gif\"");
            printStream.println("super * \"geyser:2\" \"\" \"boring/geysererupt.gif\"");
            printStream.println("super * \"geyser:3\" \"\" \"boring/geyservent.gif\"");
            printStream.println("");
            printStream.println("super * \"road:1:00\" \"\" \"boring/road00.gif\"");
            printStream.println("super * \"road:1:01\" \"\" \"boring/road01.gif\"");
            printStream.println("super * \"road:1:02\" \"\" \"boring/road02.gif\"");
            printStream.println("super * \"road:1:03\" \"\" \"boring/road03.gif\"");
            printStream.println("super * \"road:1:04\" \"\" \"boring/road04.gif\"");
            printStream.println("super * \"road:1:05\" \"\" \"boring/road05.gif\"");
            printStream.println("super * \"road:1:06\" \"\" \"boring/road06.gif\"");
            printStream.println("super * \"road:1:07\" \"\" \"boring/road07.gif\"");
            printStream.println("super * \"road:1:08\" \"\" \"boring/road08.gif\"");
            printStream.println("super * \"road:1:09\" \"\" \"boring/road09.gif\"");
            printStream.println("super * \"road:1:10\" \"\" \"boring/road10.gif\"");
            printStream.println("super * \"road:1:11\" \"\" \"boring/road11.gif\"");
            printStream.println("super * \"road:1:12\" \"\" \"boring/road12.gif\"");
            printStream.println("super * \"road:1:13\" \"\" \"boring/road13.gif\"");
            printStream.println("super * \"road:1:14\" \"\" \"boring/road14.gif\"");
            printStream.println("super * \"road:1:15\" \"\" \"boring/road15.gif\"");
            printStream.println("super * \"road:1:16\" \"\" \"boring/road16.gif\"");
            printStream.println("super * \"road:1:17\" \"\" \"boring/road17.gif\"");
            printStream.println("super * \"road:1:18\" \"\" \"boring/road18.gif\"");
            printStream.println("super * \"road:1:19\" \"\" \"boring/road19.gif\"");
            printStream.println("super * \"road:1:20\" \"\" \"boring/road20.gif\"");
            printStream.println("super * \"road:1:21\" \"\" \"boring/road21.gif\"");
            printStream.println("super * \"road:1:22\" \"\" \"boring/road22.gif\"");
            printStream.println("super * \"road:1:23\" \"\" \"boring/road23.gif\"");
            printStream.println("super * \"road:1:24\" \"\" \"boring/road24.gif\"");
            printStream.println("super * \"road:1:25\" \"\" \"boring/road25.gif\"");
            printStream.println("super * \"road:1:26\" \"\" \"boring/road26.gif\"");
            printStream.println("super * \"road:1:27\" \"\" \"boring/road27.gif\"");
            printStream.println("super * \"road:1:28\" \"\" \"boring/road28.gif\"");
            printStream.println("super * \"road:1:29\" \"\" \"boring/road29.gif\"");
            printStream.println("super * \"road:1:30\" \"\" \"boring/road30.gif\"");
            printStream.println("super * \"road:1:31\" \"\" \"boring/road31.gif\"");
            printStream.println("super * \"road:1:32\" \"\" \"boring/road32.gif\"");
            printStream.println("super * \"road:1:33\" \"\" \"boring/road33.gif\"");
            printStream.println("super * \"road:1:34\" \"\" \"boring/road34.gif\"");
            printStream.println("super * \"road:1:35\" \"\" \"boring/road35.gif\"");
            printStream.println("super * \"road:1:36\" \"\" \"boring/road36.gif\"");
            printStream.println("super * \"road:1:37\" \"\" \"boring/road37.gif\"");
            printStream.println("super * \"road:1:38\" \"\" \"boring/road38.gif\"");
            printStream.println("super * \"road:1:39\" \"\" \"boring/road39.gif\"");
            printStream.println("super * \"road:1:40\" \"\" \"boring/road40.gif\"");
            printStream.println("super * \"road:1:41\" \"\" \"boring/road41.gif\"");
            printStream.println("super * \"road:1:42\" \"\" \"boring/road42.gif\"");
            printStream.println("super * \"road:1:43\" \"\" \"boring/road43.gif\"");
            printStream.println("super * \"road:1:44\" \"\" \"boring/road44.gif\"");
            printStream.println("super * \"road:1:45\" \"\" \"boring/road45.gif\"");
            printStream.println("super * \"road:1:46\" \"\" \"boring/road46.gif\"");
            printStream.println("super * \"road:1:47\" \"\" \"boring/road47.gif\"");
            printStream.println("super * \"road:1:48\" \"\" \"boring/road48.gif\"");
            printStream.println("super * \"road:1:49\" \"\" \"boring/road49.gif\"");
            printStream.println("super * \"road:1:50\" \"\" \"boring/road50.gif\"");
            printStream.println("super * \"road:1:51\" \"\" \"boring/road51.gif\"");
            printStream.println("super * \"road:1:52\" \"\" \"boring/road52.gif\"");
            printStream.println("super * \"road:1:53\" \"\" \"boring/road53.gif\"");
            printStream.println("super * \"road:1:54\" \"\" \"boring/road54.gif\"");
            printStream.println("super * \"road:1:55\" \"\" \"boring/road55.gif\"");
            printStream.println("super * \"road:1:56\" \"\" \"boring/road56.gif\"");
            printStream.println("super * \"road:1:57\" \"\" \"boring/road57.gif\"");
            printStream.println("super * \"road:1:58\" \"\" \"boring/road58.gif\"");
            printStream.println("super * \"road:1:59\" \"\" \"boring/road59.gif\"");
            printStream.println("super * \"road:1:60\" \"\" \"boring/road60.gif\"");
            printStream.println("super * \"road:1:61\" \"\" \"boring/road61.gif\"");
            printStream.println("super * \"road:1:62\" \"\" \"boring/road62.gif\"");
            printStream.println("super * \"road:1:63\" \"\" \"boring/road63.gif\"");
            printStream.println("");
            printStream.println("super * \"fluff:5:00\" \"\" \"fluff/cars_1.gif\"");
            printStream.println("super * \"fluff:5:01\" \"\" \"fluff/cars_2.gif\"");
            printStream.println("super * \"fluff:5:02\" \"\" \"fluff/cars_3.gif\"");
            printStream.println("super * \"fluff:5:03\" \"\" \"fluff/cars_4.gif\"");
            printStream.println("super * \"fluff:5:04\" \"\" \"fluff/cars_5.gif\"");
            printStream.println("super * \"fluff:5:05\" \"\" \"fluff/cars_6.gif\"");
            printStream.println("super * \"fluff:5:06\" \"\" \"fluff/cars_7.gif\"");
            printStream.println("super * \"fluff:5:07\" \"\" \"fluff/cars_8.gif\"");
            printStream.println("");
            printStream.println("super * \"fluff:4:00\" \"\" \"fluff/square1.gif\"");
            printStream.println("super * \"fluff:4:01\" \"\" \"fluff/square2.gif\"");
            printStream.println("super * \"fluff:4:02\" \"\" \"fluff/square3.gif\"");
            printStream.println("super * \"fluff:4:03\" \"\" \"fluff/square4.gif\"");
            printStream.println("super * \"fluff:4:04\" \"\" \"fluff/square5.gif\"");
            printStream.println("super * \"fluff:4:05\" \"\" \"fluff/square6.gif\"");
            printStream.println("super * \"fluff:4:06\" \"\" \"fluff/pillars1.gif\"");
            printStream.println("super * \"fluff:4:07\" \"\" \"fluff/pillars2.gif\"");
            printStream.println("super * \"fluff:4:08\" \"\" \"fluff/pillars3.gif\"");
            printStream.println("super * \"fluff:4:09\" \"\" \"fluff/pillars4.gif\"");
            printStream.println("super * \"fluff:4:10\" \"\" \"fluff/pillars5.gif\"");
            printStream.println("super * \"fluff:4:11\" \"\" \"fluff/pillars6.gif\"");
            printStream.println("");
            printStream.println("super * \"fluff:7:00\" \"\" \"fluff/construction1.gif\"");
            printStream.println("super * \"fluff:7:01\" \"\" \"fluff/construction2.gif\"");
            printStream.println("super * \"fluff:7:02\" \"\" \"fluff/construction3.gif\"");
            printStream.println("super * \"fluff:7:03\" \"\" \"fluff/suburb1.gif\"");
            printStream.println("super * \"fluff:7:04\" \"\" \"fluff/suburb2.gif\"");
            printStream.println("super * \"fluff:7:05\" \"\" \"fluff/suburb3.gif\"");
            printStream.println("");
            printStream.println("super * \"fluff:8:06\" \"\" \"fluff/garden1.gif\"");
            printStream.println("super * \"fluff:8:07\" \"\" \"fluff/garden2.gif\"");
            printStream.println("super * \"fluff:8:08\" \"\" \"fluff/garden3.gif\"");
            printStream.println("super * \"fluff:8:09\" \"\" \"fluff/garden4.gif\"");
            printStream.println("super * \"fluff:8:10\" \"\" \"fluff/garden5.gif\"");
            printStream.println("super * \"fluff:8:11\" \"\" \"fluff/garden6.gif\"");
            printStream.println("");
            printStream.println("super * \"fluff:9:00\" \"\" \"fluff/maglevtrack1.gif\"");
            printStream.println("super * \"fluff:9:01\" \"\" \"fluff/maglevtrack2.gif\"");
            printStream.println("super * \"fluff:9:02\" \"\" \"fluff/maglevtrack3.gif\"");
            printStream.println("super * \"fluff:9:03\" \"\" \"fluff/maglevstation1.gif\"");
            printStream.println("super * \"fluff:9:04\" \"\" \"fluff/maglevstation2.gif\"");
            printStream.println("super * \"fluff:9:05\" \"\" \"fluff/maglevstation3.gif\"");
            printStream.println("super * \"fluff:9:06\" \"\" \"fluff/maglevtrain1.gif\"");
            printStream.println("super * \"fluff:9:07\" \"\" \"fluff/maglevtrain2.gif\"");
            printStream.println("super * \"fluff:9:08\" \"\" \"fluff/maglevtrain3.gif\"");
            printStream.println("super * \"fluff:9:09\" \"\" \"fluff/maglevtrain4.gif\"");
            printStream.println("super * \"fluff:9:10\" \"\" \"fluff/maglevtrain5.gif\"");
            printStream.println("super * \"fluff:9:11\" \"\" \"fluff/maglevtrain6.gif\"");
            printStream.println("");
            printStream.println("super * \"road:2:00\" \"\" \"fluff/road_trees_00.gif\"");
            printStream.println("super * \"road:2:01\" \"\" \"fluff/road_trees_01.gif\"");
            printStream.println("super * \"road:2:02\" \"\" \"fluff/road_trees_02.gif\"");
            printStream.println("super * \"road:2:03\" \"\" \"fluff/road_trees_03.gif\"");
            printStream.println("super * \"road:2:04\" \"\" \"fluff/road_trees_04.gif\"");
            printStream.println("super * \"road:2:05\" \"\" \"fluff/road_trees_05.gif\"");
            printStream.println("super * \"road:2:06\" \"\" \"fluff/road_trees_06.gif\"");
            printStream.println("super * \"road:2:07\" \"\" \"fluff/road_trees_07.gif\"");
            printStream.println("super * \"road:2:08\" \"\" \"fluff/road_trees_08.gif\"");
            printStream.println("super * \"road:2:09\" \"\" \"fluff/road_trees_09.gif\"");
            printStream.println("super * \"road:2:10\" \"\" \"fluff/road_trees_10.gif\"");
            printStream.println("super * \"road:2:11\" \"\" \"fluff/road_trees_11.gif\"");
            printStream.println("super * \"road:2:12\" \"\" \"fluff/road_trees_12.gif\"");
            printStream.println("super * \"road:2:13\" \"\" \"fluff/road_trees_13.gif\"");
            printStream.println("super * \"road:2:14\" \"\" \"fluff/road_trees_14.gif\"");
            printStream.println("super * \"road:2:15\" \"\" \"fluff/road_trees_15.gif\"");
            printStream.println("super * \"road:2:16\" \"\" \"fluff/road_trees_16.gif\"");
            printStream.println("super * \"road:2:17\" \"\" \"fluff/road_trees_17.gif\"");
            printStream.println("super * \"road:2:18\" \"\" \"fluff/road_trees_18.gif\"");
            printStream.println("super * \"road:2:19\" \"\" \"fluff/road_trees_19.gif\"");
            printStream.println("super * \"road:2:20\" \"\" \"fluff/road_trees_20.gif\"");
            printStream.println("super * \"road:2:21\" \"\" \"fluff/road_trees_21.gif\"");
            printStream.println("super * \"road:2:22\" \"\" \"fluff/road_trees_22.gif\"");
            printStream.println("super * \"road:2:23\" \"\" \"fluff/road_trees_23.gif\"");
            printStream.println("super * \"road:2:24\" \"\" \"fluff/road_trees_24.gif\"");
            printStream.println("super * \"road:2:25\" \"\" \"fluff/road_trees_25.gif\"");
            printStream.println("super * \"road:2:26\" \"\" \"fluff/road_trees_26.gif\"");
            printStream.println("super * \"road:2:27\" \"\" \"fluff/road_trees_27.gif\"");
            printStream.println("super * \"road:2:28\" \"\" \"fluff/road_trees_28.gif\"");
            printStream.println("super * \"road:2:29\" \"\" \"fluff/road_trees_29.gif\"");
            printStream.println("super * \"road:2:30\" \"\" \"fluff/road_trees_30.gif\"");
            printStream.println("super * \"road:2:31\" \"\" \"fluff/road_trees_31.gif\"");
            printStream.println("super * \"road:2:32\" \"\" \"fluff/road_trees_32.gif\"");
            printStream.println("super * \"road:2:33\" \"\" \"fluff/road_trees_33.gif\"");
            printStream.println("super * \"road:2:34\" \"\" \"fluff/road_trees_34.gif\"");
            printStream.println("super * \"road:2:35\" \"\" \"fluff/road_trees_35.gif\"");
            printStream.println("super * \"road:2:36\" \"\" \"fluff/road_trees_36.gif\"");
            printStream.println("super * \"road:2:37\" \"\" \"fluff/road_trees_37.gif\"");
            printStream.println("super * \"road:2:38\" \"\" \"fluff/road_trees_38.gif\"");
            printStream.println("super * \"road:2:39\" \"\" \"fluff/road_trees_39.gif\"");
            printStream.println("super * \"road:2:40\" \"\" \"fluff/road_trees_40.gif\"");
            printStream.println("super * \"road:2:41\" \"\" \"fluff/road_trees_41.gif\"");
            printStream.println("super * \"road:2:42\" \"\" \"fluff/road_trees_42.gif\"");
            printStream.println("super * \"road:2:43\" \"\" \"fluff/road_trees_43.gif\"");
            printStream.println("super * \"road:2:44\" \"\" \"fluff/road_trees_44.gif\"");
            printStream.println("super * \"road:2:45\" \"\" \"fluff/road_trees_45.gif\"");
            printStream.println("super * \"road:2:46\" \"\" \"fluff/road_trees_46.gif\"");
            printStream.println("super * \"road:2:47\" \"\" \"fluff/road_trees_47.gif\"");
            printStream.println("super * \"road:2:48\" \"\" \"fluff/road_trees_48.gif\"");
            printStream.println("super * \"road:2:49\" \"\" \"fluff/road_trees_49.gif\"");
            printStream.println("super * \"road:2:50\" \"\" \"fluff/road_trees_50.gif\"");
            printStream.println("super * \"road:2:51\" \"\" \"fluff/road_trees_51.gif\"");
            printStream.println("super * \"road:2:52\" \"\" \"fluff/road_trees_52.gif\"");
            printStream.println("super * \"road:2:53\" \"\" \"fluff/road_trees_53.gif\"");
            printStream.println("super * \"road:2:54\" \"\" \"fluff/road_trees_54.gif\"");
            printStream.println("super * \"road:2:55\" \"\" \"fluff/road_trees_55.gif\"");
            printStream.println("super * \"road:2:56\" \"\" \"fluff/road_trees_56.gif\"");
            printStream.println("super * \"road:2:57\" \"\" \"fluff/road_trees_57.gif\"");
            printStream.println("super * \"road:2:58\" \"\" \"fluff/road_trees_58.gif\"");
            printStream.println("super * \"road:2:59\" \"\" \"fluff/road_trees_59.gif\"");
            printStream.println("super * \"road:2:60\" \"\" \"fluff/road_trees_60.gif\"");
            printStream.println("super * \"road:2:61\" \"\" \"fluff/road_trees_61.gif\"");
            printStream.println("super * \"road:2:62\" \"\" \"fluff/road_trees_62.gif\"");
            printStream.println("super * \"road:2:63\" \"\" \"fluff/road_trees_63.gif\"");
            printStream.println("");
            printStream.println("super * \"building:4;bldg_elev:1;bldg_cf:*\" \"\" \"singlehex/hardened_1.gif\"");
            printStream.println("super * \"building:4;bldg_elev:2;bldg_cf:*\" \"\" \"singlehex/hardened_2.gif\"");
            printStream.println("super * \"building:4;bldg_elev:3;bldg_cf:*\" \"\" \"singlehex/hardened_3.gif\"");
            printStream.println("super * \"building:4;bldg_elev:4;bldg_cf:*\" \"\" \"singlehex/hardened_4.gif\"");
            printStream.println("");
            printStream.println("super * \"building:3;bldg_elev:1;bldg_cf:*\" \"\" \"singlehex/heavy_1.gif\"");
            printStream.println("super * \"building:3;bldg_elev:2;bldg_cf:*\" \"\" \"singlehex/heavy_2.gif\"");
            printStream.println("super * \"building:3;bldg_elev:3;bldg_cf:*\" \"\" \"singlehex/heavy_3.gif\"");
            printStream.println("super * \"building:3;bldg_elev:4;bldg_cf:*\" \"\" \"singlehex/heavy_4.gif\"");
            printStream.println("");
            printStream.println("super * \"building:2;bldg_elev:1;bldg_cf:*\" \"\" \"singlehex/medium_1.gif\"");
            printStream.println("super * \"building:2;bldg_elev:2;bldg_cf:*\" \"\" \"singlehex/medium_2.gif\"");
            printStream.println("super * \"building:2;bldg_elev:3;bldg_cf:*\" \"\" \"singlehex/medium_3.gif\"");
            printStream.println("super * \"building:2;bldg_elev:4;bldg_cf:*\" \"\" \"singlehex/medium_4.gif\"");
            printStream.println("");
            printStream.println("super * \"building:1;bldg_elev:*;bldg_cf:*;fluff:3\"     \"\" \"singlehex/light_3.gif\"");
            printStream.println("super * \"building:1;bldg_elev:*;bldg_cf:*;fluff:1\"     \"\" \"singlehex/light_5.gif\"");
            printStream.println("super * \"building:1;bldg_elev:1;bldg_cf:*\" \"\" \"singlehex/light_6.gif\"");
            printStream.println("super * \"building:1;bldg_elev:2;bldg_cf:*\" \"\" \"singlehex/light_1.gif\"");
            printStream.println("super * \"building:1;bldg_elev:3;bldg_cf:*\" \"\" \"singlehex/light_4.gif\"");
            printStream.println("super * \"building:1;bldg_elev:4;bldg_cf:*\" \"\" \"singlehex/light_2.gif\"");
            printStream.println("");
            printStream.println("super * \"building:1;bldg_elev:1;bldg_cf:*\" \"\" \"boring/cropped_farm.png\"");
            printStream.println("super * \"building:1;bldg_elev:2;bldg_cf:*\" \"\" \"boring/cropped_church.png\"");
            printStream.println("super * \"building:1;bldg_elev:3;bldg_cf:*\" \"\" \"boring/light_bldg.png\"");
            printStream.println("super * \"building:2;bldg_elev:3;bldg_cf:*\" \"\" \"boring/cropped_cannon_tower.png\"");
            printStream.println("super * \"building:3;bldg_elev:3;bldg_cf:*\" \"\" \"boring/cropped_refinery.png\"");
            printStream.println("super * \"building:3;bldg_elev:4;bldg_cf:*\" \"\" \"boring/cropped_mage_tower.png\"");
            printStream.println("");
            printStream.println("super * \"building:1:00;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof00.gif\"");
            printStream.println("super * \"building:1:01;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof01.gif\"");
            printStream.println("super * \"building:1:02;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof02.gif\"");
            printStream.println("super * \"building:1:03;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof03.gif\"");
            printStream.println("super * \"building:1:04;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof04.gif\"");
            printStream.println("super * \"building:1:05;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof05.gif\"");
            printStream.println("super * \"building:1:06;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof06.gif\"");
            printStream.println("super * \"building:1:07;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof07.gif\"");
            printStream.println("super * \"building:1:08;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof08.gif\"");
            printStream.println("super * \"building:1:09;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof09.gif\"");
            printStream.println("super * \"building:1:10;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof10.gif\"");
            printStream.println("super * \"building:1:11;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof11.gif\"");
            printStream.println("super * \"building:1:12;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof12.gif\"");
            printStream.println("super * \"building:1:13;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof13.gif\"");
            printStream.println("super * \"building:1:14;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof14.gif\"");
            printStream.println("super * \"building:1:15;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof15.gif\"");
            printStream.println("super * \"building:1:16;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof16.gif\"");
            printStream.println("super * \"building:1:17;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof17.gif\"");
            printStream.println("super * \"building:1:18;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof18.gif\"");
            printStream.println("super * \"building:1:19;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof19.gif\"");
            printStream.println("super * \"building:1:20;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof20.gif\"");
            printStream.println("super * \"building:1:21;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof21.gif\"");
            printStream.println("super * \"building:1:22;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof22.gif\"");
            printStream.println("super * \"building:1:23;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof23.gif\"");
            printStream.println("super * \"building:1:24;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof24.gif\"");
            printStream.println("super * \"building:1:25;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof25.gif\"");
            printStream.println("super * \"building:1:26;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof26.gif\"");
            printStream.println("super * \"building:1:27;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof27.gif\"");
            printStream.println("super * \"building:1:28;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof28.gif\"");
            printStream.println("super * \"building:1:29;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof29.gif\"");
            printStream.println("super * \"building:1:30;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof30.gif\"");
            printStream.println("super * \"building:1:31;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof31.gif\"");
            printStream.println("super * \"building:1:32;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof32.gif\"");
            printStream.println("super * \"building:1:33;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof33.gif\"");
            printStream.println("super * \"building:1:34;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof34.gif\"");
            printStream.println("super * \"building:1:35;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof35.gif\"");
            printStream.println("super * \"building:1:36;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof36.gif\"");
            printStream.println("super * \"building:1:37;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof37.gif\"");
            printStream.println("super * \"building:1:38;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof38.gif\"");
            printStream.println("super * \"building:1:39;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof39.gif\"");
            printStream.println("super * \"building:1:40;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof40.gif\"");
            printStream.println("super * \"building:1:41;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof41.gif\"");
            printStream.println("super * \"building:1:42;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof42.gif\"");
            printStream.println("super * \"building:1:43;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof43.gif\"");
            printStream.println("super * \"building:1:44;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof44.gif\"");
            printStream.println("super * \"building:1:45;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof45.gif\"");
            printStream.println("super * \"building:1:46;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof46.gif\"");
            printStream.println("super * \"building:1:47;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof47.gif\"");
            printStream.println("super * \"building:1:48;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof48.gif\"");
            printStream.println("super * \"building:1:49;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof49.gif\"");
            printStream.println("super * \"building:1:50;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof50.gif\"");
            printStream.println("super * \"building:1:51;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof51.gif\"");
            printStream.println("super * \"building:1:52;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof52.gif\"");
            printStream.println("super * \"building:1:53;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof53.gif\"");
            printStream.println("super * \"building:1:54;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof54.gif\"");
            printStream.println("super * \"building:1:55;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof55.gif\"");
            printStream.println("super * \"building:1:56;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof56.gif\"");
            printStream.println("super * \"building:1:57;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof57.gif\"");
            printStream.println("super * \"building:1:58;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof58.gif\"");
            printStream.println("super * \"building:1:59;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof59.gif\"");
            printStream.println("super * \"building:1:60;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof60.gif\"");
            printStream.println("super * \"building:1:61;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof61.gif\"");
            printStream.println("super * \"building:1:62;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof62.gif\"");
            printStream.println("super * \"building:1:63;bldg_elev:*;bldg_cf:*\" \"\" \"light/light_roof63.gif\"");
            printStream.println("");
            printStream.println("super * \"building:2:00;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof00.gif\"");
            printStream.println("super * \"building:2:01;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof01.gif\"");
            printStream.println("super * \"building:2:02;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof02.gif\"");
            printStream.println("super * \"building:2:03;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof03.gif\"");
            printStream.println("super * \"building:2:04;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof04.gif\"");
            printStream.println("super * \"building:2:05;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof05.gif\"");
            printStream.println("super * \"building:2:06;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof06.gif\"");
            printStream.println("super * \"building:2:07;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof07.gif\"");
            printStream.println("super * \"building:2:08;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof08.gif\"");
            printStream.println("super * \"building:2:09;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof09.gif\"");
            printStream.println("super * \"building:2:10;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof10.gif\"");
            printStream.println("super * \"building:2:11;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof11.gif\"");
            printStream.println("super * \"building:2:12;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof12.gif\"");
            printStream.println("super * \"building:2:13;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof13.gif\"");
            printStream.println("super * \"building:2:14;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof14.gif\"");
            printStream.println("super * \"building:2:15;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof15.gif\"");
            printStream.println("super * \"building:2:16;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof16.gif\"");
            printStream.println("super * \"building:2:17;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof17.gif\"");
            printStream.println("super * \"building:2:18;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof18.gif\"");
            printStream.println("super * \"building:2:19;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof19.gif\"");
            printStream.println("super * \"building:2:20;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof20.gif\"");
            printStream.println("super * \"building:2:21;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof21.gif\"");
            printStream.println("super * \"building:2:22;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof22.gif\"");
            printStream.println("super * \"building:2:23;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof23.gif\"");
            printStream.println("super * \"building:2:24;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof24.gif\"");
            printStream.println("super * \"building:2:25;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof25.gif\"");
            printStream.println("super * \"building:2:26;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof26.gif\"");
            printStream.println("super * \"building:2:27;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof27.gif\"");
            printStream.println("super * \"building:2:28;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof28.gif\"");
            printStream.println("super * \"building:2:29;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof29.gif\"");
            printStream.println("super * \"building:2:30;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof30.gif\"");
            printStream.println("super * \"building:2:31;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof31.gif\"");
            printStream.println("super * \"building:2:32;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof32.gif\"");
            printStream.println("super * \"building:2:33;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof33.gif\"");
            printStream.println("super * \"building:2:34;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof34.gif\"");
            printStream.println("super * \"building:2:35;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof35.gif\"");
            printStream.println("super * \"building:2:36;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof36.gif\"");
            printStream.println("super * \"building:2:37;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof37.gif\"");
            printStream.println("super * \"building:2:38;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof38.gif\"");
            printStream.println("super * \"building:2:39;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof39.gif\"");
            printStream.println("super * \"building:2:40;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof40.gif\"");
            printStream.println("super * \"building:2:41;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof41.gif\"");
            printStream.println("super * \"building:2:42;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof42.gif\"");
            printStream.println("super * \"building:2:43;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof43.gif\"");
            printStream.println("super * \"building:2:44;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof44.gif\"");
            printStream.println("super * \"building:2:45;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof45.gif\"");
            printStream.println("super * \"building:2:46;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof46.gif\"");
            printStream.println("super * \"building:2:47;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof47.gif\"");
            printStream.println("super * \"building:2:48;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof48.gif\"");
            printStream.println("super * \"building:2:49;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof49.gif\"");
            printStream.println("super * \"building:2:50;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof50.gif\"");
            printStream.println("super * \"building:2:51;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof51.gif\"");
            printStream.println("super * \"building:2:52;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof52.gif\"");
            printStream.println("super * \"building:2:53;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof53.gif\"");
            printStream.println("super * \"building:2:54;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof54.gif\"");
            printStream.println("super * \"building:2:55;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof55.gif\"");
            printStream.println("super * \"building:2:56;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof56.gif\"");
            printStream.println("super * \"building:2:57;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof57.gif\"");
            printStream.println("super * \"building:2:58;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof58.gif\"");
            printStream.println("super * \"building:2:59;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof59.gif\"");
            printStream.println("super * \"building:2:60;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof60.gif\"");
            printStream.println("super * \"building:2:61;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof61.gif\"");
            printStream.println("super * \"building:2:62;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof62.gif\"");
            printStream.println("super * \"building:2:63;bldg_elev:*;bldg_cf:*\" \"\" \"megaart/roof63.gif\"");
            printStream.println("");
            printStream.println("super * \"building:3:00;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof00.gif\"");
            printStream.println("super * \"building:3:01;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof01.gif\"");
            printStream.println("super * \"building:3:02;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof02.gif\"");
            printStream.println("super * \"building:3:03;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof03.gif\"");
            printStream.println("super * \"building:3:04;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof04.gif\"");
            printStream.println("super * \"building:3:05;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof05.gif\"");
            printStream.println("super * \"building:3:06;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof06.gif\"");
            printStream.println("super * \"building:3:07;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof07.gif\"");
            printStream.println("super * \"building:3:08;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof08.gif\"");
            printStream.println("super * \"building:3:09;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof09.gif\"");
            printStream.println("super * \"building:3:10;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof10.gif\"");
            printStream.println("super * \"building:3:11;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof11.gif\"");
            printStream.println("super * \"building:3:12;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof12.gif\"");
            printStream.println("super * \"building:3:13;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof13.gif\"");
            printStream.println("super * \"building:3:14;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof14.gif\"");
            printStream.println("super * \"building:3:15;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof15.gif\"");
            printStream.println("super * \"building:3:16;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof16.gif\"");
            printStream.println("super * \"building:3:17;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof17.gif\"");
            printStream.println("super * \"building:3:18;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof18.gif\"");
            printStream.println("super * \"building:3:19;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof19.gif\"");
            printStream.println("super * \"building:3:20;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof20.gif\"");
            printStream.println("super * \"building:3:21;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof21.gif\"");
            printStream.println("super * \"building:3:22;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof22.gif\"");
            printStream.println("super * \"building:3:23;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof23.gif\"");
            printStream.println("super * \"building:3:24;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof24.gif\"");
            printStream.println("super * \"building:3:25;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof25.gif\"");
            printStream.println("super * \"building:3:26;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof26.gif\"");
            printStream.println("super * \"building:3:27;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof27.gif\"");
            printStream.println("super * \"building:3:28;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof28.gif\"");
            printStream.println("super * \"building:3:29;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof29.gif\"");
            printStream.println("super * \"building:3:30;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof30.gif\"");
            printStream.println("super * \"building:3:31;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof31.gif\"");
            printStream.println("super * \"building:3:32;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof32.gif\"");
            printStream.println("super * \"building:3:33;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof33.gif\"");
            printStream.println("super * \"building:3:34;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof34.gif\"");
            printStream.println("super * \"building:3:35;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof35.gif\"");
            printStream.println("super * \"building:3:36;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof36.gif\"");
            printStream.println("super * \"building:3:37;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof37.gif\"");
            printStream.println("super * \"building:3:38;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof38.gif\"");
            printStream.println("super * \"building:3:39;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof39.gif\"");
            printStream.println("super * \"building:3:40;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof40.gif\"");
            printStream.println("super * \"building:3:41;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof41.gif\"");
            printStream.println("super * \"building:3:42;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof42.gif\"");
            printStream.println("super * \"building:3:43;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof43.gif\"");
            printStream.println("super * \"building:3:44;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof44.gif\"");
            printStream.println("super * \"building:3:45;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof45.gif\"");
            printStream.println("super * \"building:3:46;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof46.gif\"");
            printStream.println("super * \"building:3:47;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof47.gif\"");
            printStream.println("super * \"building:3:48;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof48.gif\"");
            printStream.println("super * \"building:3:49;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof49.gif\"");
            printStream.println("super * \"building:3:50;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof50.gif\"");
            printStream.println("super * \"building:3:51;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof51.gif\"");
            printStream.println("super * \"building:3:52;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof52.gif\"");
            printStream.println("super * \"building:3:53;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof53.gif\"");
            printStream.println("super * \"building:3:54;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof54.gif\"");
            printStream.println("super * \"building:3:55;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof55.gif\"");
            printStream.println("super * \"building:3:56;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof56.gif\"");
            printStream.println("super * \"building:3:57;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof57.gif\"");
            printStream.println("super * \"building:3:58;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof58.gif\"");
            printStream.println("super * \"building:3:59;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof59.gif\"");
            printStream.println("super * \"building:3:60;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof60.gif\"");
            printStream.println("super * \"building:3:61;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof61.gif\"");
            printStream.println("super * \"building:3:62;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof62.gif\"");
            printStream.println("super * \"building:3:63;bldg_elev:*;bldg_cf:*\" \"\" \"heavy/heavy_roof63.gif\"");
            printStream.println("");
            printStream.println("super * \"building:4:00;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof00.gif\"");
            printStream.println("super * \"building:4:01;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof01.gif\"");
            printStream.println("super * \"building:4:02;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof02.gif\"");
            printStream.println("super * \"building:4:03;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof03.gif\"");
            printStream.println("super * \"building:4:04;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof04.gif\"");
            printStream.println("super * \"building:4:05;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof05.gif\"");
            printStream.println("super * \"building:4:06;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof06.gif\"");
            printStream.println("super * \"building:4:07;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof07.gif\"");
            printStream.println("super * \"building:4:08;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof08.gif\"");
            printStream.println("super * \"building:4:09;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof09.gif\"");
            printStream.println("super * \"building:4:10;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof10.gif\"");
            printStream.println("super * \"building:4:11;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof11.gif\"");
            printStream.println("super * \"building:4:12;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof12.gif\"");
            printStream.println("super * \"building:4:13;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof13.gif\"");
            printStream.println("super * \"building:4:14;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof14.gif\"");
            printStream.println("super * \"building:4:15;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof15.gif\"");
            printStream.println("super * \"building:4:16;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof16.gif\"");
            printStream.println("super * \"building:4:17;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof17.gif\"");
            printStream.println("super * \"building:4:18;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof18.gif\"");
            printStream.println("super * \"building:4:19;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof19.gif\"");
            printStream.println("super * \"building:4:20;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof20.gif\"");
            printStream.println("super * \"building:4:21;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof21.gif\"");
            printStream.println("super * \"building:4:22;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof22.gif\"");
            printStream.println("super * \"building:4:23;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof23.gif\"");
            printStream.println("super * \"building:4:24;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof24.gif\"");
            printStream.println("super * \"building:4:25;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof25.gif\"");
            printStream.println("super * \"building:4:26;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof26.gif\"");
            printStream.println("super * \"building:4:27;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof27.gif\"");
            printStream.println("super * \"building:4:28;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof28.gif\"");
            printStream.println("super * \"building:4:29;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof29.gif\"");
            printStream.println("super * \"building:4:30;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof30.gif\"");
            printStream.println("super * \"building:4:31;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof31.gif\"");
            printStream.println("super * \"building:4:32;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof32.gif\"");
            printStream.println("super * \"building:4:33;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof33.gif\"");
            printStream.println("super * \"building:4:34;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof34.gif\"");
            printStream.println("super * \"building:4:35;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof35.gif\"");
            printStream.println("super * \"building:4:36;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof36.gif\"");
            printStream.println("super * \"building:4:37;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof37.gif\"");
            printStream.println("super * \"building:4:38;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof38.gif\"");
            printStream.println("super * \"building:4:39;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof39.gif\"");
            printStream.println("super * \"building:4:40;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof40.gif\"");
            printStream.println("super * \"building:4:41;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof41.gif\"");
            printStream.println("super * \"building:4:42;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof42.gif\"");
            printStream.println("super * \"building:4:43;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof43.gif\"");
            printStream.println("super * \"building:4:44;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof44.gif\"");
            printStream.println("super * \"building:4:45;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof45.gif\"");
            printStream.println("super * \"building:4:46;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof46.gif\"");
            printStream.println("super * \"building:4:47;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof47.gif\"");
            printStream.println("super * \"building:4:48;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof48.gif\"");
            printStream.println("super * \"building:4:49;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof49.gif\"");
            printStream.println("super * \"building:4:50;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof50.gif\"");
            printStream.println("super * \"building:4:51;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof51.gif\"");
            printStream.println("super * \"building:4:52;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof52.gif\"");
            printStream.println("super * \"building:4:53;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof53.gif\"");
            printStream.println("super * \"building:4:54;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof54.gif\"");
            printStream.println("super * \"building:4:55;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof55.gif\"");
            printStream.println("super * \"building:4:56;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof56.gif\"");
            printStream.println("super * \"building:4:57;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof57.gif\"");
            printStream.println("super * \"building:4:58;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof58.gif\"");
            printStream.println("super * \"building:4:59;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof59.gif\"");
            printStream.println("super * \"building:4:60;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof60.gif\"");
            printStream.println("super * \"building:4:61;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof61.gif\"");
            printStream.println("super * \"building:4:62;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof62.gif\"");
            printStream.println("super * \"building:4:63;bldg_elev:*;bldg_cf:*\" \"\" \"hardened/hardened_roof63.gif\"");
            printStream.println("");
            printStream.println("super * \"rubble:1\" \"\" \"boring/rubble_light.gif\"");
            printStream.println("super * \"rubble:2\" \"\" \"boring/rubble_medium.gif\"");
            printStream.println("super * \"rubble:3\" \"\" \"boring/rubble_heavy.gif\"");
            printStream.println("super * \"rubble:4\" \"\" \"boring/rubble_hardened.gif\"");
            printStream.println("");
            printStream.println("super * \"fluff:6:00\" \"\" \"fluff/skylight1.gif\"");
            printStream.println("super * \"fluff:6:01\" \"\" \"fluff/skylight2.gif\"");
            printStream.println("super * \"fluff:6:02\" \"\" \"fluff/skylight3.gif\"");
            printStream.println("super * \"fluff:6:03\" \"\" \"fluff/skylight4.gif\"");
            printStream.println("super * \"fluff:6:04\" \"\" \"fluff/skylight5.gif\"");
            printStream.println("super * \"fluff:6:05\" \"\" \"fluff/skylight6.gif\"");
            printStream.println("super * \"fluff:6:06\" \"\" \"fluff/stack1.gif\"");
            printStream.println("super * \"fluff:6:07\" \"\" \"fluff/stack2.gif\"");
            printStream.println("super * \"fluff:6:08\" \"\" \"fluff/stack3.gif\"");
            printStream.println("super * \"fluff:6:09\" \"\" \"fluff/stack4.gif\"");
            printStream.println("super * \"fluff:6:10\" \"\" \"fluff/stack5.gif\"");
            printStream.println("super * \"fluff:6:11\" \"\" \"fluff/stack6.gif\"");
            printStream.println("super * \"fluff:6:12\" \"\" \"fluff/bevel1.gif\"");
            printStream.println("super * \"fluff:6:13\" \"\" \"fluff/bevel2.gif\"");
            printStream.println("super * \"fluff:6:14\" \"\" \"fluff/bevel3.gif\"");
            printStream.println("super * \"fluff:6:15\" \"\" \"fluff/bevel4.gif\"");
            printStream.println("super * \"fluff:6:16\" \"\" \"fluff/bevel5.gif\"");
            printStream.println("super * \"fluff:6:17\" \"\" \"fluff/bevel6.gif\"");
            printStream.println("super * \"fluff:6:18\" \"\" \"fluff/pool1.gif\"");
            printStream.println("");
            printStream.println("super * \"fluff:8:00\" \"\" \"fluff/ledge1.gif\"");
            printStream.println("super * \"fluff:8:01\" \"\" \"fluff/ledge2.gif\"");
            printStream.println("super * \"fluff:8:02\" \"\" \"fluff/ledge3.gif\"");
            printStream.println("super * \"fluff:8:03\" \"\" \"fluff/ledge4.gif\"");
            printStream.println("super * \"fluff:8:04\" \"\" \"fluff/ledge5.gif\"");
            printStream.println("super * \"fluff:8:05\" \"\" \"fluff/ledge6.gif\"");
            printStream.println("");
            printStream.println("super * \"fluff:2:00\" \"\" \"fluff/heli1.gif\"");
            printStream.println("super * \"fluff:2:01\" \"\" \"fluff/heli2.gif\"");
            printStream.println("super * \"fluff:2:02\" \"\" \"fluff/heli3.gif\"");
            printStream.println("super * \"fluff:2:03\" \"\" \"fluff/beacon1.gif\"");
            printStream.println("super * \"fluff:2:04\" \"\" \"fluff/beacon2.gif\"");
            printStream.println("");
            printStream.println("super * \"smoke:1\" \"\" \"boring/smoke.gif\"");
            printStream.println("super * \"smoke:2\" \"\" \"boring/heavysmoke.gif\"");
            printStream.println("super * \"fire:1\" \"\" \"boring/fire.gif\"");
            printStream.println("super * \"fire:2\" \"\" \"boring/fire.gif\"");
            printStream.println("");
            printStream.println("super * \"fortified:1\" \"\" \"boring/sandbags.gif\"");
            printStream.println("");
            printStream.println("super * \"arms:1\" \"\" \"limbs/arm1.gif\"");
            printStream.println("super * \"arms:2\" \"\" \"limbs/arm2.gif\"");
            printStream.println("super * \"arms:3\" \"\" \"limbs/arm2.gif\"");
            printStream.println("super * \"legs:1\" \"\" \"limbs/leg1.gif\"");
            printStream.println("super * \"legs:2\" \"\" \"limbs/leg2.gif\"");
            printStream.println("super * \"legs:3\" \"\" \"limbs/leg2.gif\"");
            printStream.println("");
            printStream.println("super * \"woods:1\" \"\" \"boring/lf0.gif;boring/lf1.gif;boring/lf2.gif;boring/lf3.gif;boring/lf4.gif\"");
            printStream.println("super * \"woods:2\" \"\" \"boring/hf0.gif;boring/hf1.gif;boring/hf2.gif;boring/hf3.gif\"");
            printStream.println("");
            printStream.println("base 0 \"\" \"\" \"boring/beige_plains_0.gif\"");
            printStream.println("base 1 \"\" \"\" \"boring/beige_plains_1.gif\"");
            printStream.println("base 2 \"\" \"\" \"boring/beige_plains_2.gif\"");
            printStream.println("base 3 \"\" \"\" \"boring/beige_plains_3.gif\"");
            printStream.println("base 4 \"\" \"\" \"boring/beige_plains_4.gif\"");
            printStream.println("base 5 \"\" \"\" \"boring/beige_plains_5.gif\"");
            printStream.println("base 6 \"\" \"\" \"boring/beige_plains_6.gif\"");
            printStream.println("base 7 \"\" \"\" \"boring/beige_plains_7.gif\"");
            printStream.println("base 8 \"\" \"\" \"boring/beige_plains_8.gif\"");
            printStream.println("base 9 \"\" \"\" \"boring/beige_plains_9.gif\"");
            printStream.println("base 10 \"\" \"\" \"boring/beige_plains_10.gif\"");
            printStream.println("base -1 \"\" \"\" \"boring/beige_sinkhole_1.gif\"");
            printStream.println("base -2 \"\" \"\" \"boring/beige_sinkhole_2.gif\"");
            printStream.println("base -3 \"\" \"\" \"boring/beige_sinkhole_3.gif\"");
            printStream.println("");
            printStream.println("base * \"impassable:1\" \"\" \"boring/rock.gif\"");
            printStream.println("");
            printStream.println("super * \"rough:1\" \"\" \"boring/rough_0.gif;boring/rough_1.gif;boring/rough_2.gif\"");
            printStream.println("");
            printStream.println("base 0 \"ice:1\" \"\" \"themes/ice_0.gif\"");
            printStream.println("base 1 \"ice:1\" \"\" \"themes/ice_1.gif\"");
            printStream.println("base 2 \"ice:1\" \"\" \"themes/ice_2.gif\"");
            printStream.println("base 3 \"ice:1\" \"\" \"themes/ice_3.gif\"");
            printStream.println("base 4 \"ice:1\" \"\" \"themes/ice_4.gif\"");
            printStream.println("base 5 \"ice:1\" \"\" \"themes/ice_5.gif\"");
            printStream.println("base 6 \"ice:1\" \"\" \"themes/ice_6.gif\"");
            printStream.println("base 7 \"ice:1\" \"\" \"themes/ice_7.gif\"");
            printStream.println("base 8 \"ice:1\" \"\" \"themes/ice_8.gif\"");
            printStream.println("base 9 \"ice:1\" \"\" \"themes/ice_9.gif\"");
            printStream.println("base 10 \"ice:1\" \"\" \"themes/ice_10.gif\"");
            printStream.println("base -1 \"ice:1\" \"\" \"themes/ice_-1.gif\"");
            printStream.println("base -2 \"ice:1\" \"\" \"themes/ice_-2.gif\"");
            printStream.println("base -3 \"ice:1\" \"\" \"themes/ice_-3.gif\"");
            printStream.println("base -4 \"ice:1\" \"\" \"themes/ice_-4.gif\"");
            printStream.println("base -5 \"ice:1\" \"\" \"themes/ice_-5.gif\"");
            printStream.println("base -6 \"ice:1\" \"\" \"themes/ice_-6.gif\"");
            printStream.println("");
            printStream.println("base * \"water:1\" \"\" \"boring/blue_water_1.gif\"");
            printStream.println("base * \"water:2\" \"\" \"boring/blue_water_2.gif\"");
            printStream.println("base * \"water:3\" \"\" \"boring/blue_water_3.gif\"");
            printStream.println("base * \"water:4\" \"\" \"boring/blue_water_4.gif\"");
            printStream.println("");
            printStream.println("base 0 \"pavement:1\" \"\" \"boring/grey_pavement_0.gif\"");
            printStream.println("base 1 \"pavement:1\" \"\" \"boring/grey_pavement_1.gif\"");
            printStream.println("base 2 \"pavement:1\" \"\" \"boring/grey_pavement_2.gif\"");
            printStream.println("base 3 \"pavement:1\" \"\" \"boring/grey_pavement_2.gif\"");
            printStream.println("base 4 \"pavement:1\" \"\" \"boring/grey_pavement_3.gif\"");
            printStream.println("base 5 \"pavement:1\" \"\" \"boring/grey_pavement_3.gif\"");
            printStream.println("base 6 \"pavement:1\" \"\" \"boring/grey_pavement_4.gif\"");
            printStream.println("base 7 \"pavement:1\" \"\" \"boring/grey_pavement_4.gif\"");
            printStream.println("base 8 \"pavement:1\" \"\" \"boring/grey_pavement_4.gif\"");
            printStream.println("base 9 \"pavement:1\" \"\" \"boring/grey_pavement_4.gif\"");
            printStream.println("base 10 \"pavement:1\" \"\" \"boring/grey_pavement_5.gif\"");
            printStream.println("base 20 \"pavement:1\" \"\" \"boring/grey_pavement_6.gif\"");
            printStream.println("base 30 \"pavement:1\" \"\" \"boring/grey_pavement_7.gif\"");
            printStream.println("base 40 \"pavement:1\" \"\" \"boring/grey_pavement_8.gif\"");
            printStream.println("");
            printStream.println("base 0 \"swamp:1\" \"\" \"swamp/swamp_clear_0.gif\"");
            printStream.println("base 0 \"swamp:2\" \"\" \"swamp/swamp_clear_0a.gif\"");
            printStream.println("base 0 \"swamp:3\" \"\" \"swamp/swamp_clear_0b.gif\"");
            printStream.println("base 0 \"swamp:4\" \"\" \"swamp/swamp_clear_0c.gif\"");
            printStream.println("base 1 \"swamp:1\" \"\" \"swamp/swamp_clear_1.gif\"");
            printStream.println("base 2 \"swamp:1\" \"\" \"swamp/swamp_clear_2.gif\"");
            printStream.println("base 3 \"swamp:1\" \"\" \"swamp/swamp_clear_3.gif\"");
            printStream.println("base 4 \"swamp:1\" \"\" \"swamp/swamp_clear_4.gif\"");
            printStream.println("base 5 \"swamp:1\" \"\" \"swamp/swamp_clear_5.gif\"");
            printStream.println("base 6 \"swamp:1\" \"\" \"swamp/swamp_clear_6.gif\"");
            printStream.println("base 7 \"swamp:1\" \"\" \"swamp/swamp_clear_7.gif\"");
            printStream.println("base 8 \"swamp:1\" \"\" \"swamp/swamp_clear_8.gif\"");
            printStream.println("base 9 \"swamp:1\" \"\" \"swamp/swamp_clear_9.gif\"");
            printStream.println("base 10 \"swamp:1\" \"\" \"swamp/swamp_clear_10.gif\"");
            printStream.println("base -1 \"swamp:1\" \"\" \"swamp/swamp_clear_-1.gif\"");
            printStream.println("base -2 \"swamp:1\" \"\" \"swamp/swamp_clear_-2.gif\"");
            printStream.println("base -3 \"swamp:1\" \"\" \"swamp/swamp_clear_-3.gif\"");
            printStream.println("base 0 \"rough:1;swamp:1\" \"\" \"swamp/swamp_rough_0.gif\"");
            printStream.println("base 0 \"rough:1;swamp:2\" \"\" \"swamp/swamp_rough_0a.gif\"");
            printStream.println("base 0 \"rough:1;swamp:3\" \"\" \"swamp/swamp_rough_0b.gif\"");
            printStream.println("base 0 \"rough:1;swamp:4\" \"\" \"swamp/swamp_rough_0c.gif\"");
            printStream.println("base 1 \"rough:1;swamp:1\" \"\" \"swamp/swamp_rough_1.gif\"");
            printStream.println("base 2 \"rough:1;swamp:1\" \"\" \"swamp/swamp_rough_2.gif\"");
            printStream.println("base 3 \"rough:1;swamp:1\" \"\" \"swamp/swamp_rough_3.gif\"");
            printStream.println("base 4 \"rough:1;swamp:1\" \"\" \"swamp/swamp_rough_4.gif\"");
            printStream.println("base 5 \"rough:1;swamp:1\" \"\" \"swamp/swamp_rough_5.gif\"");
            printStream.println("base 6 \"rough:1;swamp:1\" \"\" \"swamp/swamp_rough_6.gif\"");
            printStream.println("base 7 \"rough:1;swamp:1\" \"\" \"swamp/swamp_rough_7.gif\"");
            printStream.println("base 8 \"rough:1;swamp:1\" \"\" \"swamp/swamp_rough_8.gif\"");
            printStream.println("base 9 \"rough:1;swamp:1\" \"\" \"swamp/swamp_rough_9.gif\"");
            printStream.println("base -1 \"rough:1;swamp:1\" \"\" \"swamp/swamp_rough_-1.gif\"");
            printStream.println("base -2 \"rough:1;swamp:1\" \"\" \"swamp/swamp_rough_-2.gif\"");
            printStream.println("base -3 \"rough:1;swamp:1\" \"\" \"swamp/swamp_rough_-3.gif\"");
            printStream.println("base 0 \"woods:1;swamp:1\" \"\" \"swamp/swamp_light_forest_0.gif\"");
            printStream.println("base 1 \"woods:1;swamp:1\" \"\" \"swamp/swamp_light_forest_1.gif\"");
            printStream.println("base 2 \"woods:1;swamp:1\" \"\" \"swamp/swamp_light_forest_2.gif\"");
            printStream.println("base 0 \"woods:2;swamp:1\" \"\" \"swamp/swamp_heavy_forest_0.gif\"");
            printStream.println("base 1 \"woods:2;swamp:1\" \"\" \"swamp/swamp_heavy_forest_1.gif\"");
            printStream.println("");
            printStream.println("base -2 \"magma:1\" \"\" \"magma/crust_-2.gif\"");
            printStream.println("base -1 \"magma:1\" \"\" \"magma/crust_-1.gif\"");
            printStream.println("base 0 \"magma:1\" \"\" \"magma/crust_0.gif\"");
            printStream.println("base 1 \"magma:1\" \"\" \"magma/crust_1.gif\"");
            printStream.println("base 2 \"magma:1\" \"\" \"magma/crust_2.gif\"");
            printStream.println("base 3 \"magma:1\" \"\" \"magma/crust_3.gif\"");
            printStream.println("");
            printStream.println("base -2 \"magma:2\" \"\" \"magma/magma_-2.gif\"");
            printStream.println("base -1 \"magma:2\" \"\" \"magma/magma_-1.gif\"");
            printStream.println("base 0 \"magma:2\" \"\" \"magma/magma_0.gif\"");
            printStream.println("base 1 \"magma:2\" \"\" \"magma/magma_1.gif\"");
            printStream.println("base 2 \"magma:2\" \"\" \"magma/magma_2.gif\"");
            printStream.println("base 3 \"magma:2\" \"\" \"magma/magma_3.gif\"");
            printStream.println("");
            printStream.println("base -2 \"mud:1\" \"\" \"mud/mud_-2.gif\"");
            printStream.println("base -1 \"mud:1\" \"\" \"mud/mud_-1.gif\"");
            printStream.println("base 0 \"mud:1\" \"\" \"mud/mud_0.gif\"");
            printStream.println("base 1 \"mud:1\" \"\" \"mud/mud_1.gif\"");
            printStream.println("base 2 \"mud:1\" \"\" \"mud/mud_2.gif\"");
            printStream.println("base 3 \"mud:1\" \"\" \"mud/mud_3.gif\"");
            printStream.println("");
            printStream.println("base -2 \"mud:2\" \"\" \"mud/deepmud_-2.gif\"");
            printStream.println("base -1 \"mud:2\" \"\" \"mud/deepmud_-1.gif\"");
            printStream.println("base 0 \"mud:2\" \"\" \"mud/deepmud_0.gif\"");
            printStream.println("base 1 \"mud:2\" \"\" \"mud/deepmud_1.gif\"");
            printStream.println("base 2 \"mud:2\" \"\" \"mud/deepmud_2.gif\"");
            printStream.println("base 3 \"mud:2\" \"\" \"mud/deepmud_3.gif\"");
            printStream.println("");
            printStream.println("base -2 \"sand:1\" \"\" \"sand/sand_-2.gif\"");
            printStream.println("base -1 \"sand:1\" \"\" \"sand/sand_-1.gif\"");
            printStream.println("base 0 \"sand:1\" \"\" \"sand/sand_0.gif\"");
            printStream.println("base 1 \"sand:1\" \"\" \"sand/sand_1.gif\"");
            printStream.println("base 2 \"sand:1\" \"\" \"sand/sand_2.gif\"");
            printStream.println("base 3 \"sand:1\" \"\" \"sand/sand_3.gif\"");
            printStream.println("");
            printStream.println("base -2 \"tundra:1\" \"\" \"tundra/tundra_-2.gif\"");
            printStream.println("base -1 \"tundra:1\" \"\" \"tundra/tundra_-1.gif\"");
            printStream.println("base 0 \"tundra:1\" \"\" \"tundra/tundra_0.gif\"");
            printStream.println("base 1 \"tundra:1\" \"\" \"tundra/tundra_1.gif\"");
            printStream.println("base 2 \"tundra:1\" \"\" \"tundra/tundra_2.gif\"");
            printStream.println("base 3 \"tundra:1\" \"\" \"tundra/tundra_3.gif\"");
            printStream.println("");
            printStream.println("#------------------- BEGIN snow theme");
            printStream.println("");
            printStream.println("base 0 \"\" \"snow\" \"themes/snow_0.gif\"");
            printStream.println("base 1 \"\" \"snow\" \"themes/snow_1.gif\"");
            printStream.println("base 2 \"\" \"snow\" \"themes/snow_2.gif\"");
            printStream.println("base 3 \"\" \"snow\" \"themes/snow_3.gif\"");
            printStream.println("base 4 \"\" \"snow\" \"themes/snow_4.gif\"");
            printStream.println("base 5 \"\" \"snow\" \"themes/snow_5.gif\"");
            printStream.println("base 6 \"\" \"snow\" \"themes/snow_6.gif\"");
            printStream.println("base 7 \"\" \"snow\" \"themes/snow_7.gif\"");
            printStream.println("base 8 \"\" \"snow\" \"themes/snow_8.gif\"");
            printStream.println("base 9 \"\" \"snow\" \"themes/snow_9.gif\"");
            printStream.println("base 10 \"\" \"snow\" \"themes/snow_10.gif\"");
            printStream.println("base -1 \"\" \"snow\" \"themes/snow_-1.gif\"");
            printStream.println("base -2 \"\" \"snow\" \"themes/snow_-2.gif\"");
            printStream.println("base -3 \"\" \"snow\" \"themes/snow_-3.gif\"");
            printStream.println("base -4 \"\" \"snow\" \"themes/snow_-4.gif\"");
            printStream.println("base -5 \"\" \"snow\" \"themes/snow_-5.gif\"");
            printStream.println("base -6 \"\" \"snow\" \"themes/snow_-6.gif\"");
            printStream.println("");
            printStream.println("base 0 \"pavement:1\" \"snow\" \"themes/ice_0.gif\"");
            printStream.println("base 1 \"pavement:1\" \"snow\" \"themes/ice_1.gif\"");
            printStream.println("base 2 \"pavement:1\" \"snow\" \"themes/ice_2.gif\"");
            printStream.println("base 3 \"pavement:1\" \"snow\" \"themes/ice_3.gif\"");
            printStream.println("base 4 \"pavement:1\" \"snow\" \"themes/ice_4.gif\"");
            printStream.println("base 5 \"pavement:1\" \"snow\" \"themes/ice_5.gif\"");
            printStream.println("base 6 \"pavement:1\" \"snow\" \"themes/ice_6.gif\"");
            printStream.println("base 7 \"pavement:1\" \"snow\" \"themes/ice_7.gif\"");
            printStream.println("base 8 \"pavement:1\" \"snow\" \"themes/ice_8.gif\"");
            printStream.println("base 9 \"pavement:1\" \"snow\" \"themes/ice_9.gif\"");
            printStream.println("base 10 \"pavement:1\" \"snow\" \"themes/ice_10.gif\"");
            printStream.println("base -1 \"pavement:1\" \"snow\" \"themes/ice_-1.gif\"");
            printStream.println("base -2 \"pavement:1\" \"snow\" \"themes/ice_-2.gif\"");
            printStream.println("base -3 \"pavement:1\" \"snow\" \"themes/ice_-3.gif\"");
            printStream.println("base -4 \"pavement:1\" \"snow\" \"themes/ice_-4.gif\"");
            printStream.println("base -5 \"pavement:1\" \"snow\" \"themes/ice_-5.gif\"");
            printStream.println("base -6 \"pavement:1\" \"snow\" \"themes/ice_-6.gif\"");
            printStream.println("");
            printStream.println("base 0 \"rough:1\" \"snow\" \"themes/snow_rough_0.gif\"");
            printStream.println("base 1 \"rough:1\" \"snow\" \"themes/snow_rough_1.gif\"");
            printStream.println("base 3 \"rough:1\" \"snow\" \"themes/snow_rough_3.gif\"");
            printStream.println("base 5 \"rough:1\" \"snow\" \"themes/snow_rough_5.gif\"");
            printStream.println("base -1 \"rough:1\" \"snow\" \"themes/snow_rough_-1.gif\"");
            printStream.println("base -3 \"rough:1\" \"snow\" \"themes/snow_rough_-3.gif\"");
            printStream.println("base -5 \"rough:1\" \"snow\" \"themes/snow_rough_-5.gif\"");
            printStream.println("");
            printStream.println("base 0 \"woods:1\" \"snow\" \"themes/snow_light_forest_0.gif\"");
            printStream.println("base 1 \"woods:1\" \"snow\" \"themes/snow_light_forest_1.gif\"");
            printStream.println("base 2 \"woods:1\" \"snow\" \"themes/snow_light_forest_2.gif\"");
            printStream.println("base 0 \"woods:2\" \"snow\" \"themes/snow_heavy_forest_0.gif\"");
            printStream.println("base 1 \"woods:2\" \"snow\" \"themes/snow_heavy_forest_1.gif\"");
            printStream.println("");
            printStream.println("#------------------- END snow theme");
            printStream.println("");
            printStream.println("#------------------- BEGIN grass theme");
            printStream.println("");
            printStream.println("base 0 \"\" \"grass\" \"grass/grass_plains_0.gif\"");
            printStream.println("base 1 \"\" \"grass\" \"grass/grass_plains_1.gif\"");
            printStream.println("base 2 \"\" \"grass\" \"grass/grass_plains_2.gif\"");
            printStream.println("base 3 \"\" \"grass\" \"grass/grass_plains_3.gif\"");
            printStream.println("base 4 \"\" \"grass\" \"grass/grass_plains_4.gif\"");
            printStream.println("base 5 \"\" \"grass\" \"grass/grass_plains_5.gif\"");
            printStream.println("base 6 \"\" \"grass\" \"grass/grass_plains_6.gif\"");
            printStream.println("base 7 \"\" \"grass\" \"grass/grass_plains_7.gif\"");
            printStream.println("base 8 \"\" \"grass\" \"grass/grass_plains_8.gif\"");
            printStream.println("base 9 \"\" \"grass\" \"grass/grass_plains_9.gif\"");
            printStream.println("base 10 \"\" \"grass\" \"grass/grass_plains_10.gif\"");
            printStream.println("base -1 \"\" \"grass\" \"grass/grass_sinkhole_1.gif\"");
            printStream.println("base -2 \"\" \"grass\" \"grass/grass_sinkhole_2.gif\"");
            printStream.println("base -3 \"\" \"grass\" \"grass/grass_sinkhole_3.gif\"");
            printStream.println("");
            printStream.println("base 0 \"swamp:1\" \"grass\" \"grass/grass_swamp_0.gif\"");
            printStream.println("base 0 \"swamp:2\" \"grass\" \"grass/grass_swamp_0.gif\"");
            printStream.println("base 0 \"swamp:3\" \"grass\" \"grass/grass_swamp_0.gif\"");
            printStream.println("base 0 \"swamp:4\" \"grass\" \"grass/grass_swamp_0.gif\"");
            printStream.println("base 1 \"swamp:1\" \"grass\" \"grass/grass_swamp_1.gif\"");
            printStream.println("base 2 \"swamp:1\" \"grass\" \"grass/grass_swamp_2.gif\"");
            printStream.println("base 3 \"swamp:1\" \"grass\" \"grass/grass_swamp_3.gif\"");
            printStream.println("base 4 \"swamp:1\" \"grass\" \"grass/grass_swamp_4.gif\"");
            printStream.println("base 5 \"swamp:1\" \"grass\" \"grass/grass_swamp_5.gif\"");
            printStream.println("base 6 \"swamp:1\" \"grass\" \"grass/grass_swamp_6.gif\"");
            printStream.println("base 7 \"swamp:1\" \"grass\" \"grass/grass_swamp_7.gif\"");
            printStream.println("base 8 \"swamp:1\" \"grass\" \"grass/grass_swamp_8.gif\"");
            printStream.println("base 9 \"swamp:1\" \"grass\" \"grass/grass_swamp_9.gif\"");
            printStream.println("base 10 \"swamp:1\" \"grass\" \"grass/grass_swamp_10.gif\"");
            printStream.println("base -1 \"swamp:1\" \"grass\" \"grass/grass_swamp_-1.gif\"");
            printStream.println("base -2 \"swamp:1\" \"grass\" \"grass/grass_swamp_-2.gif\"");
            printStream.println("base -3 \"swamp:1\" \"grass\" \"grass/grass_swamp_-3.gif\"");
            printStream.println("base 0 \"woods:1;swamp:1\" \"grass\" \"grass/grass_l_swamp_0.gif\"");
            printStream.println("base 1 \"woods:1;swamp:1\" \"grass\" \"grass/grass_l_swamp_1.gif\"");
            printStream.println("base 2 \"woods:1;swamp:1\" \"grass\" \"grass/grass_l_swamp_2.gif\"");
            printStream.println("base 0 \"woods:2;swamp:1\" \"grass\" \"grass/grass_h_swamp_0.gif\"");
            printStream.println("base 1 \"woods:2;swamp:1\" \"grass\" \"grass/grass_h_swamp_1.gif\"");
            printStream.println("");
            printStream.println("#------------------- END grass theme");
            printStream.println("");
            printStream.println("#------------------- BEGIN mars theme");
            printStream.println("");
            printStream.println("base 0 \"\" \"mars\" \"mars/mars_plains_0.gif\"");
            printStream.println("base 1 \"\" \"mars\" \"mars/mars_plains_1.gif\"");
            printStream.println("base 2 \"\" \"mars\" \"mars/mars_plains_2.gif\"");
            printStream.println("base 3 \"\" \"mars\" \"mars/mars_plains_3.gif\"");
            printStream.println("base 4 \"\" \"mars\" \"mars/mars_plains_4.gif\"");
            printStream.println("base 5 \"\" \"mars\" \"mars/mars_plains_5.gif\"");
            printStream.println("base 6 \"\" \"mars\" \"mars/mars_plains_6.gif\"");
            printStream.println("base 7 \"\" \"mars\" \"mars/mars_plains_7.gif\"");
            printStream.println("base 8 \"\" \"mars\" \"mars/mars_plains_8.gif\"");
            printStream.println("base 9 \"\" \"mars\" \"mars/mars_plains_9.gif\"");
            printStream.println("base 10 \"\" \"mars\" \"mars/mars_plains_10.gif\"");
            printStream.println("base -1 \"\" \"mars\" \"mars/mars_sinkhole_1.gif\"");
            printStream.println("base -2 \"\" \"mars\" \"mars/mars_sinkhole_2.gif\"");
            printStream.println("base -3 \"\" \"mars\" \"mars/mars_sinkhole_3.gif\"");
            printStream.println("");
            printStream.println("#------------------- END mars theme");
            printStream.println("");
            printStream.println("#------------------- BEGIN lunar theme");
            printStream.println("");
            printStream.println("base 0 \"\" \"lunar\" \"lunar/lunar_plains_0.gif\"");
            printStream.println("base 1 \"\" \"lunar\" \"lunar/lunar_plains_1.gif\"");
            printStream.println("base 2 \"\" \"lunar\" \"lunar/lunar_plains_2.gif\"");
            printStream.println("base 3 \"\" \"lunar\" \"lunar/lunar_plains_3.gif\"");
            printStream.println("base 4 \"\" \"lunar\" \"lunar/lunar_plains_4.gif\"");
            printStream.println("base 5 \"\" \"lunar\" \"lunar/lunar_plains_5.gif\"");
            printStream.println("base 6 \"\" \"lunar\" \"lunar/lunar_plains_6.gif\"");
            printStream.println("base 7 \"\" \"lunar\" \"lunar/lunar_plains_7.gif\"");
            printStream.println("base 8 \"\" \"lunar\" \"lunar/lunar_plains_8.gif\"");
            printStream.println("base 9 \"\" \"lunar\" \"lunar/lunar_plains_9.gif\"");
            printStream.println("base 10 \"\" \"lunar\" \"lunar/lunar_plains_10.gif\"");
            printStream.println("base -1 \"\" \"lunar\" \"lunar/lunar_sinkhole_1.gif\"");
            printStream.println("base -2 \"\" \"lunar\" \"lunar/lunar_sinkhole_2.gif\"");
            printStream.println("base -3 \"\" \"lunar\" \"lunar/lunar_sinkhole_3.gif\"");
            printStream.println("");
            printStream.println("#------------------- END lunar theme");
            printStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class EntityImage {
        private Image base;
        private Image wreck;
        private Image icon;
        private int tint;
        private Image camo;
        private Image[] facings = new Image[6];
        private Image[] wreckFacings = new Image[6];
        private Component parent;
        private static final int IMG_WIDTH = 84;
        private static final int IMG_HEIGHT = 72;
        private static final int IMG_SIZE = 6048;

        public EntityImage(Image image, int n, Image image2, Component component) {
            this(image, null, n, image2, component);
        }

        public EntityImage(Image image, Image image2, int n, Image image3, Component component) {
            this.base = image;
            this.tint = n;
            this.camo = image3;
            this.parent = component;
            this.wreck = image2;
        }

        public void loadFacings() {
            FilteredImageSource filteredImageSource;
            int n;
            this.base = this.applyColor(this.base);
            this.icon = this.base.getScaledInstance(56, 48, 4);
            for (n = 0; n < 6; ++n) {
                filteredImageSource = new FilteredImageSource(this.base.getSource(), new RotateFilter(1.0471975511965976 * (double)(6 - n)));
                this.facings[n] = this.parent.createImage(filteredImageSource);
            }
            if (this.wreck != null) {
                this.wreck = this.applyColor(this.wreck);
                for (n = 0; n < 6; ++n) {
                    filteredImageSource = new FilteredImageSource(this.wreck.getSource(), new RotateFilter(1.0471975511965976 * (double)(6 - n)));
                    this.wreckFacings[n] = this.parent.createImage(filteredImageSource);
                }
            }
        }

        public Image loadPreviewImage() {
            this.base = this.applyColor(this.base);
            return this.base;
        }

        public Image getFacing(int n) {
            return this.facings[n];
        }

        public Image getWreckFacing(int n) {
            return this.wreckFacings[n];
        }

        public Image getBase() {
            return this.base;
        }

        public Image getIcon() {
            return this.icon;
        }

        private Image applyColor(Image image) {
            boolean bl = this.camo != null;
            Image image2 = image;
            int[] nArray = new int[6048];
            int[] nArray2 = new int[6048];
            PixelGrabber pixelGrabber = new PixelGrabber(image2, 0, 0, 84, 72, nArray, 0, 84);
            try {
                pixelGrabber.grabPixels();
            }
            catch (Exception exception) {
                System.err.println("EntityImage.applyColor(): Failed to grab pixels for mech image." + exception.getMessage());
                return image;
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                System.err.println("EntityImage.applyColor(): Failed to grab pixels for mech image. ImageObserver aborted.");
                return image;
            }
            if (bl) {
                PixelGrabber pixelGrabber2 = new PixelGrabber(this.camo, 0, 0, 84, 72, nArray2, 0, 84);
                try {
                    pixelGrabber2.grabPixels();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("EntityImage.applyColor(): Failed to grab pixels for camo image." + interruptedException.getMessage());
                    return image;
                }
                if ((pixelGrabber2.getStatus() & 0x80) != 0) {
                    System.err.println("EntityImage.applyColor(): Failed to grab pixels for mech image. ImageObserver aborted.");
                    return image;
                }
            }
            for (int i = 0; i < 6048; ++i) {
                int n = nArray[i];
                int n2 = n >> 24 & 0xFF;
                if (n2 == 0) continue;
                int n3 = bl ? nArray2[i] : this.tint;
                float f = (float)(n3 >> 16 & 0xFF) / 255.0f;
                float f2 = (float)(n3 >> 8 & 0xFF) / 255.0f;
                float f3 = (float)(n3 & 0xFF) / 255.0f;
                float f4 = nArray[i] & 0xFF;
                int n4 = Math.round(f * f4);
                int n5 = Math.round(f2 * f4);
                int n6 = Math.round(f3 * f4);
                nArray[i] = n2 << 24 | n4 << 16 | n5 << 8 | n6;
            }
            image = this.parent.createImage(new MemoryImageSource(84, 72, nArray, 0, 84));
            return image;
        }
    }
}

