/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionAdapter;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.composite.internal.IncludedBuildController;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.initialization.ReportedException;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.concurrent.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultIncludedBuildController
implements Runnable,
Stoppable,
IncludedBuildController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIncludedBuildController.class);
    private final IncludedBuildState includedBuild;
    private final Lock lock = new ReentrantLock();
    private final Condition stateChange = this.lock.newCondition();
    private final Map<String, TaskState> tasks = Maps.newLinkedHashMap();
    private final Set<String> tasksAdded = Sets.newHashSet();
    private final List<Throwable> taskFailures = new ArrayList<Throwable>();
    private State state = State.CollectingTasks;
    private boolean stopRequested;

    public DefaultIncludedBuildController(IncludedBuildState includedBuild) {
        this.includedBuild = includedBuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean populateTaskGraph() {
        LinkedHashSet tasksToExecute = Sets.newLinkedHashSet();
        this.lock.lock();
        try {
            if (this.state != State.CollectingTasks) {
                throw new IllegalStateException();
            }
            for (Map.Entry<String, TaskState> taskEntry : this.tasks.entrySet()) {
                String taskName;
                if (taskEntry.getValue().status != TaskStatus.QUEUED || !this.tasksAdded.add(taskName = taskEntry.getKey())) continue;
                tasksToExecute.add(taskName);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (tasksToExecute.isEmpty()) {
            return false;
        }
        this.includedBuild.addTasks((Iterable)tasksToExecute);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Set<String> tasksToExecute;
        while ((tasksToExecute = this.getQueuedTasks()) != null) {
            try {
                this.doBuild(tasksToExecute);
            }
            catch (ReportedException reportedException) {}
            continue;
            finally {
                this.setState(State.CollectingTasks);
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State state) {
        this.lock.lock();
        try {
            this.state = state;
            this.stateChange.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void startTaskExecution() {
        this.setState(State.RunningTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitTaskCompletion(Collection<? super Throwable> taskFailures) {
        this.lock.lock();
        try {
            while (this.state == State.RunningTasks) {
                try {
                    this.stateChange.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            taskFailures.addAll(this.taskFailures);
            this.taskFailures.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ArrayList failures = new ArrayList();
        this.awaitTaskCompletion(failures);
        if (!failures.isEmpty()) {
            throw new MultipleBuildFailures(failures);
        }
        this.lock.lock();
        try {
            this.stopRequested = true;
            this.stateChange.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Set<String> getQueuedTasks() {
        this.lock.lock();
        try {
            while (this.state == State.CollectingTasks && !this.stopRequested) {
                try {
                    this.stateChange.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            if (this.stopRequested) {
                Set<String> e = null;
                return e;
            }
            LinkedHashSet tasksToExecute = Sets.newLinkedHashSet();
            for (Map.Entry<String, TaskState> taskEntry : this.tasks.entrySet()) {
                if (taskEntry.getValue().status != TaskStatus.QUEUED) continue;
                tasksToExecute.add(taskEntry.getKey());
                taskEntry.getValue().status = TaskStatus.EXECUTING;
            }
            LinkedHashSet linkedHashSet = tasksToExecute;
            return linkedHashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doBuild(Collection<String> tasksToExecute) {
        if (tasksToExecute.isEmpty()) {
            return;
        }
        LOGGER.info("Executing " + this.includedBuild.getName() + " tasks " + tasksToExecute);
        IncludedBuildExecutionListener listener = new IncludedBuildExecutionListener(tasksToExecute);
        this.includedBuild.execute(tasksToExecute, (Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskCompleted(String task, Throwable failure) {
        this.lock.lock();
        try {
            TaskState taskState = this.tasks.get(task);
            taskState.status = failure == null ? TaskStatus.SUCCESS : TaskStatus.FAILED;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tasksDone(Collection<String> tasksExecuted, BuildResult result) {
        this.lock.lock();
        try {
            for (String task : tasksExecuted) {
                TaskState taskState = this.tasks.get(task);
                if (taskState.status != TaskStatus.EXECUTING) continue;
                taskState.status = TaskStatus.FAILED;
            }
            if (result.getFailure() != null) {
                if (result.getFailure() instanceof MultipleBuildFailures) {
                    this.taskFailures.addAll(((MultipleBuildFailures)result.getFailure()).getCauses());
                } else {
                    this.taskFailures.add(result.getFailure());
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueForExecution(String taskPath) {
        this.lock.lock();
        try {
            if (this.state != State.CollectingTasks) {
                throw new IllegalStateException();
            }
            if (!this.tasks.containsKey(taskPath)) {
                this.tasks.put(taskPath, new TaskState());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncludedBuildTaskResource.State getTaskState(String taskPath) {
        this.lock.lock();
        try {
            TaskState state = this.tasks.get(taskPath);
            if (state == null) {
                throw new IllegalStateException("Included build task '" + taskPath + "' was never scheduled for execution.");
            }
            if (state.status == TaskStatus.FAILED) {
                IncludedBuildTaskResource.State state2 = IncludedBuildTaskResource.State.FAILED;
                return state2;
            }
            if (state.status == TaskStatus.SUCCESS) {
                IncludedBuildTaskResource.State state3 = IncludedBuildTaskResource.State.SUCCESS;
                return state3;
            }
            IncludedBuildTaskResource.State state4 = IncludedBuildTaskResource.State.WAITING;
            return state4;
        }
        finally {
            this.lock.unlock();
        }
    }

    private class IncludedBuildExecutionListener
    extends InternalBuildAdapter
    implements TaskExecutionGraphListener,
    BuildListener {
        private final Collection<String> tasksToExecute;

        IncludedBuildExecutionListener(Collection<String> tasksToExecute) {
            this.tasksToExecute = tasksToExecute;
        }

        public void graphPopulated(TaskExecutionGraph taskExecutionGraph) {
            for (String task : this.tasksToExecute) {
                if (taskExecutionGraph.hasTask(task)) continue;
                throw new GradleException("Task '" + task + "' not found in build '" + DefaultIncludedBuildController.this.includedBuild.getName() + "'.");
            }
            taskExecutionGraph.addTaskExecutionListener((TaskExecutionListener)new TaskCompletionRecorder());
        }

        public void buildFinished(BuildResult result) {
            DefaultIncludedBuildController.this.tasksDone(this.tasksToExecute, result);
        }

        private class TaskCompletionRecorder
        extends TaskExecutionAdapter {
            private TaskCompletionRecorder() {
            }

            public void afterExecute(Task task, org.gradle.api.tasks.TaskState state) {
                String taskPath = task.getPath();
                Throwable failure = state.getFailure();
                if (IncludedBuildExecutionListener.this.tasksToExecute.contains(taskPath)) {
                    DefaultIncludedBuildController.this.taskCompleted(taskPath, failure);
                }
            }
        }
    }

    private static class TaskState {
        public BuildResult result;
        public TaskStatus status = TaskStatus.QUEUED;

        private TaskState() {
        }
    }

    private static enum TaskStatus {
        QUEUED,
        EXECUTING,
        FAILED,
        SUCCESS;

    }

    private static enum State {
        CollectingTasks,
        RunningTasks;

    }
}

