/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.UnionVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;

public class DefaultResolvedVersionConstraint
implements ResolvedVersionConstraint {
    private final VersionSelector preferredVersionSelector;
    private final VersionSelector rejectedVersionsSelector;
    private final boolean rejectAll;
    private final boolean prefer;

    public DefaultResolvedVersionConstraint(VersionConstraint parent, VersionSelectorScheme scheme) {
        this(parent.getRequiredVersion(), parent.getPreferredVersion(), parent.getStrictVersion(), parent.getRejectedVersions(), scheme);
    }

    @VisibleForTesting
    public DefaultResolvedVersionConstraint(String requiredVersion, String preferredVersion, String strictVersion, List<String> rejectedVersions, VersionSelectorScheme scheme) {
        boolean strict = !strictVersion.isEmpty();
        boolean bl = this.prefer = requiredVersion.isEmpty() && !preferredVersion.isEmpty();
        String version = strict ? strictVersion : (this.prefer ? preferredVersion : requiredVersion);
        this.preferredVersionSelector = scheme.parseSelector(version);
        if (strict) {
            if (!rejectedVersions.isEmpty()) {
                throw new IllegalArgumentException("Cannot combine 'strict' and'reject' in a single version constraint.");
            }
            this.rejectedVersionsSelector = this.getRejectionForStrict(version, scheme);
            this.rejectAll = false;
        } else {
            this.rejectedVersionsSelector = DefaultResolvedVersionConstraint.toRejectSelector(scheme, rejectedVersions);
            this.rejectAll = DefaultResolvedVersionConstraint.isRejectAll(version, rejectedVersions);
        }
    }

    private VersionSelector getRejectionForStrict(String version, VersionSelectorScheme versionSelectorScheme) {
        VersionSelector preferredSelector = versionSelectorScheme.parseSelector(version);
        return versionSelectorScheme.complementForRejection(preferredSelector);
    }

    private DefaultResolvedVersionConstraint(VersionSelector preferredVersionSelector, VersionSelector rejectedVersionsSelector, boolean prefer) {
        this.preferredVersionSelector = preferredVersionSelector;
        this.rejectedVersionsSelector = rejectedVersionsSelector;
        this.rejectAll = false;
        this.prefer = prefer;
    }

    public ResolvedVersionConstraint withRejectSelector(VersionSelector rejectSelector) {
        return new DefaultResolvedVersionConstraint(this.preferredVersionSelector, rejectSelector, this.prefer);
    }

    private static VersionSelector toRejectSelector(VersionSelectorScheme scheme, List<String> rejectedVersions) {
        if (rejectedVersions.size() > 1) {
            return UnionVersionSelector.of(rejectedVersions, scheme);
        }
        return rejectedVersions.isEmpty() ? null : scheme.parseSelector(rejectedVersions.get(0));
    }

    @Override
    public VersionSelector getPreferredSelector() {
        return this.preferredVersionSelector;
    }

    @Override
    public VersionSelector getRejectedSelector() {
        return this.rejectedVersionsSelector;
    }

    @Override
    public boolean isRejectAll() {
        return this.rejectAll;
    }

    @Override
    public boolean isPrefer() {
        return this.prefer;
    }

    private static boolean isRejectAll(String preferredVersion, List<String> rejectedVersions) {
        return "".equals(preferredVersion) && DefaultResolvedVersionConstraint.hasMatchAllSelector(rejectedVersions);
    }

    private static boolean hasMatchAllSelector(List<String> rejectedVersions) {
        for (String version : rejectedVersions) {
            if (!"+".equals(version)) continue;
            return true;
        }
        return false;
    }
}

